/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: sequence.cxx,v $
 * $Revision: 1.6 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_comphelper.hxx"
#include <comphelper/sequence.hxx>

//.........................................................................
namespace comphelper
{
//.........................................................................

//------------------------------------------------------------------------------
staruno::Sequence<sal_Int16> findValue(const staruno::Sequence< ::rtl::OUString >& _rList, const ::rtl::OUString& _rValue, sal_Bool _bOnlyFirst)
{
	sal_Int32 nLength = _rList.getLength();

	if( _bOnlyFirst )
	{
		//////////////////////////////////////////////////////////////////////
		// An welcher Position finde ich den Wert?
		sal_Int32 nPos = -1;
		const ::rtl::OUString* pTArray = _rList.getConstArray();
		for (sal_Int32 i = 0; i < nLength; ++i, ++pTArray)
		{
			if( pTArray->equals(_rValue) )
			{
				nPos = i;
				break;
			}
		}

		//////////////////////////////////////////////////////////////////////
		// Sequence fuellen
		if( nPos>-1 )
		{
			staruno::Sequence<sal_Int16> aRetSeq( 1 );
			aRetSeq.getArray()[0] = (sal_Int16)nPos;

			return aRetSeq;
		}

		return staruno::Sequence<sal_Int16>();

	}
	else
	{
		staruno::Sequence<sal_Int16> aRetSeq( nLength );
		sal_Int16* pReturn = aRetSeq.getArray();

		//////////////////////////////////////////////////////////////////////
		// Wie oft kommt der Wert vor?
		const ::rtl::OUString* pTArray = _rList.getConstArray();
		for (sal_Int32 i = 0; i < nLength; ++i, ++pTArray)
		{
			if( pTArray->equals(_rValue) )
			{
				*pReturn = (sal_Int16)i;
				++pReturn;
			}
		}

		aRetSeq.realloc(pReturn - aRetSeq.getArray());

		return aRetSeq;
	}
}
// -----------------------------------------------------------------------------
sal_Bool existsValue(const ::rtl::OUString& Value,const staruno::Sequence< ::rtl::OUString >& _aList)
{
    const ::rtl::OUString * pIter	= _aList.getConstArray();
	const ::rtl::OUString * pEnd	= pIter + _aList.getLength();
	return ::std::find(pIter,pEnd,Value) != pEnd;
}

//.........................................................................
}	// namespace comphelper
//.........................................................................

