/*************************************************************************
*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: ScenarioSelector.java,v $
 * $Revision: 1.9 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/package com.sun.star.wizards.table;

import java.util.Hashtable;
import java.util.Vector;

import com.sun.star.awt.ItemEvent;
import com.sun.star.awt.XButton;
import com.sun.star.awt.XFixedText;
import com.sun.star.awt.XItemListener;
import com.sun.star.awt.XListBox;
import com.sun.star.awt.XRadioButton;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNameAccess;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.Locale;
import com.sun.star.lang.XMultiServiceFactory;
//import com.sun.star.uno.Exception;
import com.sun.star.sdbc.SQLException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.wizards.common.Configuration;
import com.sun.star.wizards.common.Desktop;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.db.TableDescriptor;
import com.sun.star.wizards.ui.FieldSelection;
import com.sun.star.wizards.ui.UIConsts;
import com.sun.star.wizards.ui.UnoDialog;
import com.sun.star.wizards.ui.WizardDialog;
import com.sun.star.wizards.ui.XFieldSelectionListener;


/**
 * @author Administrator
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class ScenarioSelector extends FieldSelection implements XItemListener, XFieldSelectionListener{
    
    XFixedText lblExplanation;
    XFixedText lblCategories;
    XRadioButton optBusiness;
    XRadioButton optPrivate;
    XListBox xTableListBox;
    TableWizard CurUnoDialog;
    TableDescriptor curtabledescriptor;
    CGCategory oCGCategory;
    CGTable oCGTable;
    String SELECTCATEGORY = "selectCategory";
    private int curcategory;
    public boolean bcolumnnameislimited;
    private int imaxcolumnchars;
    private String[] fieldnames;
    String smytable;
    Locale aLocale;
    XMultiServiceFactory xMSF;
    
    public ScenarioSelector(TableWizard _CurUnoDialog, TableDescriptor _curtabledescriptor, String _reslblFields, String _reslblSelFields) {
        super(_CurUnoDialog, TableWizard.SOMAINPAGE, 91, 108, 230, 80, _reslblFields, _reslblSelFields, 41209, true );
        CurUnoDialog = (TableWizard) _CurUnoDialog;
        xMSF = CurUnoDialog.xMSF;       
        aLocale = Configuration.getOfficeLocale(xMSF);
        curtabledescriptor = _curtabledescriptor;
        imaxcolumnchars = this.curtabledescriptor.getMaxColumnNameLength();
        bcolumnnameislimited = (imaxcolumnchars > 0) && (imaxcolumnchars < 16);
        addFieldSelectionListener( this);
        short pretabindex = (short) (50);
        String sExplanation = CurUnoDialog.m_oResource.getResText(UIConsts.RID_TABLE + 14);
        String sCategories = CurUnoDialog.m_oResource.getResText(UIConsts.RID_TABLE + 15);
        String sBusiness  = CurUnoDialog.m_oResource.getResText(UIConsts.RID_TABLE + 16);
        String sPrivate  = CurUnoDialog.m_oResource.getResText(UIConsts.RID_TABLE + 17);
        String sTableNames = CurUnoDialog.m_oResource.getResText(UIConsts.RID_TABLE + 18);
        smytable = CurUnoDialog.m_oResource.getResText(UIConsts.RID_TABLE + 44);
        Integer IMAINSTEP = new Integer(TableWizard.SOMAINPAGE);
        oCGCategory = new CGCategory(CurUnoDialog.xMSF);
        oCGTable = new CGTable(CurUnoDialog.xMSF); 
        lblExplanation = CurUnoDialog.insertLabel("lblScenarioExplanation", 
          new String[] {"Height", "Label", "MultiLine", "PositionX", "PositionY", "Step", "TabIndex", "Width"},
          new Object[] {new Integer(32), sExplanation, Boolean.TRUE, new Integer(91), new Integer(27), IMAINSTEP, new Short(pretabindex++), new Integer(233)}
        );

        lblCategories = CurUnoDialog.insertLabel("lblCategories",
          new String[] {"Height", "Label", "PositionX", "PositionY", "Step", "TabIndex", "Width"},
          new Object[] {new Integer(8), sCategories, new Integer(91), new Integer(60), IMAINSTEP, new Short(pretabindex++), new Integer(100)}
        );
        
        optBusiness = CurUnoDialog.insertRadioButton("optBusiness", SELECTCATEGORY, this,
            new String[] {"Height", "HelpURL", "Label", "PositionX", "PositionY", "State", "Step", "TabIndex", "Width"},
            new Object[] { UIConsts.INTEGERS[8], "HID:41206", sBusiness, new Integer(98), new Integer(70), new Short((short)1),IMAINSTEP, new Short(pretabindex++), new Integer(78)}
        );

        optPrivate = CurUnoDialog.insertRadioButton("optPrivate", SELECTCATEGORY, this,
            new String[] {"Height", "HelpURL", "Label", "PositionX", "PositionY", "Step", "TabIndex", "Width"},
            new Object[] { UIConsts.INTEGERS[8], "HID:41207", sPrivate, new Integer(182), new Integer(70),IMAINSTEP, new Short(pretabindex++), new Integer(90)}
        );

        CurUnoDialog.insertLabel("lblTableNames", 
                    new String[] {"Height", "Label", "PositionX", "PositionY", "Step", "TabIndex", "Width" }, 
                    new Object[] {new Integer(8), sTableNames, new Integer(91), new Integer(82), IMAINSTEP, new Short(pretabindex++), new Integer(80) });

        try {
            xTableListBox = CurUnoDialog.insertListBox("lstTableNames", 3, null, this, 
                        new String[] { "Dropdown", "Height", "HelpURL", "LineCount", "PositionX", "PositionY", "Step", "TabIndex", "Width" }, 
                        new Object[] { Boolean.TRUE, new Integer(12), "HID:41208", new Short("7"), new Integer(91), new Integer(92), IMAINSTEP, new Short(pretabindex++), getListboxWidth()});
        } catch (Exception e) {
            e.printStackTrace(System.out);
        }
        initializeCategory(0);
    }
    
    
    public int getCategory(){
        if (optBusiness.getState())
            curcategory = 0;
        else
            curcategory = 1;    
        return curcategory; 
    }
    
    
    public void selectCategory(){
        if (optBusiness.getState())
            initializeCategory(0);
        else
            initializeCategory(1);
    }


    public void initializeCategory(int _iCategory){
    try {
        oCGCategory.initialize(_iCategory);
        xTableListBox.removeItems((short) 0, xTableListBox.getItemCount());
        xTableListBox.addItems(oCGCategory.getTableNames(),(short) _iCategory);
        initializeTable(0);
    } catch (Exception e) {
        e.printStackTrace(System.out);
    }}
    
        
    
    public void initializeTable(int _iTable){
        Helper.setUnoPropertyValue(UnoDialog.getModel(xTableListBox), "SelectedItems", new short[]{(short)_iTable});
        oCGTable.initialize(oCGCategory.xNameAccessTablesNode, _iTable);
        super.initialize(oCGTable.getFieldNames(bcolumnnameislimited, imaxcolumnchars), true);
    }


    public String[] getSelectedFieldNames(){
        String[] displayfieldnames = super.getSelectedFieldNames();
        Vector afieldnameVector = new Vector();
        int a = 0;
        for (int i = 0; i < displayfieldnames.length; i++){
            try {
                FieldDescription ofielddescription = (FieldDescription) CurUnoDialog.fielditems.get(displayfieldnames[i]);
                if (ofielddescription != null){
                    afieldnameVector.addElement(ofielddescription.getName());
                    a++;
                }
            } catch (RuntimeException e) {
                e.printStackTrace(System.out);
            } 
        }
        fieldnames = new String[a];
        afieldnameVector.toArray(fieldnames);
        return fieldnames;
    }

    
    public boolean iscompleted(){
        return getSelectedFieldNames().length > 0;
    }
    
    
    public void addColumnsToDescriptor(){
        XNameAccess xNameAccessFieldNode;
        String[] fieldnames = getSelectedFieldNames();
        for (int i = 0; i < fieldnames.length; i++){
            try {
                FieldDescription curfielddescription = (FieldDescription) CurUnoDialog.fielditems.get(fieldnames[i]);
                PropertyValue[] aProperties = curfielddescription.getPropertyValues(); 
                this.curtabledescriptor.addColumn(aProperties);
            } catch (RuntimeException e) {
                e.printStackTrace(System.out);
            }           
        } 
    }
    

    public String getTableName(){
        return xTableListBox.getSelectedItem();
    }
    
    
    public String getFirstTableName(){
        String[] fieldnames = super.getSelectedFieldNames();
        if ((fieldnames.length) > 0){
            for (int i = 0; i < CurUnoDialog.fielditems.size(); i++){
                String stablename = "";
                try {
                    FieldDescription ofielddescription = (FieldDescription) CurUnoDialog.fielditems.get(fieldnames[i]);
                    stablename = ofielddescription.gettablename();
                } catch (RuntimeException e) {
                    e.printStackTrace(System.out);
                }
                if (!stablename.equals("")) 
                    return stablename;
            }
        }
        return smytable;
    }

    public void fillupTables(){
//      if (optBusiness.getState())
//      else
    }
    
    public void fillupFieldsListbox(){
        super.emptyFieldsListBoxes();       
    }


    /* (non-Javadoc)
     * @see com.sun.star.awt.XItemListener#itemStateChanged(com.sun.star.awt.ItemEvent)
     */
    public void itemStateChanged(ItemEvent arg0) {
        initializeTable((int) xTableListBox.getSelectedItemPos());
    }

    /* (non-Javadoc)
     * @see com.sun.star.lang.XEventListener#disposing(com.sun.star.lang.EventObject)
     */
    public void disposing(EventObject arg0) {
    }
    
    
     protected int ID;
        
     public int getID(){
         return ID;
     }
        
     public void setID(String sIncSuffix){
     }          
        
        
     public void shiftFromLeftToRight(String[] SelItems, String[] NewItems) {
        if (!CurUnoDialog.verifyfieldcount(NewItems.length)){
            for (int i = 0; i < SelItems.length; i++){
                int selindex = JavaTools.FieldInList(NewItems, SelItems[i]);
                super.xSelFieldsListBox.removeItems((short) selindex, (short) 1);
                /**TODO In this context the items should be better placed at their original position. 
                 * but how is this position retrieved?
                 */
                super.xFieldsListBox.addItem(SelItems[i], xFieldsListBox.getItemCount());
            }
        }
        else{
            for (int i = 0; i < NewItems.length; i++){
                int iduplicate;
                if (CurUnoDialog.fielditems.containsKey(NewItems[i])){
                    iduplicate = JavaTools.getDuplicateFieldIndex(NewItems, NewItems[i]);
                    if (iduplicate != -1){
                        XNameAccess xNameAccessFieldNode;
                        String sdisplayname = Desktop.getUniqueName(NewItems, NewItems[iduplicate], "");
                        FieldDescription curfielddescription = new FieldDescription(xMSF, aLocale, this, sdisplayname, NewItems[iduplicate], imaxcolumnchars);
                        CurUnoDialog.fielditems.put(sdisplayname, curfielddescription);
                        NewItems[iduplicate] = sdisplayname;
                        setSelectedFieldNames(NewItems);
                    }                   
                }
                else
                    CurUnoDialog.fielditems.put(NewItems[i], new FieldDescription(xMSF, aLocale, this, NewItems[i], NewItems[i], imaxcolumnchars));
            }
        }
        CurUnoDialog.setcompleted(TableWizard.SOMAINPAGE, NewItems.length > 0);     
     }
        
     
        
     public void shiftFromRightToLeft(String[] SelItems, String[] NewItems ) {              
        for (int i = 0; i < SelItems.length; i++){
            if (CurUnoDialog.fielditems.containsKey(SelItems[i])){
                CurUnoDialog.fielditems.remove(SelItems[i]);
                this.curtabledescriptor.dropColumnbyName(SelItems[i]);
            }
        }
        CurUnoDialog.setcompleted(TableWizard.SOMAINPAGE, NewItems.length > 0);
     }

     public void moveItemDown(String item){
     }
        
     public void moveItemUp(String item){
     }
}
