/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: propertysetitem.cxx,v $
 * $Revision: 1.5 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_dbaccess.hxx"

#ifndef _DBAUI_PROPERTYSETITEM_HXX_
#include "propertysetitem.hxx"
#endif

//.........................................................................
namespace dbaui
{
//.........................................................................

	using namespace ::com::sun::star::uno;
	using namespace ::com::sun::star::beans;

	//=========================================================================
	//= OPropertySetItem
	//=========================================================================
	TYPEINIT1(OPropertySetItem, SfxPoolItem);
	//-------------------------------------------------------------------------
	OPropertySetItem::OPropertySetItem(sal_Int16 _nWhich)
		:SfxPoolItem(_nWhich)
	{
	}

	//-------------------------------------------------------------------------
	OPropertySetItem::OPropertySetItem(sal_Int16 _nWhich, const Reference< XPropertySet >& _rxSet)
		:SfxPoolItem(_nWhich)
		,m_xSet(_rxSet)
	{
	}

	//-------------------------------------------------------------------------
	OPropertySetItem::OPropertySetItem(const OPropertySetItem& _rSource)
		:SfxPoolItem(_rSource)
		,m_xSet(_rSource.m_xSet)
	{
	}

	//-------------------------------------------------------------------------
	int OPropertySetItem::operator==(const SfxPoolItem& _rItem) const
	{
		const OPropertySetItem* pCompare = PTR_CAST(OPropertySetItem, &_rItem);
		if ((!pCompare) || (pCompare->m_xSet.get() != m_xSet.get()))
			return 0;

		return 1;
	}

	//-------------------------------------------------------------------------
	SfxPoolItem* OPropertySetItem::Clone(SfxItemPool* /* _pPool */) const
	{
		return new OPropertySetItem(*this);
	}

//.........................................................................
}	// namespace dbaui
//.........................................................................

