/*
 This is part of the OTF library. Copyright by ZIH, TU Dresden 2005-2008.
 Authors: Andreas Knuepfer, Holger Brunst, Ronny Brendel, Thomas Kriebitzsch
*/

#ifndef OTFTOVTF3_HANDLER_H
#define OTFTOVTF3_HANDLER_H

#include "config.h"

#include "OTF_inttypes.h"


/* *** Definition handler *** ************************************* */


int handleDeftimerresolution( void* firsthandlerarg, uint32_t streamid,
	uint64_t ticksPerSecond );

int handleDefprocess( void* firsthandlerarg, uint32_t streamid,
	uint32_t deftoken, const char* name, uint32_t parent );

int handleDefFunction( void* firsthandlerarg, uint32_t streamid,
	uint32_t deftoken, const char* name, uint32_t group, uint32_t scltoken );

int handleDefFile( void* userData, uint32_t stream, uint32_t token,
	const char* name, uint32_t group );



/* *** Event handler *** ****************************************** */

int handleCounter( void* firsthandlerarg, uint64_t time, uint32_t process,
	uint32_t counter_token, uint64_t value );

int handleEnter( void* firsthandlerarg, uint64_t time, uint32_t statetoken,
	uint32_t cpuid, uint32_t scltoken );

int handleRecvmsg( void* firsthandlerarg, uint64_t time, uint32_t receiver,
	uint32_t sender, uint32_t procGroup, uint32_t msgtag, uint32_t msglength,
	uint32_t scltoken );

int handleSendmsg( void* firsthandlerarg, uint64_t time, uint32_t sender,
	uint32_t receiver, uint32_t procGroup, uint32_t msgtag, uint32_t msglength,
	uint32_t scltoken );

int handleLeave( void* firsthandlerarg, uint64_t time, uint32_t statetoken,
	uint32_t cpuid, uint32_t scltoken );
	
int handleBeginProcess( void* firsthandlerarg, uint64_t time,
	uint32_t process );

int handleEndProcess( void* firsthandlerarg, uint64_t time,
	uint32_t process );
	
int handleEventComment( void* firsthandlerarg, uint64_t time, 
	const char* comment );

int handleCollectiveOperation( void* firsthandlerarg, uint64_t time, 
    uint32_t process, uint32_t functionToken, uint32_t communicator, 
    uint32_t rootprocess, uint32_t sent, uint32_t received, 
    uint64_t duration, uint32_t scltoken );

int handleFileOperation( void* firsthandlerarg, uint64_t time, uint32_t fileid,
	uint32_t process, uint64_t handleid, uint32_t operation, uint64_t bytes,
	uint64_t duration, uint32_t source );


#endif /* OTFTOVTF3_HANDLER_H */
