/* src/native/vm/gnu/java_util_concurrent_atomic_AtomicLong.c

   Copyright (C) 2007 R. Grafl, A. Krall, C. Kruegel,
   C. Oates, R. Obermaisser, M. Platter, M. Probst, S. Ring,
   E. Steiner, C. Thalinger, D. Thuernbeck, P. Tomsich, C. Ullrich,
   J. Wenninger, Institut f. Computersprachen - TU Wien

   This file is part of CACAO.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2, or (at
   your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
   02110-1301, USA.

*/


#include "config.h"

#include <stdint.h>

#include "native/jni.h"
#include "native/native.h"

#include "native/include/java_util_concurrent_atomic_AtomicLong.h"

#include "vmcore/utf8.h"


/* native methods implemented by this file ************************************/

static JNINativeMethod methods[] = {
	{ "VMSupportsCS8", "()Z", (void *) (intptr_t) &Java_java_util_concurrent_atomic_AtomicLong_VMSupportsCS8 },
};


/* _Jv_java_util_concurrent_atomic_AtomicLong_init *****************************

   Register native functions.

*******************************************************************************/

void _Jv_java_util_concurrent_atomic_AtomicLong_init(void)
{
	utf *u;

	u = utf_new_char("java/util/concurrent/atomic/AtomicLong");

	native_method_register(u, methods, NATIVE_METHODS_COUNT);
}


/*
 * Class:     java/util/concurrent/atomic/AtomicLong
 * Method:    VMSupportsCS8
 * Signature: ()Z
 */
JNIEXPORT int32_t JNICALL Java_java_util_concurrent_atomic_AtomicLong_VMSupportsCS8(JNIEnv *env, jclass clazz)
{
	/* IMPLEMENT ME */

	return 0;
}


/*
 * These are local overrides for various environment variables in Emacs.
 * Please do not remove this and leave it at the end of the file, where
 * Emacs will automagically detect them.
 * ---------------------------------------------------------------------
 * Local variables:
 * mode: c
 * indent-tabs-mode: t
 * c-basic-offset: 4
 * tab-width: 4
 * End:
 */
