#!/bin/bash -ex

# Create 2 mediated devices (SF) upon boot. For this we need to create
# /etc/mellanox/mlnx-sf.conf during the BFB installation in order to
# have unique UUIDs and MACs: These 2 SF devices will have corresponding
# network interfaces named p0m0 and p1m0.

p0m0_uuid=$(uuidgen)
p1m0_uuid=$(uuidgen)

p0m0_mac=$(echo "$p0m0_uuid" |
               sed -e 's/-//;s/^\(..\)\(..\)\(..\)\(..\)\(..\).*$/02:\1:\2:\3:\4:\5/')
p1m0_mac=$(echo "$p1m0_uuid" |
               sed -e 's/-//;s/^\(..\)\(..\)\(..\)\(..\)\(..\).*$/02:\1:\2:\3:\4:\5/')

mkdir -p /etc/mellanox

cat >> /etc/udev/rules.d/82-net-setup-link.rules << EOF
# MDEV network interfaces
ACTION=="add", SUBSYSTEM=="net", DEVPATH=="/devices/pci0000:00/0000:00:00.0/0000:01:00.0/0000:02:02.0/0000:03:00.0/${p0m0_uuid}/net/eth[0-9]", NAME="p0m0"
ACTION=="add", SUBSYSTEM=="net", DEVPATH=="/devices/pci0000:00/0000:00:00.0/0000:01:00.0/0000:02:02.0/0000:03:00.1/${p1m0_uuid}/net/eth[0-9]", NAME="p1m0"
EOF

udevadm control --reload

cat > /etc/mellanox/mlnx-sf.conf << EOF
/sbin/mlnx-sf -a create -d 0000:03:00.0 -u ${p0m0_uuid} --mac ${p0m0_mac}
/sbin/mlnx-sf -a create -d 0000:03:00.1 -u ${p1m0_uuid} --mac ${p1m0_mac}
EOF

/sbin/mlnx_bf_configure

touch /opt/create-mediated-devices.complete
