#!/usr/bin/python
#
# Copyright (C) 2012 Canonical, Ltd
# Author: Matthew Fischer <matthew.fischer@canonical.com>

import sys
import os
import unittest
sys.path.append(os.path.abspath(os.path.dirname(os.path.abspath(__file__)) + '/..'))
import nudev

class BitMaskTests(unittest.TestCase):

        def test_create_masks(self):
            mask = nudev.create_mask(100)
            self.failUnless(mask is not None)
            self.failUnless(len(mask) == 100)
            # ensure the array was initialized
            for bit in mask:
                self.failUnless(bit is False)

            mask = nudev.create_mask(1)
            self.failUnless(mask is not None)
            self.failUnless(len(mask) == 1)
            # ensure the array was initialized
            for bit in mask:
                self.failUnless(bit is False)

            mask = nudev.create_mask(0)
            self.failUnless(mask is not None)
            self.failUnless(len(mask) == 0)
            mask = nudev.create_mask(-1)
            self.failUnless(mask is not None)
            self.failUnless(len(mask) == 0)

        def test_get_mask_length(self):
            # make sure these are multiples of word size, whatever that
            # may be and at least 1 word long
            self.failUnless((nudev.get_mask_length(65) % nudev.WORD_SIZE) == 0)
            self.failUnless(nudev.get_mask_length(65) >= nudev.WORD_SIZE)
            self.failUnless((nudev.get_mask_length(64) % nudev.WORD_SIZE) == 0)
            self.failUnless(nudev.get_mask_length(64) >= nudev.WORD_SIZE)
            self.failUnless((nudev.get_mask_length(63) % nudev.WORD_SIZE) == 0)
            self.failUnless(nudev.get_mask_length(63) >= nudev.WORD_SIZE)
            self.failUnless((nudev.get_mask_length(33) % nudev.WORD_SIZE) == 0)
            self.failUnless(nudev.get_mask_length(33) >= nudev.WORD_SIZE)
            self.failUnless((nudev.get_mask_length(32) % nudev.WORD_SIZE) == 0)
            self.failUnless(nudev.get_mask_length(32) >= nudev.WORD_SIZE)
            self.failUnless((nudev.get_mask_length(31) % nudev.WORD_SIZE) == 0)
            self.failUnless(nudev.get_mask_length(31) >= nudev.WORD_SIZE)
            self.failUnless((nudev.get_mask_length(0) % nudev.WORD_SIZE) == 0)
            self.failUnless(nudev.get_mask_length(0) >= nudev.WORD_SIZE)
            self.failUnless((nudev.get_mask_length(-1) % nudev.WORD_SIZE) == 0)
            self.failUnless(nudev.get_mask_length(-1) >= nudev.WORD_SIZE)

        def test_set_mask(self):
            mask = nudev.create_mask(100)
            nudev.set_mask(0x1, 0, 10, mask)
            self.failUnless(mask[0] == True)
            self.failUnless(mask[1] == False)
            self.failUnless(mask[2] == False)

            nudev.set_mask(0x3, 10, 10, mask)
            self.failUnless(mask[0] == True)
            self.failUnless(mask[1] == False)
            self.failUnless(mask[2] == False)
            self.failUnless(mask[10] == True)
            self.failUnless(mask[11] == True)
            self.failUnless(mask[12] == False)

            nudev.set_mask(31, 20, 10, mask)
            self.failUnless(mask[0] == True)
            self.failUnless(mask[1] == False)
            self.failUnless(mask[2] == False)
            self.failUnless(mask[10] == True)
            self.failUnless(mask[11] == True)
            self.failUnless(mask[12] == False)
            self.failUnless(mask[20] == True)
            self.failUnless(mask[21] == True)
            self.failUnless(mask[22] == True)
            self.failUnless(mask[23] == True)
            self.failUnless(mask[24] == True)
            self.failUnless(mask[25] == False)

            nudev.set_mask(0x0, 10, 10, mask)
            self.failUnless(mask[0] == True)
            self.failUnless(mask[1] == False)
            self.failUnless(mask[2] == False)
            self.failUnless(mask[10] == False)
            self.failUnless(mask[11] == False)
            self.failUnless(mask[12] == False)
            self.failUnless(mask[20] == True)
            self.failUnless(mask[21] == True)
            self.failUnless(mask[22] == True)
            self.failUnless(mask[23] == True)
            self.failUnless(mask[24] == True)
            self.failUnless(mask[25] == False)

            nudev.set_mask(0x0, 0, 100, mask)
            for bit in mask:
                self.failUnless(bit is False)

def main():
    unittest.main()

if __name__ == '__main__':
    main()
