/*  VER 018   TAB P   $Id: freespc.c,v 1.2.2.1 2002/02/06 18:03:55 egil Exp $
 *
 *  calculate disk volume free space
 *
 *  copyright 1999 Egil Kvaleberg, egil@kvaleberg.no
 *  the GNU General Public License applies
 *
 *  much inspired by inndf in INN, by Ian Dickinson <idickins@fore.com>
 *
 *  $Log: freespc.c,v $
 *  Revision 1.2.2.1  2002/02/06 18:03:55  egil
 *  Updated to latest freespc.c - oops
 *
 *  Revision 1.3  1999/04/21 05:16:40  src
 *  Fix for statfs vz. statvfs problem.
 *
 *  Revision 1.2  1999/04/09 03:59:20  src
 *  NeXT detail
 *
 *  Revision 1.1  1999/03/11 07:30:00  src
 *  Implemented check for spool free space
 */

#include "common.h"

/*
 *  determine free space in kbytes, as well as free inodes
 *  false if problems, errno is either 0 or valid
 */
#if HAVE_STATVFS && HAVE_SYS_STATVFS_H
/* statvfs is 1st priority, as required by Solaris 2.6 */
#  include <sys/statvfs.h>

int freespace(char *path, long *kbytep, long *inodep)
{
    struct statvfs st;

    errno = 0;
    if (statvfs(path, &st) != 0) return 0;
    *inodep = st.f_favail;

    if (st.f_frsize <= 0) return 0; /* don't know the block size */

    if (st.f_bsize >= 1024) *kbytep = st.f_bavail * (st.f_bsize/1024);
    else *kbytep = st.f_bavail / (1024/st.f_bsize);

    return 1;
}

#elif HAVE_STATFS
#  ifdef HAVE_SYS_VFS_H
#    include <sys/vfs.h>
#  endif
#  ifdef HAVE_SYS_PARAM_H
#    include <sys/param.h>
#  endif
#  ifdef HAVE_SYS_MOUNT_H
#    include <sys/mount.h>
#  endif

/*
 *  Another NeXT peculiarity (cf. common.h)
 *  included here since statfs needs <sys/vfs.h> already included.
 */
#ifdef NeXT
    extern int statfs(const char *, struct statfs *);
#endif

int freespace(char *path, long *kbytep, long *inodep)
{
    struct statfs st;

    errno = 0;
    if (statfs(path, &st) != 0) return 0;
    *inodep = st.f_ffree;

    if (st.f_bsize <= 0) return 0; /* don't know the block size */

    /* BUG: overflow not handled if bsize > 1024 */
    if (st.f_bsize >= 1024) *kbytep = st.f_bavail * (st.f_bsize/1024);
    else *kbytep = st.f_bavail / (1024/st.f_bsize);

    return 1;
}

#else
/* sorry, can't determine free size */
int freespace(char *path, long *kbytep, long *inodep)
{  
    errno = 0;
    return 0;
}
#endif

#ifdef TEST_FREESPC
int main()
{
    long kbytes, inode;

    if (!freespace(".",&kbytes,&inode)) {
	printf("error\n");
	return 1;
    }
    printf("free: %ldk %ld nodes\n",kbytes,inode);
    return 0;
}
#endif
