/*
 * Device Control Service API
 * Copyright (C) 2008  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License, version 2.1, as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef DCS_EASYNETWORKMANGER_DEF_H
#define DCS_EASYNETWORKMANGER_DEF_H

const int FILESIZE = 1024;
const int ORDERBUFSIZE = 128;
const int WLAN_MAC_ADDRESS_LENGTH = 6;
const int AP_SSID_MAX_LENGTH = 32;
const int DEFAULT_STRING_LEN  = 256 ;

/** Definition of Adatper type. */
typedef enum ENM_ADAPTER_TYPE_E
{
	DCS_ADAPTER_WIRED = 1,
	DCS_ADAPTER_WIREDLESS,
    DCS_ADAPTER_MESH

}  ENM_ADAPTER_TYPE;

/** Definition of Network Mode. */
typedef enum DCS_NETWORK_MODE_E
{
	DCS_NETWORK_MODE_WIRED_LAN_CONNECT,
	DCS_NETWORK_MODE_WIRED_LAN_DISCONNECT,
	DCS_NETWORK_MODE_WIRELESS_LAN_CONNECT,
	DCS_NETWORK_MODE_WIRELESS_LAN_DISCONNECT,
	DCS_NETWORK_MODE_MESH_CONNECT,
	DCS_NETWORK_MODE_MESH_DISCONNECT,
	DCS_NETWORK_MODE_DISCONNECTED,
	DCS_NETWORK_MODE_DEFAULT

} ENM_NETWORK_MODE;



/** Definition of Wired LAN Type. */
typedef enum ENM_WIRED_LAN_TYPE_E
{
	DCS_WIRED_LAN_TYPE_WIRED_LAN_10M,
	DCS_WIRED_LAN_TYPE_WIRED_LAN_100M,
	DCS_WIRED_LAN_TYPE_WIRED_LAN_1000M,
	DCS_WIRED_LAN_TYPE_UNKNOWN

} ENM_WIRED_LAN_TYPE;



/** Definition of Wireless Type. */
typedef enum ENM_WIRELESS_TYPE_E
{
	ENM_WIRELESS_TYPE_WLAN_802_11_B,
	ENM_WIRELESS_TYPE_WLAN_802_11_G,
	ENM_WIRELESS_TYPE_WLAN_802_11_N,
	ENM_WIRELESS_TYPE_WLAN_UNKNOWN

} ENM_WIRELESS_TYPE;



/** Definition of Mesh Type. */
typedef enum ENM_MESH_TYPE_E
{
	ENM_MESH_TYPE_MESH_POINT,
	ENM_MESH_TYPE_MESH_PORTAL,
	ENM_MESH_TYPE_MESH_PORTAL_CLIENT,
	ENM_MESH_TYPE_UNKNOWN

} ENM_MESH_TYPE;



/** Definition of AP Encrypt. */
typedef enum ENM_AP_ENCRYPT_E
{
	ENM_AP_ENCRYPT_ENCRYPTED,
	ENM_AP_ENCRYPT_UNENCRYPTED

} ENM_AP_ENCRYPT;


/** Definition of Wireless Security Type. */
typedef enum ENM_WIRELESS_SECURITY_TYPE_E
{
	ENM_WIRELESS_SECURITY_TYPE_NONE,
	ENM_WIRELESS_SECURITY_TYPE_STATIC_WEP,
	ENM_WIRELESS_SECURITY_TYPE_WPA_PSK,
	ENM_WIRELESS_SECURITY_TYPE_UNKNOWN

} ENM_WIRELESS_SECURITY_TYPE;

/** Definition of APType Type. */
typedef enum _APType
{
    WLAN_802_11_B,
    WLAN_802_11_G,
    WLAN_802_11_N,
    WLAN_UNKNOWN

}APType;

/** Definition of BssType Type. */
typedef enum _BssType
{
    BSS_TYPE_INFRASTRUCTURE = 1,
    BSS_TYPE_INDEPENDENT = 2,
    BSS_TYPE_ANY = 3,
    BSS_TYPE_UNKNOWN = 0

}BssType;

typedef enum _WlanAuthentication
{
    WLAN_SECURITY_NONE = 0,
    WLAN_SECURITY_WEP,
    WLAN_SECURITY_WPA_PSK,
    WLAN_SECURITY_UNKNOWN

}WlanAuthentication;

/** Definition of Network Status Information. */
typedef struct ENM_NETWORK_STATUS_INFO_S
{
	unsigned int Status;			/**< The network status. */
    unsigned int Type;			/**< The network type. */
	unsigned int Speed;			/**< The network speed. */
	unsigned int SignalQuality;		/**< The network signal quality. */
	unsigned char IPAddress[15];	/**< The IP Address.*/

} ENM_NETWORK_STATUS_INFO, *PENM_NETWORK_STATUS_INFO;



/** Definition of Mesh Point Mode Information. */
typedef struct ENM_MESH_POINT_INFO_S
{
	unsigned char HostName[24];			/**< The local host name. */
	unsigned int DefaultChannel;		/**< The default mesh channel. */
	unsigned int AdvertiseTimeInterval;	/**< The time interval to advertise the Internet Sharing Server information.. */

} ENM_MESH_POINT_INFO, *PENM_MESH_POINT_INFO;



/** Definition of Mesh Portal Mode Information. */
typedef struct ENM_MESH_PORTAL_INFO_S
{
	unsigned char InternetSharingInterface[32];	/**< The internet sharing interface. */
	unsigned int  Status;						/**< The network status. */
	unsigned char IPAddress[15];				/**< The IP Address.*/

} ENM_MESH_PORTAL_INFO, *PENM_MESH_PORTAL_INFO;



/** Definition of Mesh Client Mode Information. */
typedef struct ENM_MESH_CLIENT_INFO_S
{
	unsigned char HostName[24];		/**< The local host name. */
	unsigned int Channel;			/**< The mesh network channel. */
	unsigned int SignalStrength;	/**< The mesh network signal strength. */
	unsigned int Status;			/**< The mesh network status. */

} ENM_MESH_CLIENT_INFO, *PENM_MESH_CLIENT_INFO;



/** Definition of AP detailed information. */
typedef struct ENM_AP_INFO_S
{
	unsigned char APName[32];		/**< The AP name. */
	unsigned int SignalQuality;		/**< The AP signal quality. */
	unsigned int Encrypt;			/**< Indicate whether AP has been encrypted. */
	unsigned int Type;				/**< The AP type. */
	unsigned int Channel;			/**< The AP channel. */
	unsigned char MacAddress[6];    /**< The AP MAC address. */

} ENM_AP_INFO, *PENM_AP_INFO;



/** Definition of AP or Mesh Neighbors Information. */
typedef struct ENM_NEIGHBORS_INFO_S
{
	unsigned char HostName[64];		/**< The neighbors host name. */
	unsigned int  Status;			/**< The neighbors network status. */
	unsigned int  SignalStrength;	/**< The mesh neighbors network signal strength. AP neighbors don't have it*/
	unsigned char IPAddress[15];	/**< The IP Address.*/

} ENM_NEIGHBORS_INFO, *PENM_NEIGHBORS_INFO;

/** Definition of local machine network Information. */
typedef struct NETWORK_INFO_S
{
	bool isWiredLANEnabled;	    /**< Enable or disable for wired LAN > */
	bool isWirelessEnabled;     /**< Enable or disable for wireless > */
	bool isWiredLANConnected;   /**< Connect or disconnect for wired LAN > */
	bool isWirelessConnected;   /**< Connect or disconnect for wireless > */

} NETWORK_INFO, *PNETWORK_INFO;


/** Definition of WlanSsid Information. */
typedef struct _WlanSsid
{
    unsigned long length;
    unsigned char ucSsid[AP_SSID_MAX_LENGTH];

} WlanSsid, *PWlanSsid;


/** Definition of APStatus Information. */
typedef struct _APStatus
{
    wchar_t name[AP_SSID_MAX_LENGTH];
    WlanSsid ssid;
    APType type;
    BssType bssType;
    WlanAuthentication auth;
    int signalQuality;
    int channel;
    unsigned char macAddress[WLAN_MAC_ADDRESS_LENGTH];

} APStatus, *PAPStatus;

/** Definition of AccessPointList Information. */
typedef struct _AccessPointList
{
    int nCount;
    APStatus apList[32];

} AccessPointList ;


/** Definition of UpdateCurrentAP Information. */
typedef struct ENM_UpdateCurrentAP_S
{
    unsigned char adapterName[DEFAULT_STRING_LEN];
    unsigned char userPath[DEFAULT_STRING_LEN];
    APStatus apStatus;
} ENM_UpdateCurrentAP;

/** Definition of DCS_String Information. */
typedef struct ENM_String_S
{
    unsigned char dcsString[DEFAULT_STRING_LEN];

} ENM_String;

/** Definition of DCS_StringList Information. */
typedef struct ENM_StringList_S
{
    int listSize;//< 32
    ENM_String  stringList[32];

} ENM_StringList;

/** Definition of DCS_ConnectAP Information. */
typedef struct ENM_ConnectAP_S
{
    ENM_String key;
    ENM_String ssid;
    int auth;
} ENM_ConnectAP;

/** Definition of DCS_InitUserInfo Information. */
typedef struct ENM_InitUserInfo_S
{
    ENM_String userPath;

} ENM_InitUserInfo;

/** Definition of network adapter information. */
typedef struct ENM_NetworkAdapterInfo_S
{
    ENM_String systemName;
    ENM_String userName;
} ENM_NetworkAdapterInfo, *PENM_NetworkAdapterInfo;

/** Definition of IP address information. */
typedef struct ENM_AddressInfo_S
{
    ENM_NetworkAdapterInfo adapterInfo;
    ENM_String ip;
    ENM_String mask;
    ENM_String gateway;
    ENM_String dns;
} ENM_AddressInfo, *PENM_AddressInfo;

/** Definition of proxy information. */
typedef struct ENM_ProxyInfo_S
{
    ENM_String host;
    ENM_String port;
} ENM_ProxyInfo, *PENM_ProxyInfo;


#endif /* DCS_EASYNETWORKMANGER_DEF_H */
