#ifndef _WLAN_SCANNER_H
#define _WLAN_SCANNER_H

#include <wx/event.h>
#include "wlan.h"

enum WlanResult
{
    WLAN_SUCCESS = 0,
    WLAN_INVALID_HANDLE = 1,
    WLAN_NO_INTERFACE = 2,
    WLAN_INVALID_PARAMETER = 3,
    WLAN_SCAN_ERROR = 4,
    WLAN_CONNECTION_ERROR = 5,
    WLAN_REGISTER_ERROR = 6,
    WLAN_PROFILE_ERROR = 7,
    WLAN_DATA_LOST = 8,
    WLAN_UNKNOWN_AUTH = 9,
    WLAN_ERROR = 100
};

class WlanScanner : public wxEvtHandler
{
    public:
        WlanScanner();
        virtual ~WlanScanner();

        virtual wxString GetCurrentWlanAdapterId();
};

#if defined(__WXMSW__)
#include "Win32WlanScanner.h"
#endif

#if defined(__UNIX__)
#include "WirelessScanner.h"
#endif

#endif // _WLAN_SCANNER_H
