
#ifndef _SWITCH_ADAPTER_EVENT_H_
#define _SWITCH_ADAPTER_EVENT_H_

#include <wx/event.h>
#include "DataCenter.h"

const unsigned int ID_SWITCH_ADAPTER = wxID_HIGHEST + 0x01100;

BEGIN_DECLARE_EVENT_TYPES()
    DECLARE_EVENT_TYPE(wxEVT_SWITCH_ADAPTER, -1)
END_DECLARE_EVENT_TYPES()

class SwitchAdapterEvent : public wxEvent
{
    public:
        SwitchAdapterEvent(ADAPTER_TYPE disabled, ADAPTER_TYPE enabled, bool success);
        virtual ~SwitchAdapterEvent();
        virtual wxEvent* Clone() const;
        ADAPTER_TYPE GetDisabledAdapterType() const;
        ADAPTER_TYPE GetEnabledAdapterType() const;
        bool IsSuccess() const;

    private:
        ADAPTER_TYPE m_disabled;
        ADAPTER_TYPE m_enabled;
        bool m_isSuccess;
};

typedef void (wxEvtHandler::*wxSwitchAdapterEventFunction)(SwitchAdapterEvent&);

#define EVT_SWITCH_ADAPTER(id, fn) DECLARE_EVENT_TABLE_ENTRY( wxEVT_SWITCH_ADAPTER, id, -1, \
    (wxObjectEventFunction) (wxEventFunction) (wxCommandEventFunction) (wxNotifyEventFunction) \
    wxStaticCastEvent( wxSwitchAdapterEventFunction, & fn ), (wxObject *) NULL ),


#endif // _SWITCH_ADAPTER_EVENT_H_
