#ifndef SCANEVENT_H_INCLUDED
#define SCANEVENT_H_INCLUDED
#include <wx/event.h>
const unsigned int ID_SCAN_OVER = wxID_HIGHEST + 0x01000;
BEGIN_DECLARE_EVENT_TYPES()
    DECLARE_EVENT_TYPE(EVT_SCAN, -1)
END_DECLARE_EVENT_TYPES()

class ScanEvent : public wxEvent
{
    public:
        ScanEvent(unsigned int id = 0);
        virtual ~ScanEvent();
        virtual wxEvent* Clone() const;
        int index;
};

typedef void (wxEvtHandler::*wxScanEventFunction)(ScanEvent&);
#define EVT_SCAN(id, fn) DECLARE_EVENT_TABLE_ENTRY( EVT_SCAN, id, -1, \
    (wxObjectEventFunction) (wxEventFunction) (wxCommandEventFunction) (wxNotifyEventFunction) \
    wxStaticCastEvent( wxScanEventFunction, & fn ), (wxObject *) NULL ),

#endif // SCANEVENT_H_INCLUDED
