
#include <wx/checklst.h>
#include <wx/icon.h>
#include "checkedlistctrl.h"
#include "ENMApp.h"

IMPLEMENT_CLASS(wxCheckedListCtrl, wxListCtrl)

BEGIN_EVENT_TABLE(wxCheckedListCtrl, wxListCtrl)
    EVT_LEFT_DOWN(wxCheckedListCtrl::OnMouseEvent)
END_EVENT_TABLE()

//DEFINE_EVENT_TYPE(wxEVT_COMMAND_LIST_ITEM_CHECKED);
//DEFINE_EVENT_TYPE(wxEVT_COMMAND_LIST_ITEM_UNCHECKED);

wxCheckedListCtrl::wxCheckedListCtrl()
        : wxListCtrl(), m_lstImageList(16, 16, true)
{
}

wxCheckedListCtrl::wxCheckedListCtrl(wxWindow *parent, wxWindowID id, const wxPoint& pos, const wxSize& size,
        long style, const wxValidator& validator, const wxString& name)
        : wxListCtrl(), m_lstImageList(16, 16, true)
{
    Create(parent, id, pos, size, style, validator, name);
}

wxCheckedListCtrl::~wxCheckedListCtrl()
{
}

bool wxCheckedListCtrl::Create(wxWindow* parent, wxWindowID id, const wxPoint& pos,
        const wxSize& size, long style, const wxValidator& validator, const wxString& name)
{
	if (!wxListCtrl::Create(parent, id, pos, size, style, validator, name))
		return false;

    SetImageList(&m_lstImageList, wxIMAGE_LIST_SMALL);
    m_iEnableCheckRow = -1;
	return true;
}

int wxCheckedListCtrl::GetExStateItemImage(int addstate)
{
	bool isEnabled = (addstate & wxLIST_STATE_ENABLED) != 0;
	bool isChecked = (addstate & wxLIST_STATE_CHECKED) != 0;

	if ( isEnabled && isChecked )
	{
		return CHECKED_LIST_CONTROL_CHECKED_IMAGE_INDEX;
	}
	else if ( !isEnabled && isChecked )
	{
        return CHECKED_LIST_CONTROL_DISABLED_CHECKED_IMAGE_INDEX;
	}
	else if ( isEnabled && !isChecked )
	{
		return CHECKED_LIST_CONTROL_UNCHECKED_IMAGE_INDEX;
	}

	wxASSERT( !isEnabled && !isChecked );
	return CHECKED_LIST_CONTROL_DISABLED_UNCHECKED_IMAGE_INDEX;
}

wxColour wxCheckedListCtrl::GetExStateBackgroundColour(int iExState)
{
	if ( (iExState & wxLIST_STATE_ENABLED) && this->IsEnabled() )
		return *wxWHITE;
#ifdef __WXMSW__
	return wxColour(212, 208, 200);
#else
	return wxSystemSettings::GetColour(wxSYS_COLOUR_GRAYTEXT);
#endif
}

int wxCheckedListCtrl::GetAndRemoveAdditionalState(long *plState, int iStateMask)
{
	int additionalstate = 0;
	if ( plState == NULL )
        return -1;

	bool checked = (*plState & wxLIST_STATE_CHECKED) != 0;
	bool enabled = (*plState & wxLIST_STATE_ENABLED) != 0;

	if ( checked && (iStateMask & wxLIST_STATE_CHECKED) )
    {
        additionalstate |= wxLIST_STATE_CHECKED;
    }
	if ( enabled && (iStateMask & wxLIST_STATE_ENABLED) )
    {
        additionalstate |= wxLIST_STATE_ENABLED;
    }

	*plState &= ~wxLIST_STATE_CHECKED;
	*plState &= ~wxLIST_STATE_ENABLED;
	return additionalstate;
}

bool wxCheckedListCtrl::GetItem(wxListItem& item) const
{
	wxListItem original(item);
#ifdef __WXDEBUG__
	item.m_mask |= wxLIST_MASK_IMAGE;
#endif
	if ( !wxListCtrl::GetItem(item) )
		return false;
#ifdef __WXDEBUG__
	bool isEnabled = (m_lstStateList[item.m_itemId] & wxLIST_STATE_ENABLED) != 0;
	bool isChecked = (m_lstStateList[item.m_itemId] & wxLIST_STATE_CHECKED) != 0;
#endif
	if ( (original.m_mask & wxLIST_MASK_STATE) && (original.m_stateMask & wxLIST_STATE_CHECKED) )
    {
		item.m_stateMask |= wxLIST_STATE_CHECKED;
		item.m_state |= (m_lstStateList[item.m_itemId] & wxLIST_STATE_CHECKED);
		item.m_mask |= wxLIST_MASK_STATE;
	}
	if ( (original.m_stateMask & wxLIST_STATE_ENABLED) && (original.m_mask & wxLIST_MASK_STATE) )
    {
		item.m_stateMask |= wxLIST_STATE_ENABLED;
		item.m_state |= (m_lstStateList[item.m_itemId] & wxLIST_STATE_ENABLED);
		item.m_mask |= wxLIST_MASK_STATE;
	}
#ifdef __WXDEBUG__
	wxASSERT_MSG((int)m_lstStateList.GetCount() == (int)GetItemCount(), _T("Something wrong ! See InsertItem()"));

	bool imageCheck = (item.m_image == CHECKED_LIST_CONTROL_CHECKED_IMAGE_INDEX) || (item.m_image == CHECKED_LIST_CONTROL_DISABLED_CHECKED_IMAGE_INDEX);
	bool imageEnabled = (item.m_image == CHECKED_LIST_CONTROL_CHECKED_IMAGE_INDEX) || (item.m_image == CHECKED_LIST_CONTROL_UNCHECKED_IMAGE_INDEX);
	wxASSERT_MSG((isChecked && imageCheck) || (!isChecked && !imageCheck), _T("This is item has isChecked state but it's shown as unchecked"));
	wxASSERT_MSG((isEnabled && imageEnabled) || (!isEnabled && !imageEnabled), _T("This is item has isEnabled state but it's shown as disabled"));
#endif
	return true;
}

bool wxCheckedListCtrl::SetItem(wxListItem& item)
{
	int iAdditionalState = GetAndRemoveAdditionalState(&item.m_state, item.m_stateMask);
	if ( item.m_mask & wxLIST_MASK_STATE )
	{
		if ( !(item.m_stateMask & wxLIST_STATE_ENABLED) )
        {
            iAdditionalState |= (m_lstStateList[item.m_itemId] & wxLIST_STATE_ENABLED);
        }
		if ( !(item.m_stateMask & wxLIST_STATE_CHECKED) )
        {
            iAdditionalState |= (m_lstStateList[item.m_itemId] & wxLIST_STATE_CHECKED);
        }

		item.m_mask |= wxLIST_MASK_IMAGE;
		item.m_image = GetExStateItemImage(iAdditionalState);
		int itemId = item.GetId();
		item.SetTextColour(this->GetItemTextColour(itemId));
#if wxCHECK_VERSION(2, 6, 2)
		item.SetFont(this->GetItemFont(itemId));
#endif
		item.SetBackgroundColour(GetExStateBackgroundColour(iAdditionalState));
		m_lstStateList[item.m_itemId] = iAdditionalState;
	}
	else
	{
		item.m_mask &= ~wxLIST_MASK_IMAGE;
	}
	return wxListCtrl::SetItem(item);
}

long wxCheckedListCtrl::InsertItem(wxListItem &item)
{
	int iAdditionalState = GetAndRemoveAdditionalState(&item.m_state, item.m_stateMask);
	if ( !(item.m_mask & wxLIST_MASK_STATE) || !(item.m_stateMask & wxLIST_STATE_ENABLED) )
    {
		iAdditionalState = wxLIST_STATE_ENABLED;
	}

	item.m_mask |= wxLIST_MASK_IMAGE;
	item.m_image = GetExStateItemImage(iAdditionalState);
	item.SetBackgroundColour(GetExStateBackgroundColour(iAdditionalState));

	int itemCount = GetItemCount();
	wxASSERT_MSG(item.m_itemId <= itemCount, _T("Invalid index!"));
	wxASSERT_MSG((int)m_lstStateList.GetCount() == (int)GetItemCount(), _T("Something wrong!"));
	if ( item.m_itemId == itemCount )
    {
		m_lstStateList.Add(iAdditionalState);
	}
	else
	{
		for ( int i = itemCount; i > item.m_itemId; i++ )
        {
            m_lstStateList[i] = m_lstStateList[i - 1];
        }
		m_lstStateList[item.m_itemId] = iAdditionalState;
	}
	return wxListCtrl::InsertItem(item);
}

bool wxCheckedListCtrl::SetItemState(long itemIndex, long lState, long lStateMask)
{
	wxListItem listItem;
	listItem.SetId(itemIndex);
	listItem.SetMask(wxLIST_MASK_STATE);
	listItem.SetState(lState);
	listItem.SetStateMask(lStateMask);
	return SetItem(listItem);
}

bool wxCheckedListCtrl::SetItemStateOri(long itemIndex, long lState, long lStateMask)
{
	wxListCtrl::SetItemState(itemIndex, lState, lStateMask);
	return true;
}

int wxCheckedListCtrl::GetItemState(long itemIndex, long lStateMask) const
{
	wxListItem listItem;
	listItem.SetId(itemIndex);
	listItem.SetMask(wxLIST_MASK_STATE);
	listItem.SetStateMask(lStateMask);
	if ( !GetItem(listItem) )
		return -1;
	return listItem.GetState();
}

long wxCheckedListCtrl::SetItem(long itemIndex, int column, const wxString& label, int imageId)
{
	wxListItem listItem;
	listItem.SetId(itemIndex);
	listItem.SetColumn(column);
	listItem.SetText(label);
	listItem.SetMask(wxLIST_MASK_TEXT);
	return SetItem(listItem);
}

long wxCheckedListCtrl::InsertItem(long itemIndex, const wxString& label, int imageIndex)
{
    wxListItem listItem;
    listItem.m_itemId = itemIndex;
    listItem.m_text = label;
    listItem.m_mask = wxLIST_MASK_TEXT;
    return InsertItem(listItem);
}

void wxCheckedListCtrl::Check(long itemIndex, bool checked)
{
	if ( checked )
		SetItemState(itemIndex, wxLIST_STATE_CHECKED, wxLIST_STATE_CHECKED);
	else
		SetItemState(itemIndex, 0, wxLIST_STATE_CHECKED);
}

void wxCheckedListCtrl::Enable(long itemIndex, bool bEnable)
{
	if ( bEnable )
		SetItemState(itemIndex, wxLIST_STATE_ENABLED, wxLIST_STATE_ENABLED);
	else
		SetItemState(itemIndex, 0, wxLIST_STATE_ENABLED);
}

void wxCheckedListCtrl::EnableAll(bool bEnable)
{
	for ( int itemIndex = 0; itemIndex < GetItemCount(); itemIndex++ )
    {
        Enable(itemIndex, bEnable);
    }
}

bool wxCheckedListCtrl::Enable(bool bEnable)
{
    return wxListCtrl::Enable(bEnable);
}

bool wxCheckedListCtrl::IsChecked(long itemIndex) const
{
    return GetItemState(itemIndex, wxLIST_STATE_CHECKED) != 0;
}

bool wxCheckedListCtrl::IsEnabled(long itemIndex) const
{
    return GetItemState(itemIndex, wxLIST_STATE_ENABLED) != 0;
}

bool wxCheckedListCtrl::IsEnabled() const
{
    return wxWindow::IsEnabled();
}

void wxCheckedListCtrl::CheckAll(bool bChecked)
{
	for ( int itemIndex = 0; itemIndex < GetItemCount(); itemIndex++ )
    {
        Check(itemIndex, bChecked);
    }
}

bool wxCheckedListCtrl::DeleteItem(long itemIndex)
{
	m_lstStateList.RemoveAt(itemIndex, 1);
	return wxListCtrl::DeleteItem(itemIndex);
}

bool wxCheckedListCtrl::DeleteAllItems()
{
    m_lstStateList.Clear();
    return wxListCtrl::DeleteAllItems();
}

bool wxCheckedListCtrl::SortItems(wxListCtrlCompare func, long data)
{
    wxASSERT_MSG(false, _T("This function is not implemented yet!"));
    return false;
}

int wxCheckedListCtrl::GetCheckedItemCount() const
{
	int result = 0;
	for ( int itemIndex = 0; itemIndex < GetItemCount(); itemIndex++ )
    {
        if ( IsChecked(itemIndex) )
			result++;
    }
	return result;
}

void wxCheckedListCtrl::OnMouseEvent(wxMouseEvent& mouseEvent)
{
    if ( !mouseEvent.LeftDown() )
    {
        mouseEvent.Skip();
		return;
	}

	int flags;
	long itemIndex = HitTest(mouseEvent.GetPosition(), flags);
	if ( itemIndex == wxNOT_FOUND || !IsEnabled(itemIndex) )
	{
		mouseEvent.Skip();
		return;
	}

	bool isProcessCheck = (flags & wxLIST_HITTEST_ONITEMICON) ||
            ((GetWindowStyle() & wxCLC_CHECK_WHEN_SELECTING) && (flags & wxLIST_HITTEST_ONITEM));

	if ( isProcessCheck )
	{
		wxListEvent listEvent(wxEVT_NULL, GetId());
		listEvent.m_itemIndex = itemIndex;
        if( m_iEnableCheckRow == itemIndex )
        {
            //listEvent.SetEventType(wxEVT_COMMAND_LIST_ITEM_CHECKED);
			Check(itemIndex, true);
			AddPendingEvent(listEvent);
        }
        else
		{
		    // send the check mouseEvent
            if ( IsChecked(itemIndex) )
            {
                //listEvent.SetEventType(wxEVT_COMMAND_LIST_ITEM_UNCHECKED);
                Check(itemIndex, false);
                AddPendingEvent(listEvent);
            }
            else
            {
                //listEvent.SetEventType(wxEVT_COMMAND_LIST_ITEM_CHECKED);
                Check(itemIndex, true);
                AddPendingEvent(listEvent);
            }
		}
	}
	mouseEvent.Skip();
}

void wxCheckedListCtrl::EnableCheck(int itemIndex)
{
    m_iEnableCheckRow = itemIndex;
}
