#include "WirelessEvent.h"

DEFINE_EVENT_TYPE(wxEVT_WIRELESS)

WirelessSwitchEvent::WirelessSwitchEvent(unsigned long id)
        : wxEvent(id, wxEVT_WIRELESS)
{
    memset(&m_stOldSsid, 0, sizeof(WlanSsid));
    memset(&m_stNewSsid, 0, sizeof(WlanSsid));
}

WirelessSwitchEvent::WirelessSwitchEvent(const WirelessSwitchEvent& event)
        : wxEvent(event)
{
    memcpy(&m_stOldSsid, &event.m_stOldSsid, sizeof(WlanSsid));
    memcpy(&m_stNewSsid, &event.m_stNewSsid, sizeof(WlanSsid));
}

WirelessSwitchEvent::~WirelessSwitchEvent()
{
}

wxEvent* WirelessSwitchEvent::Clone() const
{
    return new WirelessSwitchEvent(*this);
}

void WirelessSwitchEvent::SetOldSsid(const WlanSsid& oldSsid)
{
    m_stOldSsid = oldSsid;
}

void WirelessSwitchEvent::SetNewSsid(const WlanSsid& newSsid)
{
    m_stNewSsid = newSsid;
}

WlanSsid WirelessSwitchEvent::GetOldSsid() const
{
    return m_stOldSsid;
}

WlanSsid WirelessSwitchEvent::GetNewSsid() const
{
    return m_stNewSsid;
}
