#include "SwitchAdapterEvent.h"

DEFINE_EVENT_TYPE(wxEVT_SWITCH_ADAPTER);

SwitchAdapterEvent::SwitchAdapterEvent(ADAPTER_TYPE disabled, ADAPTER_TYPE enabled, bool success)
        : wxEvent(ID_SWITCH_ADAPTER, wxEVT_SWITCH_ADAPTER)
{
    m_disabled = disabled;
    m_enabled = enabled;
    m_isSuccess = success;
}

SwitchAdapterEvent::~SwitchAdapterEvent()
{
}

wxEvent* SwitchAdapterEvent::Clone() const
{
    return new SwitchAdapterEvent(*this);
}

ADAPTER_TYPE SwitchAdapterEvent::GetDisabledAdapterType() const
{
    return m_disabled;
}

ADAPTER_TYPE SwitchAdapterEvent::GetEnabledAdapterType() const
{
    return m_enabled;
}

bool SwitchAdapterEvent::IsSuccess() const
{
    return m_isSuccess;
}
