#include "wx/wxprec.h"
#include "wx/frame.h"
#include "wx/stattext.h"
#include "wx/log.h"
#include "wx/app.h"
#include "wx/checkbox.h"
#include "wx/checklst.h"
#include "wx/msgdlg.h"
#include "wx/radiobox.h"
#include "wx/menu.h"
#include "wx/sizer.h"
#include "wx/wizard.h"
#include "ProfileGeneralSettings.h"
#include <wx/image.h>
#include "ENMApp.h"
#include "ENMUtil.h"
#include <wx/file.h>
#include "ProfileManagerDlg.h"

const long ProfileGeneralSettings::ID_STSTATICLINE = wxNewId();
const long ProfileGeneralSettings::ID_PICSTATICBITMAP = wxNewId();
const long ProfileGeneralSettings::ID_GSSTATICTEXT = wxNewId();
const long ProfileGeneralSettings::ID_DES1STATICTEXT = wxNewId();
const long ProfileGeneralSettings::ID_PNSTATICTEXT = wxNewId();
const long ProfileGeneralSettings::ID_CONTYPESTATICTEXT = wxNewId();
const long ProfileGeneralSettings::ID_NAMETEXTCTRL = wxNewId();
const long ProfileGeneralSettings::ID_CONTYPECOMBOBOX = wxNewId();
const long ProfileGeneralSettings::ID_NAMECOMBOBOX = wxNewId();
const long ProfileGeneralSettings::ID_DISABLECHECKBOX = wxNewId();
const long ProfileGeneralSettings::ID_AUTHENTYPETEXTCTRL = wxNewId();
const long ProfileGeneralSettings::ID_AUTHCHECKBOX = wxNewId();
const long ProfileGeneralSettings::ID_HELP = wxNewId();

const wxString ProfileGeneralSettings::STR_WIZARD_BACK(_("< &Back"));
const wxString ProfileGeneralSettings::STR_WIZARD_NEXT(_("&Next >"));
const wxString ProfileGeneralSettings::STR_WIZARD_FINISH(_("&Finish"));

BEGIN_EVENT_TABLE(ProfileGeneralSettings, wxWizard)
    EVT_COMBOBOX(ID_CONTYPECOMBOBOX, ProfileGeneralSettings::OnProfileTypeSelected)
    EVT_BUTTON(ID_HELP, ProfileGeneralSettings::OnContextHelp)
    EVT_WIZARD_PAGE_CHANGING(wxID_ANY, ProfileGeneralSettings::OnWizardChanging)
    EVT_WIZARD_FINISHED(wxID_ANY, ProfileGeneralSettings::OnWizardFinished)
    EVT_WIZARD_CANCEL(wxID_ANY, ProfileGeneralSettings::OnWizardCancel)
END_EVENT_TABLE()

ProfileGeneralSettings::ProfileGeneralSettings(wxWindow* parent)
        : wxWizard(parent, wxID_ANY, _("New Network Profile"), wxBitmap(), wxDefaultPosition, wxDEFAULT_DIALOG_STYLE)
{
    // a wizard page may be either an object of predefined class
    m_pagestep1 = new wxWizardPageSimple(this);
    SetPageSize(wxSize(430,280));
    SetBorder(0);
    GetPageAreaSizer()->Add(m_pagestep1);

	m_lineSt1 = new wxStaticLine(m_pagestep1, ID_STSTATICLINE, wxPoint(0,60), wxSize(510,1), wxLI_HORIZONTAL, _T("ID_STSTATICLINE"));
	#if defined(__UNIX__)
	m_sbPic = new wxStaticBitmap(m_pagestep1, ID_PICSTATICBITMAP, wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic/step1.png")).Rescale(wxSize(530,60).GetWidth(),wxSize(530,60).GetHeight())), wxPoint(-20,0), wxSize(530,60), 0, _T("ID_PICSTATICBITMAP"));
	#endif
	#if defined(__WXMSW__)
	m_sbPic = new wxStaticBitmap(m_pagestep1, ID_PICSTATICBITMAP, wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic\\step1.png")).Rescale(wxSize(530,60).GetWidth(),wxSize(530,60).GetHeight())), wxPoint(-20,0), wxSize(530,60), 0, _T("ID_PICSTATICBITMAP"));
	#endif

	m_textGs = new CustomStaticText(m_pagestep1, ID_GSSTATICTEXT, _("General Settings"), wxPoint(10,10), wxDefaultSize, 0, _T("ID_GSSTATICTEXT"));
	wxFont m_textGsFont(13, wxSWISS, wxFONTSTYLE_NORMAL, wxBOLD, false, _T("Arial"), wxFONTENCODING_DEFAULT);
	m_textGs->SetFont(m_textGsFont);
//	wxFont m_textGsFont(13,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Arial"),wxFONTENCODING_DEFAULT);
//	m_textGs->SetFont(m_textGsFont);
	m_textDes1 = new CustomStaticText(m_pagestep1, ID_DES1STATICTEXT, _("Input the network profile name and select nerwork connection type"), wxPoint(10,32), wxSize(420,35), 0, _T("ID_DES1STATICTEXT"));

	#if defined(__WXMSW__)
	m_textPn = new wxStaticText(m_pagestep1, ID_PNSTATICTEXT, _("Profile Name:"), wxPoint(15,80), wxSize(210,30), 0, _T("ID_PNSTATICTEXT"));
	m_textConType = new wxStaticText(m_pagestep1, ID_CONTYPESTATICTEXT, _("Network Connection Type:"), wxPoint(15,133), wxSize(210,30), 0, _T("ID_CONTYPESTATICTEXT"));
	m_tcName = new wxTextCtrl(m_pagestep1, ID_NAMETEXTCTRL, wxEmptyString, wxPoint(240,75), wxSize(193,24), 0, wxDefaultValidator, _T("ID_NAMETEXTCTRL"));
    #endif
    #if defined(__UNIX__)
	m_textPn = new wxStaticText(m_pagestep1, ID_PNSTATICTEXT, _("Profile Name:"), wxPoint(15,80), wxDefaultSize, 0, _T("ID_PNSTATICTEXT"));
	m_textConType = new wxStaticText(m_pagestep1, ID_CONTYPESTATICTEXT, _("Network Connection Type:"), wxPoint(15,133), wxSize(170,30), 0, _T("ID_CONTYPESTATICTEXT"));
	m_tcName = new wxTextCtrl(m_pagestep1, ID_NAMETEXTCTRL, wxEmptyString, wxPoint(240,75), wxSize(185,24), 0, wxDefaultValidator, _T("ID_NAMETEXTCTRL"));
    #endif

	m_tcName->SetMaxLength(32);
	#if defined(__WXMSW__)
	m_cbbName = new wxBitmapComboBox(m_pagestep1, ID_NAMECOMBOBOX, wxEmptyString, wxPoint(443,75), wxSize(42,24), 0, 0, wxCB_READONLY, wxDefaultValidator, _T("ID_NAMECOMBOBOX"));
    #endif
    #if defined(__UNIX__)
    m_cbbName = new wxBitmapComboBox(m_pagestep1, ID_NAMECOMBOBOX, wxEmptyString, wxPoint(435,75), wxSize(50,24), 0, 0, wxCB_READONLY, wxDefaultValidator, _T("ID_NAMECOMBOBOX"));
    #endif

    wxString strPrflName = _T("");

    #if defined(__UNIX__)
    m_bmpPrfl = new wxBitmap(::wxGetApp().strAppPath + _T("pic/general.png"),wxBITMAP_TYPE_PNG);
    #endif
    #if defined(__WXMSW__)
    m_bmpPrfl = new wxBitmap(::wxGetApp().strAppPath + _T("pic\\general.png"),wxBITMAP_TYPE_PNG);
    #endif

    m_cbbName->Insert(strPrflName,*m_bmpPrfl,0);

    #if defined(__UNIX__)
    m_bmpPrfl = new wxBitmap(::wxGetApp().strAppPath + _T("pic/home.png"),wxBITMAP_TYPE_PNG);
    #endif
    #if defined(__WXMSW__)
    m_bmpPrfl = new wxBitmap(::wxGetApp().strAppPath + _T("pic\\home.png"),wxBITMAP_TYPE_PNG);
    #endif

    m_cbbName->Insert(strPrflName,*m_bmpPrfl,1);

    #if defined(__UNIX__)
    m_bmpPrfl = new wxBitmap(::wxGetApp().strAppPath + _T("pic/personal.png"),wxBITMAP_TYPE_PNG);
    #endif
    #if defined(__WXMSW__)
    m_bmpPrfl = new wxBitmap(::wxGetApp().strAppPath + _T("pic\\personal.png"),wxBITMAP_TYPE_PNG);
    #endif

    m_cbbName->Insert(strPrflName,*m_bmpPrfl,2);

    #if defined(__UNIX__)
    m_bmpPrfl = new wxBitmap(::wxGetApp().strAppPath + _T("pic/house.png"),wxBITMAP_TYPE_PNG);
    #endif
    #if defined(__WXMSW__)
    m_bmpPrfl = new wxBitmap(::wxGetApp().strAppPath + _T("pic\\house.png"),wxBITMAP_TYPE_PNG);
    #endif

    m_cbbName->Insert(strPrflName,*m_bmpPrfl,3);

    #if defined(__UNIX__)
    m_bmpPrfl = new wxBitmap(::wxGetApp().strAppPath + _T("pic/hospital.png"),wxBITMAP_TYPE_PNG);
    #endif
    #if defined(__WXMSW__)
    m_bmpPrfl = new wxBitmap(::wxGetApp().strAppPath + _T("pic\\hospital.png"),wxBITMAP_TYPE_PNG);
    #endif

    m_cbbName->Insert(strPrflName,*m_bmpPrfl,4);

    #if defined(__UNIX__)
    m_bmpPrfl = new wxBitmap(::wxGetApp().strAppPath + _T("pic/building.png"),wxBITMAP_TYPE_PNG);
    #endif
    #if defined(__WXMSW__)
    m_bmpPrfl = new wxBitmap(::wxGetApp().strAppPath + _T("pic\\building.png"),wxBITMAP_TYPE_PNG);
    #endif

    m_cbbName->Insert(strPrflName,*m_bmpPrfl,5);

    #if defined(__UNIX__)
    m_bmpPrfl = new wxBitmap(::wxGetApp().strAppPath + _T("pic/bucket.png"),wxBITMAP_TYPE_PNG);
    #endif
    #if defined(__WXMSW__)
    m_bmpPrfl = new wxBitmap(::wxGetApp().strAppPath + _T("pic\\bucket.png"),wxBITMAP_TYPE_PNG);
    #endif

    m_cbbName->Insert(strPrflName,*m_bmpPrfl,6);

    #if defined(__UNIX__)
    m_bmpPrfl = new wxBitmap(::wxGetApp().strAppPath + _T("pic/airport.png"),wxBITMAP_TYPE_PNG);
    #endif
    #if defined(__WXMSW__)
    m_bmpPrfl = new wxBitmap(::wxGetApp().strAppPath + _T("pic\\airport.png"),wxBITMAP_TYPE_PNG);
    #endif

    m_cbbName->Insert(strPrflName, *m_bmpPrfl, 7);
    m_cbbName->SetPopupMaxHeight(110);
    m_cbbName->SetSelection(0);

#if defined(__WXMSW__)
	m_cbbConType = new wxComboBox(m_pagestep1, ID_CONTYPECOMBOBOX, wxEmptyString, wxPoint(240,127), wxSize(245,29), 0, 0, wxCB_READONLY, wxDefaultValidator, _T("ID_CONTYPECOMBOBOX"));
#endif
#if defined(__UNIX__)
	m_cbbConType = new wxComboBox(m_pagestep1, ID_CONTYPECOMBOBOX, wxEmptyString, wxPoint(240,127), wxSize(245,30), 0, 0, wxCB_READONLY, wxDefaultValidator, _T("ID_CONTYPECOMBOBOX"));
#endif

	m_cbbConType->Append(_("Wireless LAN"));
	m_cbbConType->Append(_("Wired LAN"));
	m_cbbConType->SetValue(_("Wireless LAN"));

    m_pagestep2 = new ProfileWirelessSettings(this);
    m_pagestep3 = new ProfileOtherSettings(this);
    wxWizardPageSimple::Chain(m_pagestep1, m_pagestep2);
    wxWizardPageSimple::Chain(m_pagestep2, m_pagestep3);
    m_pagestep3->SetProfileType(ADAPTER_WIREDLESS);

    wxAcceleratorEntry entries[1];
    entries[0].Set( wxACCEL_NORMAL, WXK_F1, ID_HELP );
    wxAcceleratorTable accel(1, entries);
    SetAcceleratorTable(accel);
}

bool ProfileGeneralSettings::ShowWizard()
{
    return wxWizard::RunWizard(m_pagestep1);
}

ProfileList_t ProfileGeneralSettings::GetProfile() const
{
    return m_profileInfo;
}

void ProfileGeneralSettings::OnWizardChanging(wxWizardEvent& event)
{
    wxString strProfileName = m_tcName->GetValue();
    strProfileName = strProfileName.Trim(true);
    strProfileName = strProfileName.Trim(false);
    m_tcName->SetValue(strProfileName);
    if ( this->m_tcName->GetValue() == _T("") )
    {
        wxMessageDialog msg(this, _("Profile name cannot be empty!"), _("Message"), wxOK | wxICON_INFORMATION);
        msg.ShowModal();
        event.Veto();
        m_tcName->SetFocus();
        return;
    }

    ProfileManagerDlg* pDialog = DataCenter::GetInstance()->GetProfileManagerDlgHandle();
    if ( pDialog->IsProfileExist(strProfileName) )
    {
        wxMessageDialog msg(this, _("A profile with the name you specified already exists.\nPlease specify a different name!"), _("Message"), wxOK | wxICON_INFORMATION);
        msg.ShowModal();
        event.Veto();
        m_tcName->SetFocus();
        return;
    }

    int check = ENMUtil::CheckValide(m_tcName->GetValue());
    if ( check == ENMUtil::CHECK_ILLEGAL )
    {
        wxMessageDialog msg(this, _("Profile name cannot contain any of the following characters\n \\ / : * ? \" ' < > |"), _("Message"), wxOK | wxICON_INFORMATION);
        msg.ShowModal();
        event.Veto();
        m_tcName->SetFocus();
        return;
    }
    else if ( check == ENMUtil::CHECK_EMPTY )
    {
        wxMessageDialog msg(this, _("Profile name cannot be empty!"), _("Message"), wxOK | wxICON_INFORMATION);
        msg.ShowModal();
        event.Veto();
        m_tcName->SetFocus();
        return;
    }

    if ( event.GetPage() == m_pagestep2 )
    {
        if ( event.GetDirection() )
        {
            if ( m_pagestep2->m_bNameChange )
            {
                wxString strEssidName = m_pagestep2->m_tcWNName->GetValue();
                strEssidName = strEssidName.Trim(true);
                strEssidName = strEssidName.Trim(false);
                m_pagestep2->m_tcWNName->SetValue(strEssidName);
                if (m_pagestep2->m_tcWNName->GetValue() == _T(""))
                {
                    wxMessageDialog msg(this, _("SSID cannot be empty!"), _("Message"), wxOK | wxICON_INFORMATION);
                    msg.ShowModal();
                    event.Veto();
                    m_pagestep2->m_tcWNName->SetFocus();
                    return;
                }
                if ( !strEssidName.IsAscii() )
                {
                    wxMessageDialog msg(this, _("Invalid SSID!"), _("Message"), wxOK | wxICON_INFORMATION);
                    msg.ShowModal();
                    event.Veto();
                    m_pagestep2->m_tcWNName->SetFocus();
                    return;
                }
                if (ENMUtil::CheckValide(m_pagestep2->m_tcWNName->GetValue()))
                {
                    wxMessageDialog msg(this, _("SSID cannot contain any of the following characters\n \\ / : * ? \" ' < > |"), _("Message"), wxOK | wxICON_INFORMATION);
                    msg.ShowModal();
                    event.Veto();
                    m_pagestep2->m_tcWNName->SetFocus();
                    return;
                }
            }

            wxString currentText = m_pagestep2->m_cbbSt->GetValue();
            if ( currentText.Cmp(_T("WEP")) == 0 )
            {
                wxString strWepKey = m_pagestep2->m_tcKey->GetValue();
                if ( strWepKey.IsEmpty() )
                {
                    wxMessageDialog msg(this, _("WEP key cannot be empty!"), _("Message"), wxOK | wxICON_INFORMATION);
                    msg.ShowModal();
                    event.Veto();
                    return;
                }
                if ( !ENMUtil::IsHexNumber(strWepKey) )
                {
                    wxMessageDialog msg(this, _("WEP key must be hexadecimal. \n(Must contain only numbers 0-9 and letters a-f)"), _("Message"), wxOK | wxICON_INFORMATION);
                    msg.ShowModal();
                    event.Veto();
                    return;
                }
            }

            if (currentText.Cmp(_T("WPA-PSK")) == 0)
            {
                if (m_pagestep2->m_tcKey->GetValue().IsEmpty())
                {
                    wxMessageDialog msg(this, _("WPA key cannot be empty!"), _("Message"), wxOK | wxICON_INFORMATION);
                    msg.ShowModal();
                    event.Veto();
                    return;
                }
            }
        }
    }
    //1st
    m_profileInfo.sProfileName = ENMUtil::WxStringToString(strProfileName);
    if ( ENMUtil::IsAdministrator() )
    {
        m_profileInfo.sPermission = "admin";
    }
    else
    {
        m_profileInfo.sPermission = "user";
    }
    m_profileInfo.sProfileIcon = ENMUtil::WxStringToString(wxString::Format(_T("%d"),m_cbbName->GetSelection()));
    if( !m_cbbConType->GetValue().Cmp(_("Wireless LAN")) )
    {
        m_profileInfo.stGenernalSet.ConnecType = "wireless";
//        m_pagestep3->SetIPAddress(ADAPTER_WIREDLESS);
    }
    else
    {
        m_profileInfo.stGenernalSet.ConnecType = "lan";
//        m_pagestep3->SetIPAddress(ADAPTER_WIRED);
    }

    //2nd
    m_profileInfo.stWirelessSet.SSID = ENMUtil::WxStringToString(m_pagestep2->m_tcWNName->GetValue());
    switch( m_pagestep2->m_cbbWt->GetSelection() )
    {
        case 0:
            m_profileInfo.stWirelessSet.WirlessType  = "Automatic";
            break;
        case 1:
            m_profileInfo.stWirelessSet.WirlessType  = "802.11b";
            break;
        case 2:
            m_profileInfo.stWirelessSet.WirlessType  = "802.11g";
            break;
        case 3:
            m_profileInfo.stWirelessSet.WirlessType  = "802.11n";
            break;
        default:
            m_profileInfo.stWirelessSet.WirlessType  = "802.11b";
            break;
    }

    switch( m_pagestep2->m_cbbSt->GetSelection() )
    {
        case 0:
            m_profileInfo.stWirelessSet.WlanSecurity = "none";
            m_profileInfo.stWirelessSet.stWEPSecurity.keyIndex = "1";
            break;
        case 1:
            m_profileInfo.stWirelessSet.WlanSecurity = "wep";
            m_profileInfo.stWirelessSet.stWEPSecurity.value = ENMUtil::WxStringToString(m_pagestep2->m_tcKey->GetValue());
            m_profileInfo.stWirelessSet.stWEPSecurity.keyIndex = ENMUtil::WxStringToString(m_pagestep2->m_cbbIndex->GetValue());
            break;
        case 2:
            m_profileInfo.stWirelessSet.WlanSecurity = "wpa-psk";
            m_profileInfo.stWirelessSet.stWPASecurity.value = ENMUtil::WxStringToString(m_pagestep2->m_tcKey->GetValue());
            m_profileInfo.stWirelessSet.stWEPSecurity.keyIndex = "1";
            break;
        default:
            m_profileInfo.stWirelessSet.WlanSecurity = "unknown";
            break;
    }

    //3th
    m_profileInfo.stOtherSet = m_pagestep3->GetProfileOtherSetting();
//    wxString currentHomePage = m_pagestep3->m_textHp->GetValue();
//    currentHomePage = currentHomePage.Trim(true);
//    currentHomePage = currentHomePage.Trim(false);
//    m_profileInfo.stOtherSet.stNetSecurity.sForbidShareFileAndPrint = m_pagestep3->m_strForbidShareFileAndPrint;
//    m_profileInfo.stOtherSet.stNetSecurity.sForbidShareInternet = m_pagestep3->m_strForbidShareInternet;
//    m_profileInfo.stOtherSet.stNetSecurity.sStartWindowFirewall = m_pagestep3->m_strStartWindowFirewall;
//    m_profileInfo.stOtherSet.Homepage = ENMUtil::WxStringToString(currentHomePage);
//    m_profileInfo.stOtherSet.stIPDNSSet.IPvalue = ENMUtil::WxStringToString(m_pagestep3->m_strIP);
//    m_profileInfo.stOtherSet.stIPDNSSet.SubnetAddress = ENMUtil::WxStringToString(m_pagestep3->m_strSubMask);
//    m_profileInfo.stOtherSet.stIPDNSSet.NetGateway = ENMUtil::WxStringToString(m_pagestep3->m_strGateWayAddr);
//    m_profileInfo.stOtherSet.stIPDNSSet.DNSvalue = ENMUtil::WxStringToString(m_pagestep3->m_strDNS);
//
//    m_profileInfo.stOtherSet.stProxySet.Proxy = ENMUtil::WxStringToString(m_pagestep3->m_strProxy);
//    m_profileInfo.stOtherSet.stProxySet.Port = ENMUtil::WxStringToString(m_pagestep3->m_strPort);
//
//    m_profileInfo.stOtherSet.AutoRunApp = m_pagestep3->m_strAppPath;

    m_pagestep2->m_bNameChange = true;
}

void ProfileGeneralSettings::OnWizardFinished(wxWizardEvent& event)
{

}

void ProfileGeneralSettings::OnWizardCancel(wxWizardEvent& event)
{
    wxMessageDialog dialog(this, _("Are you sure you want to cancel the operation?"), _("Confirm"), wxYES_NO | wxNO_DEFAULT | wxICON_QUESTION);
    if ( dialog.ShowModal() != wxID_YES )
    {
        event.Veto();
    }
}

void ProfileGeneralSettings::OnProfileTypeSelected(wxCommandEvent& event)
{
    wxString currentText = m_cbbConType->GetValue();
    currentText = currentText.Trim(true);
    currentText = currentText.Trim(false);
    if (currentText.Cmp(_("Wireless LAN")) == 0)
    {
        wxWizardPageSimple::Chain(m_pagestep1, m_pagestep2);
        wxWizardPageSimple::Chain(m_pagestep2, m_pagestep3);
        m_pagestep3->SetProfileType(ADAPTER_WIREDLESS);
    }
    else
    {
        wxWizardPageSimple::Chain(m_pagestep1, m_pagestep3);
        m_pagestep3->SetProfileType(ADAPTER_WIRED);
    }
}

void ProfileGeneralSettings::OnContextHelp(wxCommandEvent& event)
{
#if defined(__UNIX__)
    if(wxFileExists(wxT("/usr/share/EasyNetworkManager/Intel_CMPC2.0_Easy_Network_User_Manual_Ubuntu.pdf")))
    {
        wxString cmd = wxT("evince /usr/share/EasyNetworkManager/Intel_CMPC2.0_Easy_Network_User_Manual_Ubuntu.pdf --page-label=26");
        //wxExecute(cmd);
    }
#endif
#if defined(__WXMSW__)
    ENMUtil::ShowContextHelp(this, _T("NewProfile"));
#endif
}
