
#include <wx/msgdlg.h>
#include "DeviceController.h"
#include "ENMUtil.h"
#include <string>
#include <wx/arrimpl.cpp>
using namespace std;

NetworkDeviceInfo::NetworkDeviceInfo()
{
    m_devType = ADAPTER_NONE;
}

NetworkDeviceInfo::NetworkDeviceInfo(const NetworkDeviceInfo& copy)
{
    m_strGuid = copy.m_strGuid;
    m_strDesc = copy.m_strDesc;
    m_devType = copy.m_devType;
}

NetworkDeviceInfo::~NetworkDeviceInfo()
{
}

wxString NetworkDeviceInfo::GetGuid() const
{
    return m_strGuid;
}

wxString NetworkDeviceInfo::GetDescription() const
{
    return m_strDesc;
}

ADAPTER_TYPE NetworkDeviceInfo::GetDeviceType() const
{
    return m_devType;
}

void NetworkDeviceInfo::SetGuid(const wxString& guid)
{
    m_strGuid = guid;
}

void NetworkDeviceInfo::SetDescription(const wxString& desc)
{
    if ( desc.Find(_T("Wireless")) != wxNOT_FOUND )
        m_devType = ADAPTER_WIREDLESS;
    else if ( desc.Find(_T("Ethernet")) != wxNOT_FOUND )
        m_devType = ADAPTER_WIRED;
    m_strDesc = desc;
}

WX_DEFINE_OBJARRAY(NetworkDeviceInfoArray);


#if defined(__WXMSW__)

#include <wx/msw/registry.h>

Win32NetworkDeviceController* Win32NetworkDeviceController::instance = NULL;

Win32NetworkDeviceController* Win32NetworkDeviceController::GetCurrentInstance()
{
    if ( instance == NULL )
    {
        instance = new Win32NetworkDeviceController();
    }
    return instance;
}

Win32NetworkDeviceController::Win32NetworkDeviceController()
{
}

Win32NetworkDeviceController::~Win32NetworkDeviceController()
{
}

NetworkDeviceInfoArray Win32NetworkDeviceController::EnumNetworkDevice()
{
    NetworkDeviceInfoArray result;
    wxString KEY = _T("HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\NetworkCards\\");
    wxRegKey reg(KEY);
    if ( !reg.Exists() )
    {
        return result;
    }
    if ( !reg.Open(wxRegKey::Read) )
    {
        return result;
    }

    size_t nSubKeys;
    if ( !reg.GetKeyInfo(&nSubKeys, NULL, NULL, NULL) )
    {
        return result;
    }

    long dummy = 1;
    wxString value;
    bool cont = reg.GetFirstKey(value, dummy);
    while ( cont )
    {
        wxRegKey key(KEY + value);
        if ( !key.Exists() || !key.HasValue(_T("ServiceName")) || !key.HasValue(_T("Description")) )
        {
            continue;
        }
        NetworkDeviceInfo info;
        if ( GetNetworkDeviceInfo(KEY + value, &info) )
        {
            result.Add(info);
        }
        cont = reg.GetNextKey(value, dummy);
    }
    return result;
}

bool Win32NetworkDeviceController::GetNetworkDeviceInfo(const wxString& keyName, NetworkDeviceInfo* pInfo)
{
    if ( pInfo == NULL )
        return false;

    wxRegKey key(keyName);
    if ( !key.Open(wxRegKey::Read) )
        return false;

    wxString strGuid;
    if ( !key.HasValue(_T("ServiceName")) || !key.QueryValue(_T("ServiceName"), strGuid) )
        return false;

    wxString strDesc;
    if ( !key.HasValue(_T("Description")) || !key.QueryValue(_T("Description"), strDesc) )
        return false;

    pInfo->SetGuid(strGuid);
    pInfo->SetDescription(strDesc);
    key.Close();

    return true;
}

HANDLE Win32NetworkDeviceController::OpenNetworkDevice(const NetworkDeviceInfo& info)
{
    char device_file[SIZEOF_DEVICE_NAME];
    string s = ENMUtil::WxStringToString(info.m_strGuid);
    sprintf(device_file, "\\\\.\\%s", s.c_str());
    return CreateFileA(device_file, GENERIC_READ, FILE_SHARE_READ | FILE_SHARE_WRITE, NULL, OPEN_EXISTING, 0, NULL);
}

bool Win32NetworkDeviceController::CloseNetworkDevice(HANDLE handle)
{
    if ( CloseHandle(handle) )
        return true;
    else
        return false;
}

#endif
