/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */

#include <NetworkManager.h>
#include <nm-connection.h>
#include <nm-setting-connection.h>
#include <nm-setting-wired.h>
#include "nmn-serial-item.h"
#include "nma-gconf-connection.h"
#include "utils.h"

G_DEFINE_TYPE (NmnSerialItem, nmn_serial_item, NMN_TYPE_NETWORK_ITEM)

#define GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE ((obj), NMN_TYPE_SERIAL_ITEM, NmnSerialItemPrivate))

typedef struct {
    gulong state_changed_id;

    gboolean disposed;
} NmnSerialItemPrivate;

static void
state_changed (NMDevice *device,
               NMDeviceState new_state,
               NMDeviceState old_state,
               NMDeviceStateReason reason,
               gpointer user_data)
{
    const char *icon;

    switch (new_state) {
    case NM_DEVICE_STATE_ACTIVATED:
        icon = "nm-device-wwan";
        break;
    default:
        icon = "nm-no-connection";
        break;
    }

    nmn_item_set_icon (NMN_ITEM (user_data), icon);
}

GtkWidget *
nmn_serial_item_new (NmnNMData *nm_data,
                     NMSerialDevice *device)
{
    g_return_val_if_fail (NMN_IS_NM_DATA (nm_data), NULL);
    g_return_val_if_fail (NM_IS_SERIAL_DEVICE (device), NULL);

    return GTK_WIDGET (g_object_new (NMN_TYPE_SERIAL_ITEM,
                                     NMN_NETWORK_ITEM_NM_DATA, nm_data,
                                     NMN_NETWORK_ITEM_DEVICE, device,
                                     NULL));
}

static guint
get_priority (NmnItem *item)
{
    return NMN_ITEM_CLASS (nmn_serial_item_parent_class)->get_priority (item) + 10;
}

static void
nmn_serial_item_init (NmnSerialItem *item)
{
    nmn_item_set_delete_visible (NMN_ITEM (item), TRUE);
}

static GObject*
constructor (GType type,
             guint n_construct_params,
             GObjectConstructParam *construct_params)
{
    GObject *object;
    NmnSerialItemPrivate *priv;
    NMDevice *device;

    object = G_OBJECT_CLASS (nmn_serial_item_parent_class)->constructor
        (type, n_construct_params, construct_params);

    if (!object)
        return NULL;

    priv = GET_PRIVATE (object);
    device = nmn_network_item_get_device (NMN_NETWORK_ITEM (object));
    priv->state_changed_id = g_signal_connect (device, "state-changed", G_CALLBACK (state_changed), object);

    state_changed (device, nm_device_get_state (device), 
                   NM_DEVICE_STATE_UNKNOWN, NM_DEVICE_STATE_REASON_NONE, object);

    return object;
}

static void
dispose (GObject *object)
{
    NmnSerialItemPrivate *priv = GET_PRIVATE (object);
    NMDevice *device;

    if (priv->disposed)
        return;

    device = nmn_network_item_get_device (NMN_NETWORK_ITEM (object));
    g_signal_handler_disconnect (device, priv->state_changed_id);

    priv->disposed = TRUE;

    G_OBJECT_CLASS (nmn_serial_item_parent_class)->dispose (object);
}

static void
nmn_serial_item_class_init (NmnSerialItemClass *class)
{
    GObjectClass *object_class = G_OBJECT_CLASS (class);
    NmnItemClass *item_class = NMN_ITEM_CLASS (class);

    g_type_class_add_private (object_class, sizeof (NmnSerialItemPrivate));

    object_class->constructor = constructor;
    object_class->dispose = dispose;

    item_class->get_priority = get_priority;
}
