/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */

#include <nm-settings.h>
#include "nmn-serial-handler.h"
#include "nmn-serial-item.h"
#include "utils.h"

G_DEFINE_TYPE (NmnSerialHandler, nmn_serial_handler, NMN_TYPE_DEVICE_HANDLER)

#define GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE ((obj), NMN_TYPE_SERIAL_HANDLER, NmnSerialHandlerPrivate))

typedef struct {
    gulong modems_toggled_id;

    gboolean disposed;
} NmnSerialHandlerPrivate;

NmnDeviceHandler *
nmn_serial_handler_new (NmnNMData *nm_data,
                        NMSerialDevice *device)
{
    g_return_val_if_fail (NMN_IS_NM_DATA (nm_data), NULL);
    g_return_val_if_fail (NM_IS_SERIAL_DEVICE (device), NULL);

    return NMN_DEVICE_HANDLER (g_object_new (NMN_TYPE_SERIAL_HANDLER,
                                             NMN_DEVICE_HANDLER_NM_DATA, nm_data,
                                             NMN_DEVICE_HANDLER_DEVICE, device,
                                             NULL));
}

static void
connection_added (NmnDeviceHandler *handler,
                  NMExportedConnection *exported)
{
    NMConnection *wrapped;
    NMDevice *device;
    GtkWidget *item;

    wrapped = nm_exported_connection_get_connection (exported);
    device = nmn_device_handler_get_device (handler);

    if (!utils_connection_valid_for_device (wrapped, device, NULL))
        return;

    item = nmn_serial_item_new (nmn_device_handler_get_nm_data (handler), NM_SERIAL_DEVICE (device));
    g_object_set (item, NMN_NETWORK_ITEM_CONNECTION, exported, NULL);
    nmn_device_handler_add_item (handler, NMN_ITEM (item));
}

static void
modems_toggled (NmnNMData *nm_data,
                gboolean active,
                gpointer user_data)
{
    NmnDeviceHandler *handler = NMN_DEVICE_HANDLER (user_data);

    if (active)
        nmn_device_handler_add_items (handler);
    else
        nmn_device_handler_remove_items (handler);
}

static void
nmn_serial_handler_init (NmnSerialHandler *handler)
{
}

static GObject*
constructor (GType type,
             guint n_construct_params,
             GObjectConstructParam *construct_params)
{
    GObject *object;
    NmnNMData *nm_data;
    NmnSerialHandlerPrivate *priv;

    object = G_OBJECT_CLASS (nmn_serial_handler_parent_class)->constructor
        (type, n_construct_params, construct_params);

    if (!object)
        return NULL;

    priv = GET_PRIVATE (object);

    nm_data = nmn_device_handler_get_nm_data (NMN_DEVICE_HANDLER (object));
    priv->modems_toggled_id = g_signal_connect (nm_data, "modems-toggled", G_CALLBACK (modems_toggled), object);

    return object;
}

static void
dispose (GObject *object)
{
    NmnSerialHandlerPrivate *priv = GET_PRIVATE (object);
    NmnNMData *nm_data;

    if (priv->disposed)
        return;

    nm_data = nmn_device_handler_get_nm_data (NMN_DEVICE_HANDLER (object));
    g_signal_handler_disconnect (nm_data, priv->modems_toggled_id);

    priv->disposed = TRUE;

    G_OBJECT_CLASS (nmn_serial_handler_parent_class)->dispose (object);
}

static void
nmn_serial_handler_class_init (NmnSerialHandlerClass *class)
{
    GObjectClass *object_class = G_OBJECT_CLASS (class);
    NmnDeviceHandlerClass *handler_class = NMN_DEVICE_HANDLER_CLASS (class);

    g_type_class_add_private (object_class, sizeof (NmnSerialHandlerPrivate));

    object_class->constructor = constructor;
    object_class->dispose = dispose;

    handler_class->connection_added = connection_added;
}
