/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */

#ifndef NMN_NETWORK_ITEM_H
#define NMN_NETWORK_ITEM_H

#include <dbus/dbus-glib.h>
#include <nm-settings.h>
#include <nmn-item.h>
#include "nmn-nm-data.h"

#define NMN_TYPE_NETWORK_ITEM            (nmn_network_item_get_type ())
#define NMN_NETWORK_ITEM(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), NMN_TYPE_NETWORK_ITEM, NmnNetworkItem))
#define NMN_NETWORK_ITEM_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), NMN_TYPE_NETWORK_ITEM, NmnNetworkItemClass))
#define NMN_IS_NETWORK_ITEM(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NMN_TYPE_NETWORK_ITEM))
#define NMN_IS_NETWORK_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((obj), NMN_TYPE_NETWORK_ITEM))
#define NMN_NETWORK_ITEM_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), NMN_TYPE_NETWORK_ITEM, NmnNetworkItemClass))

#define NMN_NETWORK_ITEM_NM_DATA    "nm-data"
#define NMN_NETWORK_ITEM_DEVICE     "device"
#define NMN_NETWORK_ITEM_CONNECTION "connection"
#define NMN_NETWORK_ITEM_AC         "active-connection"

typedef struct {
    NmnItem parent;
} NmnNetworkItem;

typedef struct {
    NmnItemClass parent;

    /* Methods */
    const char * (*get_specific_object) (NmnNetworkItem *self);
    void (*secrets_requested) (NmnNetworkItem *self,
                               const char *setting_name,
                               const char **hints,
                               gboolean ask_user,
                               DBusGMethodInvocation *context);
} NmnNetworkItemClass;

GType nmn_network_item_get_type (void);

NmnNMData        *nmn_network_item_get_nm_data           (NmnNetworkItem *self);
NMDevice             *nmn_network_item_get_device            (NmnNetworkItem *self);
NMExportedConnection *nmn_network_item_get_connection        (NmnNetworkItem *self);
void                  nmn_network_item_set_connection        (NmnNetworkItem *self,
                                                              NMExportedConnection *connection);

NMActiveConnection   *nmn_network_item_get_active_connection (NmnNetworkItem *self);
void                  nmn_network_item_set_active_connection (NmnNetworkItem *self,
                                                              NMActiveConnection *ac);

#endif /* NMN_NETWORK_ITEM_H */
