/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */

#ifndef NMN_NM_DATA_H
#define NMN_NM_DATA_H

#include <dbus/dbus-glib.h>
#include <nm-client.h>
#include <nm-settings.h>

#define NMN_TYPE_NM_DATA            (nmn_nm_data_get_type ())
#define NMN_NM_DATA(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), NMN_TYPE_NM_DATA, NmnNMData))
#define NMN_NM_DATA_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), NMN_TYPE_NM_DATA, NmnNMDataClass))
#define NMN_IS_NM_DATA(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NMN_TYPE_NM_DATA))
#define NMN_IS_NM_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((obj), NMN_TYPE_NM_DATA))
#define NMN_NM_DATA_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), NMN_TYPE_NM_DATA, NmnNMDataClass))

typedef struct {
    NMClient parent;
} NmnNMData;

typedef struct {
    NMClientClass parent;

    /* Signals */
    void (*ethernet_toggled) (NmnNMData *self,
                              gboolean active);

    void (*wifi_toggled) (NmnNMData *self,
                          gboolean active);

    void (*modems_toggled) (NmnNMData *self,
                            gboolean active);

    void (*flight_mode_toggled) (NmnNMData *self,
                                 gboolean active);

} NmnNMDataClass;

GType nmn_nm_data_get_type (void);

NmnNMData  *nmn_nm_data_new                    (DBusGConnection *bus);
NMSettings *nmn_nm_data_get_user_settings      (NmnNMData *data);
NMSettings *nmn_nm_data_get_system_settings    (NmnNMData *data);

gboolean    nmn_nm_data_ethernet_get_active    (NmnNMData *self); 
void        nmn_nm_data_ethernet_toggled       (NmnNMData *self,
                                                gboolean active);

gboolean    nmn_nm_data_wifi_get_active        (NmnNMData *self); 
void        nmn_nm_data_wifi_toggled           (NmnNMData *self,
                                                gboolean active);

gboolean    nmn_nm_data_modems_get_active      (NmnNMData *self); 
void        nmn_nm_data_modems_toggled         (NmnNMData *self,
                                                gboolean active);

gboolean    nmn_nm_data_flight_mode_can_change (NmnNMData *self);
gboolean    nmn_nm_data_flight_mode_get_active (NmnNMData *self);
void        nmn_nm_data_flight_mode_toggled    (NmnNMData *self,
                                                gboolean active);

#endif /* NMN_NM_DATA_H */
