/*
 * Copyright (C) 2009 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _NL_PLUGIN_MANAGER_H_
#define _NL_PLUGIN_MANAGER_H_

#include <glib.h>
#include <netbook-launcher/netbook-launcher.h>

#define NL_TYPE_PLUGIN_MANAGER (nl_plugin_manager_get_type ())

#define NL_PLUGIN_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	NL_TYPE_PLUGIN_MANAGER, NlPluginManager))

#define NL_PLUGIN_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	NL_TYPE_PLUGIN_MANAGER, NlPluginManagerClass))

#define NL_IS_PLUGIN_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	NL_TYPE_PLUGIN_MANAGER))

#define NL_IS_PLUGIN_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	NL_TYPE_PLUGIN_MANAGER))

#define NL_PLUGIN_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	NL_TYPE_PLUGIN_MANAGER, NlPluginManagerClass))

typedef struct _NlPluginManager        NlPluginManager;
typedef struct _NlPluginManagerClass   NlPluginManagerClass;
typedef struct _NlPluginManagerPrivate NlPluginManagerPrivate;
 
struct _NlPluginManager
{
  GObject        parent;	

  NlPluginManagerPrivate *priv;
};

struct _NlPluginManagerClass
{
  GObjectClass   parent_class;
};

GType                   nl_plugin_manager_get_type    (void) G_GNUC_CONST;

NlPluginManager * nl_plugin_manager_new (NlShell *s);

#endif /* _NL_PLUGIN_MANAGER_H_ */

