/*
 * Copyright (C) 2009 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _NL_FOLDERS_SOURCE_H_
#define _NL_FOLDERS_SOURCE_H_

#include <glib.h>
#include <clutter/clutter.h>
#include <netbook-launcher/nl-shell.h>

#define NL_TYPE_FOLDERS_SOURCE (nl_folders_source_get_type ())

#define NL_FOLDERS_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	NL_TYPE_FOLDERS_SOURCE, NlFoldersSource))

#define NL_FOLDERS_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	NL_TYPE_FOLDERS_SOURCE, NlFoldersSourceClass))

#define NL_IS_FOLDERS_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	NL_TYPE_FOLDERS_SOURCE))

#define NL_IS_FOLDERS_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	NL_TYPE_FOLDERS_SOURCE))

#define NL_FOLDERS_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	NL_TYPE_FOLDERS_SOURCE, NlFoldersSourceClass))

typedef struct _NlFoldersSource        NlFoldersSource;
typedef struct _NlFoldersSourceClass   NlFoldersSourceClass;
typedef struct _NlFoldersSourcePrivate NlFoldersSourcePrivate;
 
struct _NlFoldersSource
{
  GObject        parent;	

  NlFoldersSourcePrivate *priv;
};

struct _NlFoldersSourceClass
{
  GObjectClass   parent_class;
};

GType     nl_folders_source_get_type   (void) G_GNUC_CONST;

GObject * nl_folders_source_new        (NlShell *s);

#endif /* _NL_FOLDERS_SOURCE_H_ */

