/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.lexer.gen.javacc;

import java.lang.reflect.Field;
import java.lang.SecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.HashMap;
import java.util.Set;
import java.util.List;
import org.netbeans.modules.lexer.gen.MutableTokenId;
import org.netbeans.modules.lexer.gen.TokenTypes;

/**
 * Encapsulation of xxxConstants class generated by JavaCC.
 *
 * @author Miloslav Metelka
 * @version 1.00
 */

public class JavaCCTokenTypes extends TokenTypes {
    
    private boolean defaultStateFieldFound;
    
    private final Map name2sample = new HashMap();
    
    /**
     * Maximum value of state determined as maximum constant that occurs
     * in the xxxConstants class after DEFAULT field.
     */
    private int maxState;
    
    public JavaCCTokenTypes(Class tokenTypesClass) {
        super(tokenTypesClass);
    }
    
    protected void updateId(MutableTokenId id) {
        super.updateId(id);
        
        String sampleText = getSampleText(id.getTokenTypeName());
        if (sampleText != null) {
            id.addSampleText(sampleText);
        }
    }

    public String getSampleText(String tokenTypeName) {
        inspect();

        return (String)name2sample.get(tokenTypeName);
    }
    
    public int getMaxState() {
        return maxState;
    }

    protected boolean inspect() {
        if (!super.inspect()) {
            return false;
        }

        try {
            Field tokenImageField = getTokenTypesClass().getDeclaredField("tokenImage");
            String[] tokenImage = (String[])tokenImageField.get(null);

            for (int i = 0; i < tokenImage.length; i++) {
                String tokenTypeName = getTokenTypeName(i);
                if (tokenTypeName != null) {
                    String img = tokenImage[i];
                    if (img != null && img.startsWith("\"")) {
                        img = img.substring(1, img.length() - 1);
                        name2sample.put(tokenTypeName, img);
                    }
                }
            }

        } catch (NoSuchFieldException e) {
            e.printStackTrace();
        } catch (SecurityException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        
        return true; // inspection really done
    }

    protected boolean isAccepted(String tokenTypeName, int tokenTypeValue) {
        if (!defaultStateFieldFound) {
            if ("DEFAULT".equals(tokenTypeName)) {
                defaultStateFieldFound = true;
            }

        } else { // default state already found
            maxState = Math.max(maxState, tokenTypeValue);
        }

        return !defaultStateFieldFound;
    }

}

