/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.mercurial.ui.wizards;

import javax.swing.JPanel;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.openide.util.NbBundle;

public final class ClonePathsPanel extends JPanel implements ActionListener {
    private String message;
    
    /** Creates new form CloneVisualPanel2 */
    public ClonePathsPanel() {
        initComponents();
    }
    
    public String getName() {
        if (pathsPanel == null) {
            return null;
        }
        return pathsPanel.getName();
    }
    
    public String getPullPath() {
        return defaultPullPathField.getText();
    }

    public String getPushPath() {
        return defaultPushPathField.getText();
    }

    public String getMessage() {
        return message;
    }

    public boolean isValid() {
        String pullPath = defaultPullPathField.getText();
        String pushPath = defaultPushPathField.getText();
        if ((pullPath == null || pullPath.equals("")) && (pushPath == null || pushPath.equals(""))) {
            message = NbBundle.getMessage(CloneRepositoryPanel.class, "MSG_NO_PATHS_SPECIFIED_USE_DEFAULTS"); // NOI18N
            return false;
        } else {
            if (pullPath == null || pullPath.equals("")) {
                    pullPath = pushPath;
            }
            if (pushPath == null || pushPath.equals("")) {
                    pushPath = pullPath;
            }
            message = "";
            return true;
        }
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        pathsPanel = new javax.swing.JPanel();
        defaultPullPathLabel = new javax.swing.JLabel();
        defaultPushPathLabel = new javax.swing.JLabel();
        jLabel1 = new javax.swing.JLabel();

        pathsPanel.setName(org.openide.util.NbBundle.getMessage(ClonePathsPanel.class, "pathsPanel.Name")); // NOI18N

        defaultPullPathLabel.setLabelFor(defaultPullPathField);
        org.openide.awt.Mnemonics.setLocalizedText(defaultPullPathLabel, org.openide.util.NbBundle.getMessage(ClonePathsPanel.class, "defaultPullLabel.Name")); // NOI18N

        defaultPullPathField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                defaultPullPathFieldActionPerformed(evt);
            }
        });

        defaultPushPathLabel.setLabelFor(defaultPushPathField);
        org.openide.awt.Mnemonics.setLocalizedText(defaultPushPathLabel, org.openide.util.NbBundle.getMessage(ClonePathsPanel.class, "defaultPushLabel.Name")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, org.openide.util.NbBundle.getMessage(ClonePathsPanel.class, "defaultLabel.Name")); // NOI18N

        org.jdesktop.layout.GroupLayout pathsPanelLayout = new org.jdesktop.layout.GroupLayout(pathsPanel);
        pathsPanel.setLayout(pathsPanelLayout);
        pathsPanelLayout.setHorizontalGroup(
            pathsPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(pathsPanelLayout.createSequentialGroup()
                .add(pathsPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(pathsPanelLayout.createSequentialGroup()
                        .add(pathsPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                            .add(defaultPushPathLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .add(defaultPullPathLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(pathsPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(defaultPullPathField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 505, Short.MAX_VALUE)
                            .add(defaultPushPathField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 505, Short.MAX_VALUE)))
                    .add(jLabel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 605, Short.MAX_VALUE))
                .addContainerGap())
        );
        pathsPanelLayout.setVerticalGroup(
            pathsPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(pathsPanelLayout.createSequentialGroup()
                .add(jLabel1)
                .add(20, 20, 20)
                .add(pathsPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(defaultPullPathLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(defaultPullPathField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(28, 28, 28)
                .add(pathsPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(defaultPushPathLabel)
                    .add(defaultPushPathField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(125, 125, 125))
        );

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(pathsPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(pathsPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(68, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void defaultPullPathFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_defaultPullPathFieldActionPerformed
        // TODO add your handling code here:
}//GEN-LAST:event_defaultPullPathFieldActionPerformed
    
    public void actionPerformed(ActionEvent evt) {
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    final javax.swing.JTextField defaultPullPathField = new javax.swing.JTextField();
    private javax.swing.JLabel defaultPullPathLabel;
    final javax.swing.JTextField defaultPushPathField = new javax.swing.JTextField();
    private javax.swing.JLabel defaultPushPathLabel;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JPanel pathsPanel;
    // End of variables declaration//GEN-END:variables
    
}

