#!/usr/bin/python
import os
from ubiquity.plugin import *
import locale
import gettext

# Plugin settings
NAME='eula'
AFTER='language'
WEIGHT=30


class PageGtk(PluginUI):
    plugin_prefix = 'eula'

    def __init__(self, controller, *args, **kwargs):
        import gtk
        self.builder = gtk.Builder()
        self.builder.add_from_file("/usr/lib/ubiquity/plugins/eula.glade")
        self.builder.connect_signals(self)
        self.controller = controller
        self.controller.add_builder(self.builder)
        self.checkbutton1 = self.builder.get_object("checkbutton1")
        self.checkbutton1.connect("toggled", self.check_accepted)
        self.page = self.builder.get_object("vbox1")
        self.page.set_name("eula")
        self.plugin_widgets = self.page

    def check_accepted(self, widget):
        if widget.get_active():
            self.controller.allow_go_forward(True)
        else: 
            self.controller.allow_go_forward(False)

    # Custom controls
    def get_mode(self):
        return
        #return self.page.get_active()
    def set_mode(self, on):
        #self.page.set_active(on)
        return

class Page(Plugin):
    def prepare(self, unfiltered=False):
        # self.ui is PageGtk above
        mode = self.db.get('eula/eula')
        self.ui.set_mode(mode == 'true')

# disable the forward button by default because user needs to accept eula
# unless user has already accepted the eula, in which case enable it
        if not self.ui.checkbutton1.get_active():
            self.ui.controller.allow_go_forward(False)
# reset locale and gettext on each prepare and then show translations since the user can
# can back to languages page and select a new language
        locale.setlocale(locale.LC_ALL, '')
        gettext.install("oemconfigplugins", "/usr/share/locale")
        self.ui.label1 = self.ui.builder.get_object("label1")
        self.ui.label1.set_markup(_("<b>End User License Agreement</b>"))
        self.ui.checkbutton1 = self.ui.builder.get_object("checkbutton1")
        self.ui.checkbutton1.set_label(_("I accept the license"))
        self.ui.textbuffer = self.ui.builder.get_object("textview1").get_buffer()
        self.ui.textbuffer.set_text(_('eula_text'))

        return Plugin.prepare(self, unfiltered=unfiltered)

    def ok_handler(self):
        mode = self.ui.get_mode()
        self.preseed_bool('eula/eula', mode)
        Plugin.ok_handler(self)

