var theurl = "";
var theurlid = 0;
var tags_was_focused = false;
var old_tags_value = "";
var searchbox_value = "";

// handle dialog load event
function init()
{
	// grab the url you are commenting on
	var args = window.arguments;
	theurl = args[0];
	theurlid = args[1];
	searchbox_value = args[2];
	quote = args[3];
	
	document.getElementById("firstrater-prompt").hidden = (theurlid != 0);
	
	document.getElementById("review").value = quote;

	var tags = document.getElementById("tags");

	tags.autocompleteDatasource =
				{
					getResults : function ()
					{
						var tags = document.getElementById("tags");
						return opener.su_get_autocomplete_results(
									"tag",
									tags.value,
									tags.maxRows,
									new Array(searchbox_value));
					}
				}
}

// handle dialog accept event
function doOK()
{
	// blank url
	if (theurl == "" || theurlid == 0)
		return true;

	var tags = document.getElementById("tags").value;
	if (tags == null)
		return true;

	var review = document.getElementById("review").value;
	if (review == null)
		return true;

	var tagerror = opener.su_validate_tagstring(tags);
	if (tagerror != null)
	{
		alert(tagerror);
		document.getElementById("tags").focus();
		return false;
	}	
	
	// We create zero delay timeouts in the context of the parent 
	// window, then destroy this window after two seconds.  The delay
	// adds the illusion of immediacy.  And the zero delay timeouts 
	// make sure the submissions occur even if this window is destroyed
	// while the submissions are in progress. -- JW
	
	if (review.search(/^\s*$/) == -1)
	{
		// add review
		opener.setTimeout(function(parent, theurlid, review){ parent.su_add_review(theurlid, review); }, 0, opener, theurlid, review);
	}
	if (tags != '')
	{
		opener.document.getElementById("su_searchbox").value = tags;
		opener.setTimeout(function(parent, tags){ parent.su_tagit(tags, false); }, 0, opener, tags);
	}

	setTimeout("closeWindow();", 2000);

	return false;
}

// used by doOK() to close this window after a timeout
function closeWindow()
{
	close();
}

// handle dialog cancel event
function doCancel()
{
	return true;
}

// handle tags box click event
function tags_click_kludge(eventId)
{
	// This handles value selection in the case where the user is
	// clicking back and forth between tags and another field
	// (like review).  Without this kludge, the text is selected only
	// every second time.  (ref: Firefox 1.5, XP) -- JW

	switch (eventId)
	{
		case "click":
			var tags = document.getElementById('tags');
			var selected = (tags.value.length != 0)
						&& ((tags.selectionEnd - tags.selectionStart) == tags.value.length);

			if ((! tags_was_focused) && (! selected))
			{
				tags.select();
			}
			tags_was_focused = true;
		break;
		case "blur":
			tags_was_focused = false;
		break;
	}

	return true;
}

// handle tags box focus event
function handle_tags_focus(evt)
{
	var tags = document.getElementById('tags');

	if (tags.value != "")
	{
		tags.select();
	}
}

// handle tags box keyup event
function handle_tags_keyup(evt)
{
	old_tags_value = document.getElementById("tags").value;
	return true;
}

// handle tags box textentered event
function handle_tags_textentered()
{
	document.getElementById("stumble_rating_dialog").acceptDialog();
}

// handle tags box textreverted event
function handle_tags_textreverted()
{
	document.getElementById("tags").value = old_tags_value;
	document.getElementById("tags").select();
}

