/* mhs: A GObject wrapper for the Mozilla Mhs API
 *
 * Copyright (C) 2009  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __MHS_LOGIN_MANAGER_STORAGE_H__
#define __MHS_LOGIN_MANAGER_STORAGE_H__

#include <glib-object.h>

G_BEGIN_DECLS

#define MHS_TYPE_LOGIN_MANAGER_STORAGE          \
  (mhs_login_manager_storage_get_type())
#define MHS_LOGIN_MANAGER_STORAGE(obj)                          \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj),                           \
                               MHS_TYPE_LOGIN_MANAGER_STORAGE,  \
                               MhsLoginManagerStorage))
#define MHS_LOGIN_MANAGER_STORAGE_CLASS(klass)                  \
  (G_TYPE_CHECK_CLASS_CAST ((klass),                            \
                            MHS_TYPE_LOGIN_MANAGER_STORAGE,     \
                            MhsLoginManagerStorageClass))
#define MHS_IS_LOGIN_MANAGER_STORAGE(obj)                       \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj),                           \
                               MHS_TYPE_LOGIN_MANAGER_STORAGE))
#define MHS_IS_LOGIN_MANAGER_STORAGE_CLASS(klass)               \
  (G_TYPE_CHECK_CLASS_TYPE ((klass),                            \
                            MHS_TYPE_LOGIN_MANAGER_STORAGE))
#define MHS_LOGIN_MANAGER_STORAGE_GET_CLASS(obj)                \
  (G_TYPE_INSTANCE_GET_CLASS ((obj),                            \
                              MHS_TYPE_LOGIN_MANAGER_STORAGE,   \
                              MhsLoginManagerStorageClass))

typedef struct _MhsLoginManagerStorage         MhsLoginManagerStorage;
typedef struct _MhsLoginManagerStorageClass    MhsLoginManagerStorageClass;
typedef struct _MhsLoginManagerStoragePrivate  MhsLoginManagerStoragePrivate;

struct _MhsLoginManagerStorageClass
{
  GObjectClass parent_class;
};

struct _MhsLoginManagerStorage
{
  GObject parent;

  MhsLoginManagerStoragePrivate *priv;
};

GType mhs_login_manager_storage_get_type (void) G_GNUC_CONST;

MhsLoginManagerStorage *mhs_login_manager_storage_new (void);

G_END_DECLS

#endif /* __MHS_LOGIN_MANAGER_STORAGE_H__ */
