/*
 * Moblin-Web-Browser: The web browser for Moblin
 * Copyright (c) 2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef _MWB_TAB_H
#define _MWB_TAB_H

#include <glib-object.h>
#include <clutter/clutter.h>
#include <nbtk/nbtk.h>

G_BEGIN_DECLS

#define MWB_TYPE_TAB mwb_tab_get_type()

#define MWB_TAB(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
  MWB_TYPE_TAB, MwbTab))

#define MWB_TAB_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), \
  MWB_TYPE_TAB, MwbTabClass))

#define MWB_IS_TAB(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
  MWB_TYPE_TAB))

#define MWB_IS_TAB_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), \
  MWB_TYPE_TAB))

#define MWB_TAB_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), \
  MWB_TYPE_TAB, MwbTabClass))

typedef struct _MwbTabPrivate MwbTabPrivate;

typedef struct {
  NbtkWidget parent;

  MwbTabPrivate *priv;
} MwbTab;

typedef struct {
  NbtkWidgetClass parent_class;

  void (* clicked)             (MwbTab *tab);
  void (* closed)              (MwbTab *tab);
  void (* transition_complete) (MwbTab *tab);
} MwbTabClass;

GType mwb_tab_get_type (void);

NbtkWidget *mwb_tab_new (void);
NbtkWidget *mwb_tab_new_full (const gchar *text, ClutterActor *icon, gint width);

void mwb_tab_set_text                (MwbTab *tab, const gchar  *text);
void mwb_tab_set_default_icon        (MwbTab *tab, ClutterActor *icon);
void mwb_tab_set_icon                (MwbTab *tab, ClutterActor *icon);
void mwb_tab_set_can_close           (MwbTab *tab, gboolean      can_close);
void mwb_tab_set_width               (MwbTab *tab, gint          width);
void mwb_tab_set_docking             (MwbTab *tab, gboolean      docking);
void mwb_tab_set_preview_actor       (MwbTab *tab, ClutterActor *actor);
void mwb_tab_set_preview_mode        (MwbTab *tab, gboolean      preview);
void mwb_tab_set_preview_duration    (MwbTab *tab, guint         duration);
void mwb_tab_set_spacing             (MwbTab *tab, gfloat        spacing);
void mwb_tab_set_private             (MwbTab *tab, gboolean      private);
void mwb_tab_set_active              (MwbTab *tab, gboolean      active);

const gchar  *mwb_tab_get_text                (MwbTab *tab);
ClutterActor *mwb_tab_get_icon                (MwbTab *tab);
gboolean      mwb_tab_get_can_close           (MwbTab *tab);
gint          mwb_tab_get_width               (MwbTab *tab);
gboolean      mwb_tab_get_docking             (MwbTab *tab);
ClutterActor *mwb_tab_get_preview_actor       (MwbTab *tab);
gboolean      mwb_tab_get_preview_mode        (MwbTab *tab);
void          mwb_tab_get_height_no_preview   (MwbTab *tab,
                                               gfloat  for_width,
                                               gfloat *min_height_p,
                                               gfloat *natural_height_p);
guint         mwb_tab_get_preview_duration    (MwbTab *tab);
gfloat        mwb_tab_get_spacing             (MwbTab *tab);
gboolean      mwb_tab_get_private             (MwbTab *tab);
gboolean      mwb_tab_get_active              (MwbTab *tab);

void mwb_tab_alert                   (MwbTab *tab);
void mwb_tab_enable_drag             (MwbTab *tab, gboolean enable);

G_END_DECLS

#endif /* _MWB_TAB_H */

