/*
 * Moblin-Web-Browser: The web browser for Moblin
 * Copyright (c) 2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef _MWB_DBUS_H
#define _MWB_DBUS_H

#include <glib-object.h>

#include "mwb-window.h"
#include "mwb-browser.h"

G_BEGIN_DECLS

#define MWB_TYPE_DBUS mwb_dbus_get_type()

#define MWB_DBUS(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
  MWB_TYPE_DBUS, MwbDbus))

#define MWB_DBUS_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), \
  MWB_TYPE_DBUS, MwbDbusClass))

#define MWB_IS_DBUS(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
  MWB_TYPE_DBUS))

#define MWB_IS_DBUS_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), \
  MWB_TYPE_DBUS))

#define MWB_DBUS_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), \
  MWB_TYPE_DBUS, MwbDbusClass))

#define MWB_DBUS_SERVICE   "org.moblin.MoblinWebBrowser"
#define MWB_DBUS_PATH      "/org/moblin/MoblinWebBrowser"
#define MWB_DBUS_INTERFACE "org.moblin.MoblinWebBrowser"

typedef struct _MwbDbusPrivate MwbDbusPrivate;

typedef struct {
  GObject parent;

  MwbDbusPrivate *priv;
} MwbDbus;

typedef struct {
  GObjectClass parent_class;
} MwbDbusClass;

GType mwb_dbus_get_type (void);

MwbDbus* mwb_dbus_create (MwbWindow *main_window, MwbBrowser *main_browser);

gboolean mwb_dbus_new_tab         (MwbDbus      *self,
                                   const gchar  *url,
                                   gboolean      replace,
                                   gboolean      use_existing,
                                   GError       *error);
gboolean mwb_dbus_new_tab_with_flags (MwbDbus             *self,
                                      const gchar         *url,
                                      MwbBrowserOpenFlags  flags,
                                      GError              *error);
gboolean mwb_dbus_switch_tab      (MwbDbus      *self,
                                   gint          tab,
                                   GError       *error);
gboolean mwb_dbus_raise           (MwbDbus      *self,
                                   GError       *error);
gboolean mwb_dbus_get_tab         (MwbDbus      *self,
                                   gint          tab,
                                   gchar       **url,
                                   gchar       **title,
                                   GError       *error);
gint     mwb_dbus_get_ntabs       (MwbDbus      *self);
gint     mwb_dbus_get_current_tab (MwbDbus      *self);
gboolean mwb_dbus_close_tab       (MwbDbus      *self,
                                   gint          tab,
                                   GError       *error);
gboolean mwb_dbus_connect_view    (MwbDbus      *self,
                                   gint          tab,
                                   const gchar  *input,
                                   const gchar  *output,
                                   GError       *error);
gboolean mwb_dbus_start_private_browsing (MwbDbus *self,
                                          GError *error);
gboolean mwb_dbus_purge_session_history (MwbDbus *self,
                                         GError *error);

G_END_DECLS

#endif /* _MWB_DBUS_H */

