/*
 * Moblin-Web-Browser: The web browser for Moblin
 * Copyright (c) 2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <mhs/mhs.h>
#include <nsCOMArray.h>
#include <nsWeakPtr.h>
#include <nsIWeakReferenceUtils.h>
#include <dbus/dbus-glib.h>
#include "mwb-settings.h"

NS_INTERFACE_MAP_BEGIN(MwbSettings)
  NS_INTERFACE_MAP_ENTRY_AMBIGUOUS(nsISupports, MwbISettings)
  NS_INTERFACE_MAP_ENTRY(MwbISettings)
NS_INTERFACE_MAP_END

MwbSettings *MwbSettings::settings = nsnull;

MwbSettings *
MwbSettings::GetSingleton(void)
{
  if (!settings)
    settings = new MwbSettings ();

  return settings;
}

MwbSettings::MwbSettings ()
{
  history = mhs_history_new ();
  cookies = mhs_cookies_new ();
  prefs = mhs_prefs_new ();
  lms = mhs_login_manager_storage_new ();
}

MwbSettings::~MwbSettings ()
{
  g_object_unref (history);
  g_object_unref (cookies);
  g_object_unref (prefs);
  g_object_unref (lms);
}

NS_IMETHODIMP_(nsrefcnt)
MwbSettings::AddRef ()
{
  return 1;
}

NS_IMETHODIMP_(nsrefcnt)
MwbSettings::Release ()
{
  return 1;
}

NS_IMETHODIMP
MwbSettings::ClearHistory ()
{
  GError *error = NULL;
  DBusGConnection *connection;
  DBusGProxy *proxy;

  if (!mhs_history_clear_history (history, &error))
    {
      g_warning ("Failed to clear history: %s", error->message);
      g_clear_error (&error);
    }

  mhs_history_unpin_all_pages (history);

  if (!mhs_cookies_remove_all (cookies, &error))
    {
      g_warning ("Failed to clear cookies: %s", error->message);
      g_clear_error (&error);
    }

  if (!mhs_prefs_reset_user (prefs, &error))
    {
      g_warning ("Failed to clear prefs: %s", error->message);
      g_clear_error (&error);
    }

  if (!mhs_lms_remove_all_logins (lms, &error))
    {
      g_warning ("Failed to clear prefs: %s", error->message);
      g_clear_error (&error);
    }

  /* Ask the browser to clear the session history in all of the tabs */
  connection = dbus_g_bus_get (DBUS_BUS_SESSION, &error);
  if (connection == NULL)
    {
      g_warning ("Failed to connect to session bus: %s", error->message);
      g_clear_error (&error);
    }
  else
    {
      proxy = dbus_g_proxy_new_for_name (connection,
                                         "org.moblin.MoblinWebBrowser",
                                         "/org/moblin/MoblinWebBrowser",
                                         "org.moblin.MoblinWebBrowser");

      if (!dbus_g_proxy_call (proxy, "PurgeSessionHistory", &error,
                              G_TYPE_INVALID, G_TYPE_INVALID))
        {
          g_warning ("Failed to purge session history: %s", error->message);
          g_clear_error (&error);
        }

      g_object_unref (proxy);
    }

  /* Request the pinned pages and favorites so that any tabs on the
     start page will be redrawn */
  mhs_history_get_favorites (history);
  mhs_history_get_pinned_pages (history);

  return NS_OK;
}
