/*
 * Moblin-Web-Browser: The web browser for Moblin
 * Copyright (c) 2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef _MWB_SETTINGS_H
#define _MWB_SETTINGS_H

#include <nsCOMPtr.h>
#include <nsCOMArray.h>
#include <mhs/mhs.h>
#include "MwbISettings.h"

// {48cf35ca-4a8b-46df-a77e-84d001387314}
#define MWB_SETTINGS_CID \
  { 0x48cf35ca, 0x4a8b, 0x46df, \
      { 0xa7, 0x7e, 0x84, 0xd0, 0x01, 0x38, 0x73, 0x14 } }

class MwbSettings : public MwbISettings
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_MWBISETTINGS

  MwbSettings ();
  ~MwbSettings ();

  static MwbSettings *GetSingleton (void);

private:
  static MwbSettings *settings;

  MhsHistory *history;
  MhsCookies *cookies;
  MhsPrefs *prefs;
  MhsLoginManagerStorage *lms;
};

#endif /* _MWB_SETTINGS_H */
