/*
 * Moblin-Web-Browser: The web browser for Moblin
 * Copyright (c) 2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef _MWB_BROWSER_H
#define _MWB_BROWSER_H

#include <glib-object.h>
#include <clutter/clutter.h>
#include <clutter-gtk/clutter-gtk.h>
#include <nbtk/nbtk.h>
#include <gtk/gtk.h>

#include "mwb-tab.h"
#include "mwb-tab-picker.h"
#include "mwb-toolbar.h"
#include "mwb-status-bar.h"
#include "mwb-window.h"

G_BEGIN_DECLS

#define MWB_TYPE_BROWSER mwb_browser_get_type()

#define MWB_BROWSER(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
  MWB_TYPE_BROWSER, MwbBrowser))

#define MWB_BROWSER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), \
  MWB_TYPE_BROWSER, MwbBrowserClass))

#define MWB_IS_BROWSER(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
  MWB_TYPE_BROWSER))

#define MWB_IS_BROWSER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), \
  MWB_TYPE_BROWSER))

#define MWB_BROWSER_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), \
  MWB_TYPE_BROWSER, MwbBrowserClass))

typedef struct _MwbBrowserPrivate MwbBrowserPrivate;

typedef struct {
  ClutterActor parent;

  MwbBrowserPrivate *priv;
} MwbBrowser;

typedef struct {
  ClutterActorClass parent_class;
} MwbBrowserClass;

typedef enum
{
  MWB_BROWSER_OPEN_PRIVATE        = 1,
  MWB_BROWSER_OPEN_USE_EXISTING   = 2,
  MWB_BROWSER_OPEN_NEW_TAB        = 4,
  MWB_BROWSER_OPEN_ACTIVATE       = 8,
  MWB_BROWSER_OPEN_USER_INITIATED = 16
} MwbBrowserOpenFlags;

GType mwb_browser_get_type (void);

ClutterActor* mwb_browser_new (MwbWindow *window);

MwbTab *
mwb_browser_add_tab (MwbBrowser      *browser,
                     const gchar     *title,
                     ClutterActor    *actor,
                     gboolean         new_tab,
                     gboolean         activate);

void mwb_browser_open (MwbBrowser          *browser,
                       const gchar         *url,
                       MwbBrowserOpenFlags  open_flags);

MwbToolbar   * mwb_browser_get_toolbar (MwbBrowser *browser);

MwbTabPicker * mwb_browser_get_tab_picker (MwbBrowser *browser);

GList        * mwb_browser_get_pages (MwbBrowser *browser);

MwbStatusBar * mwb_browser_get_status_bar (MwbBrowser *browser);

void mwb_browser_activate_private (MwbBrowser *browser);

void mwb_browser_purge_session_history (MwbBrowser *browser);

G_END_DECLS

#endif /* _MWB_BROWSER_H */

