const nsIAppShellService    = Components.interfaces.nsIAppShellService;
const nsISupports           = Components.interfaces.nsISupports;
const nsICategoryManager    = Components.interfaces.nsICategoryManager;
const nsIComponentRegistrar = Components.interfaces.nsIComponentRegistrar;
const nsICommandLine        = Components.interfaces.nsICommandLine;
const nsICommandLineHandler = Components.interfaces.nsICommandLineHandler;
const nsIFactory            = Components.interfaces.nsIFactory;
const nsIModule             = Components.interfaces.nsIModule;
const nsIWindowWatcher      = Components.interfaces.nsIWindowWatcher;

// CHANGEME: change the contract id, CID, and category to be unique
// to your application.
const clh_contractID = "@mozilla.org/commandlinehandler/general-startup;1?type=harbour";

// use uuidgen to generate a unique ID
const clh_CID = Components.ID("{71c8e6f9-df9a-4cd3-8c7e-9a9c720dd9d3}");

// category names are sorted alphabetically. Typical command-line handlers use a
// category that begins with the letter "m".
const clh_category = "m-harbour";

/**
 * Utility functions
 */

function harbourGetNewMessages () {

  var gAccountManager = Components.classes ['@mozilla.org/messenger/account-manager;1']
    .getService (Components.interfaces.nsIMsgAccountManager);
  var accounts = gAccountManager.accounts;
  dump ("n accounts = " + accounts.Count() + "\n");
  for (var i = 0; i < accounts.Count (); i++)
  {
    var account = accounts.QueryElementAt (i, Components.interfaces.nsIMsgAccount);
    var folder = null;

    var allFolders = Components.classes ['@mozilla.org/supports-array;1']
      .createInstance (Components.interfaces.nsISupportsArray);
    account.incomingServer.rootFolder.ListDescendents (allFolders);
    dump (allFolders.Count());

    for (var j = 0; j < allFolders.Count (); j++)
    {
      folder = allFolders.QueryElementAt (j, Components.interfaces.nsIMsgFolder);
      if (folder.name != "Inbox")
        continue;
      dump ("found inbox!\n");
    }
    if (folder != null)
      account.incomingServer.getNewMessages (folder, null, null);
  }

  //saveHarbourData ();

}

/**
 * The XPCOM component that implements nsICommandLineHandler and others
 * It also implements nsIFactory to serve as its own singleton factory.
 */
const CI = Components.interfaces, CC = Components.classes, CR = Components.results;
const myAppHandler = {
  /*** nsISupports ***/
  QueryInterface : function clh_QI(iid)
  {
    if (iid.equals(nsICommandLineHandler) ||
        iid.equals(nsIFactory) ||
        iid.equals(nsISupports) ||
        iid.equals(CI.nsIObserver) ||
        iid.equals(CI.nsISupportsWeakReference)
)
{
     dump ("supports "+nsISupports+"\n");
      return this;
}

    throw Components.results.NS_ERROR_NO_INTERFACE;
  },

  /*** nsICommandLineHandler ***/

  handle : function clh_handle(cmdLine)
  {
   
    if (cmdLine.handleFlag("checkmail", false)) {
      cmdLine.preventDefault = true;
    dump ("getting new messages\n");
  
       harbourGetNewMessages ();
    }
  },

  helpInfo : "  -checkmail           Start mail check\n",

  /*** nsIFactory ***/

  createInstance : function clh_CI(outer, iid)
  {
    if (outer != null)
      throw Components.results.NS_ERROR_NO_AGGREGATION;

    return this.QueryInterface(iid);
  },

  lockFactory : function clh_lock(lock)
  {
    /* no-op */
  },


   /*** nsIObserver implementation ***/
   observe: function(aSubject, aTopic, aData)
   {
dump ("observe\n");
      switch(aTopic)
      {
        case "xpcom-startup":
          dump("xpcom-startup");
          // this is run very early, right after XPCOM is initialized, but before
          // user profile information is applied. Register ourselves as an observer
          // for 'profile-after-change' and 'quit-application'.
          var obsSvc = CC["@mozilla.org/observer-service;1"].getService(CI.nsIObserverService);
          obsSvc.addObserver(this, "profile-after-change", true);
          obsSvc.addObserver(this, "quit-application", true);
          break;
        case "profile-after-change":
          // This happens after profile has been loaded and user preferences have been read.
          // startup code here
          dump ("profile-after-change");
          break;

        case "quit-application":
          dump("quit");
          // shutdown code here
          break;

        default:
          throw Components.Exception("Unknown topic: " + aTopic);
     }
   }
};



/**
 * The XPCOM glue that implements nsIModule
 */

const myAppHandlerModule = {
  /* nsISupports */
	   

  QueryInterface : function mod_QI(iid)
  {

    /* this are the interfaces we support */
    if (iid.equals(nsIModule) ||
        iid.equals(nsISupports) 
      return this;

    throw Components.results.NS_ERROR_NO_INTERFACE;
  },

  /* nsIModule */
  getClassObject : function mod_gch(compMgr, cid, iid)
  {
    if (cid.equals(clh_CID))
      return myAppHandler.QueryInterface(iid);

    throw Components.results.NS_ERROR_NOT_REGISTERED;
  },

  registerSelf : function mod_regself(compMgr, fileSpec, location, type)
  {
    compMgr.QueryInterface(nsIComponentRegistrar);

    compMgr.registerFactoryLocation(clh_CID,
                                    "myAppHandler",
                                    clh_contractID,
                                    fileSpec,
                                    location,
                                    type);

    var catMan = Components.classes["@mozilla.org/categorymanager;1"].
      getService(nsICategoryManager);
    catMan.addCategoryEntry("command-line-handler",
                            clh_category,
                            clh_contractID, true, true);

    catMan.addCategoryEntry("xpcom-startup",
	           clh_category, clh_contractID, true, true);
    catMan.addCategoryEntry("xpcom-shutdown",
	           clh_category, clh_contractID, true, true);
    catMan.addCategoryEntry("profile-after-change",
	           clh_category, clh_contractID, true, true);

  },

  unregisterSelf : function mod_unreg(compMgr, location, type)
  {
    compMgr.QueryInterface(nsIComponentRegistrar);
    compMgr.unregisterFactoryLocation(clh_CID, location);

    var catMan = Components.classes["@mozilla.org/categorymanager;1"].
      getService(nsICategoryManager);
    catMan.deleteCategoryEntry("command-line-handler", clh_category);
/*
	        // this must be deleted if you delete the above code dealing with |catman|
	        var catman = CC["@mozilla.org/categorymanager;1"].getService(CI.nsICategoryManager);
	        catman.deleteCategoryEntry("xpcom-startup", MY_OBSERVER_NAME, true);
	        // end of deleteable code
*/
  },

  canUnload : function (compMgr)
  {
    return false;
  }
};

/* The NSGetModule function is the magic entry point that XPCOM uses to find what XPCOM objects
 * this component provides
 */
function NSGetModule(comMgr, fileSpec)
{
  return myAppHandlerModule;
}

