var gAccountManager = Components.classes ['@mozilla.org/messenger/account-manager;1']
  .getService (Components.interfaces.nsIMsgAccountManager);

function debug (str)
{
 // dump ("harbour-DEBUG: " + str + "\n");
}

function saveHarbourData()
{
  // Check to see if we're already active
  if (saveHarbourData.active == 1) {
    if (saveHarbourData.timeoutId == 0) {
      saveHarbourData.timeoutId = window.setTimeout(function () { saveHarbourData.timeoutId = 0; saveHarbourData (); }, 1000);
    }
    return;
  }
  saveHarbourData.active = 1;

  var accounts = gAccountManager.accounts;
  var totalUnread = 0;
  var accountName = "Not Configured";

  debug ("write start");

  /* work out an account name */
  if (accounts.Count () == 0)
    accountName = "Not Configured"
  else if (accounts.Count () == 1)
    accountName = accounts.QueryElementAt (0, Components.interfaces.nsIMsgAccount).defaultIdentity.email
  else
    accountName = "Multiple"

  /* this array contains the mail summary items */
  var summary = new Array ();

  for (var i = 0; i < accounts.Count (); i++)
  {
    var account = accounts.QueryElementAt (i, Components.interfaces.nsIMsgAccount);


    var allFolders = Components.classes ['@mozilla.org/supports-array;1']
      .createInstance (Components.interfaces.nsISupportsArray);
    account.incomingServer.rootFolder.ListDescendents (allFolders);

    /* get the total number of new items for this account */
    var accUnread = account.incomingServer.rootFolder.getNumNewMessages (true);
    totalUnread += accUnread;

    /* find the inbox and store the header objects for later use */
    for (var j = 0; j < allFolders.Count (); j++)
    {
      var folder = allFolders.QueryElementAt (j, Components.interfaces.nsIMsgFolder);

      /* nsMsgFolderFlagType.Inbox = 0x1000 */
      /* Check to see if this folder is the inbox folder */
      if (!folder.getFlag (0x1000))
        continue;
      msgs = folder.getMessages (null)
      while (msgs.hasMoreElements ())
      {
        var hdr = msgs.getNext ().QueryInterface (Components.interfaces.nsIMsgDBHdr);
        summary.push (hdr);
      }
    }
  }

  // get profile directory
  var homedir = Components.classes["@mozilla.org/file/directory_service;1"]
                     .getService(Components.interfaces.nsIProperties)
                     .get("Home", Components.interfaces.nsIFile);

  homedir.append(".cache");
  if( !homedir.exists() || !homedir.isDirectory() ) {   // if it doesn't exist, create
       homedir.create(Components.interfaces.nsIFile.DIRECTORY_TYPE, 0755);
       debug ("creating new directory: " + homedir.path);
  }

  var file = Components.classes ['@mozilla.org/file/local;1']
    .createInstance (Components.interfaces.nsILocalFile);
  file.initWithPath (homedir.path + "/harbour-thunderbird-data")
  
  var stream = Components.classes ['@mozilla.org/network/file-output-stream;1']
    .createInstance (Components.interfaces.nsIFileOutputStream);
  try {
    stream.init (file, 0x20 | 0x08 | 0x02, 0664, 0);
  } catch (ex) {
    dump ('Failed to write data file: ' + ex + "\n");
    saveHarbourData.active = 0;
    return;
  }
  
  stream.write ("[thunderbird-data]\n", 19);
  strUnreadCount = "new_count = " + totalUnread + "\n";
  stream.write (strUnreadCount, strUnreadCount.length);

  strAccountName = "account_name = " + accountName + "\n";
  stream.write (strAccountName, strAccountName.length);

  stream.write ("\n", 1);

  var num = summary.length;
  if (num > 5)
    num = 5;
  /* write summary for all inbox items */
  stream.write ("[inbox-summary]\n", 16);
        str = "count = " + num + "\n";
        stream.write (str, str.length);

  for (var i = summary.length - num; i < summary.length; i++)
  {
    var loop_num = i - summary.length + num;
    strLine = loop_num + "_author = " + summary[i].author + "\n";
    stream.write (strLine, strLine.length);

    strLine = loop_num + "_subject = " + summary[i].subject.replace (/\n/g, " ") + "\n";
    stream.write (strLine, strLine.length);

    strLine = loop_num + "_date = " + summary[i].dateInSeconds + "\n";
    stream.write (strLine, strLine.length);

    strLine = loop_num + "_read = " + summary[i].isRead + "\n";
    stream.write (strLine, strLine.length);
  }

  stream.close ();
  debug ("write finish");
  saveHarbourData.active = 0;
}


var harbournotifyListener = {
  /* we want to update our data snapshot when items are added or removed or a property is changed (e.g. read status) */
  OnItemAdded: function(parentItem, item) { saveHarbourData (); debug ("item added") },
  OnItemRemoved: function(parentItem, item, view) { saveHarbourData (); debug ("item removed")},

  OnItemIntPropertyChanged: function(item, property, oldValue, newValue) {
    /* Properties we might be interested in include:
     * - FolderSize
     * - TotalMessages
     * - TotalUnreadMessages
     * - BiffState - indicates whether the user has new messages
     */
    debug ("int property changed '" + property + "'");
    if (property == "BiffState"
        || property == "TotalUnreadMessages")
    {
      saveHarbourData ();
    }
  },

  // OnItemBoolPropertyChanged: function(item, property, oldValue, newValue) {},
  // OnItemEvent: function(item, event) {},
  // OnItemPropertyChanged: function(item, property, oldValue, newValue) { dump ("item prop" + property + "\n")},
  // OnItemPropertyFlagChanged: function(item, property, oldFlag, newFlag) { dump ("flag " + property + "\n") },
  // OnItemUnicharPropertyChanged: function(item, property, oldValue, newValue) { dump ("unichar prop" + property + "\n")}
};

function HarbourInit ()
{
  /* allow thunderbird to settle before scraping the data */
  window.setTimeout (function () { saveHarbourData (); }, 5000);
}

saveHarbourData.active = 0;
saveHarbourData.timeoutId = 0;
window.addEventListener ("load", HarbourInit, false);

var mailSession = Components.classes["@mozilla.org/messenger/services/session;1"].getService(Components.interfaces.nsIMsgMailSession);
mailSession.AddFolderListener(harbournotifyListener, Components.interfaces.nsIFolderListener.all);
