/* zeitgeist-1.0.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Zeitgeist", lower_case_cprefix = "zeitgeist_")]
namespace Zeitgeist {
	[CCode (cprefix = "ZeitgeistSymbol", lower_case_cprefix = "zeitgeist_symbol_")]
	namespace Symbol {
		[CCode (cheader_filename = "zeitgeist.h")]
		public static GLib.List<weak string> get_all_children (string symbol);
		[CCode (cheader_filename = "zeitgeist.h")]
		public static GLib.List<weak string> get_children (string symbol);
		[CCode (cheader_filename = "zeitgeist.h")]
		public static GLib.List<weak string> get_parents (string symbol);
		[CCode (cheader_filename = "zeitgeist.h")]
		public static bool is_a (string symbol, string parent);
	}
	[CCode (cprefix = "ZeitgeistTimestamp", lower_case_cprefix = "zeitgeist_timestamp_")]
	namespace Timestamp {
		[CCode (cname = "ZEITGEIST_TIMESTAMP_DAY", cheader_filename = "zeitgeist.h")]
		public static int64 DAY;
		[CCode (cname = "ZEITGEIST_TIMESTAMP_HOUR", cheader_filename = "zeitgeist.h")]
		public static int64 HOUR;
		[CCode (cname = "ZEITGEIST_TIMESTAMP_MINUTE", cheader_filename = "zeitgeist.h")]
		public static int64 MINUTE;
		[CCode (cname = "ZEITGEIST_TIMESTAMP_SECOND", cheader_filename = "zeitgeist.h")]
		public static int64 SECOND;
		[CCode (cname = "ZEITGEIST_TIMESTAMP_WEEK", cheader_filename = "zeitgeist.h")]
		public static int64 WEEK;
		[CCode (cname = "ZEITGEIST_TIMESTAMP_YEAR", cheader_filename = "zeitgeist.h")]
		public static int64 YEAR;
		[CCode (cheader_filename = "zeitgeist.h")]
		public static int64 from_date (GLib.Date date);
		[CCode (cheader_filename = "zeitgeist.h")]
		public static int64 from_dmy (GLib.DateDay day, GLib.DateMonth month, GLib.DateYear year);
		[CCode (cheader_filename = "zeitgeist.h")]
		public static int64 from_iso8601 (string datetime);
		[CCode (cheader_filename = "zeitgeist.h")]
		public static int64 from_timeval (GLib.TimeVal tv);
		[CCode (cheader_filename = "zeitgeist.h")]
		public static int64 next_midnight (int64 timestamp);
		[CCode (cname = "zeitgeist_timestamp_for_now", cheader_filename = "zeitgeist.h")]
		public static int64 now ();
		[CCode (cheader_filename = "zeitgeist.h")]
		public static int64 prev_midnight (int64 timestamp);
		[CCode (cheader_filename = "zeitgeist.h")]
		public static int64 to_date (int64 timestamp, out GLib.Date date);
		[CCode (cheader_filename = "zeitgeist.h")]
		public static string to_iso8601 (int64 timestamp);
		[CCode (cheader_filename = "zeitgeist.h")]
		public static int64 to_timeval (int64 timestamp, out GLib.TimeVal tv);
	}
	[CCode (cheader_filename = "zeitgeist.h")]
	public class DataSource : GLib.InitiallyUnowned {
		[CCode (has_construct_function = false)]
		public DataSource ();
		[CCode (has_construct_function = false)]
		public DataSource.full (string id, string name, string desc, owned GLib.PtrArray event_templates);
		public unowned string get_description ();
		public unowned GLib.PtrArray get_event_templates ();
		public unowned string get_name ();
		public int64 get_timestamp ();
		public unowned string get_unique_id ();
		public bool is_enabled ();
		public bool is_running ();
		public void set_description (string description);
		public void set_enabled (bool enabled);
		public void set_event_templates (owned GLib.PtrArray event_templates);
		public void set_name (string name);
		public void set_running (bool running);
		public void set_timestamp (int64 timestamp);
		public void set_unique_id (string unique_id);
	}
	[CCode (cheader_filename = "zeitgeist.h")]
	public class DataSourceRegistry : GLib.Object {
		[CCode (has_construct_function = false)]
		public DataSourceRegistry ();
		public async GLib.PtrArray get_data_sources (GLib.Cancellable? cancellable) throws GLib.Error;
		public async bool register_data_source (owned Zeitgeist.DataSource source, GLib.Cancellable? cancellable) throws GLib.Error;
		public async void set_data_source_enabled (string unique_id, bool enabled, GLib.Cancellable? cancellable) throws GLib.Error;
		public virtual signal void source_disconnected (Zeitgeist.DataSource source);
		public virtual signal void source_enabled (string unique_id, bool enabled);
		public virtual signal void source_registered (Zeitgeist.DataSource source);
	}
	[CCode (cheader_filename = "zeitgeist.h")]
	public class Event : GLib.InitiallyUnowned {
		[CCode (has_construct_function = false)]
		public Event ();
		public void add_subject (Zeitgeist.Subject subject);
		[CCode (has_construct_function = false)]
		public Event.full (string interpretation, string manifestation, string actor, ...);
		[CCode (has_construct_function = false)]
		public Event.full_valist (string interpretation, string manifestation, string actor, void* args);
		public unowned string get_actor ();
		public uint32 get_id ();
		public unowned string get_interpretation ();
		public unowned string get_manifestation ();
		public unowned GLib.ByteArray get_payload ();
		public unowned Zeitgeist.Subject get_subject (int index);
		public int64 get_timestamp ();
		public int num_subjects ();
		public void set_actor (string actor);
		public void set_actor_from_app_info (GLib.AppInfo appinfo);
		public void set_id (uint32 id);
		public void set_interpretation (string interpretation);
		public void set_manifestation (string manifestation);
		public void set_payload (owned GLib.ByteArray payload);
		public void set_timestamp (int64 timestamp);
	}
	[CCode (cheader_filename = "zeitgeist.h")]
	public class Index : GLib.Object {
		[CCode (has_construct_function = false)]
		public Index ();
		public async Zeitgeist.ResultSet search (string query, Zeitgeist.TimeRange time_range, owned GLib.PtrArray event_templates, uint32 offset, uint32 num_events, Zeitgeist.ResultType result_type, GLib.Cancellable? cancellable) throws GLib.Error;
	}
	[CCode (cheader_filename = "zeitgeist.h")]
	public class Log : GLib.Object {
		[CCode (has_construct_function = false)]
		public Log ();
		public async bool delete_events (owned GLib.Array event_ids, GLib.Cancellable? cancellable) throws GLib.Error;
		public async bool delete_log (GLib.Cancellable? cancellable) throws GLib.Error;
		public async GLib.Array find_event_ids (Zeitgeist.TimeRange time_range, owned GLib.PtrArray event_templates, Zeitgeist.StorageState storage_state, uint32 num_events, Zeitgeist.ResultType result_type, GLib.Cancellable? cancellable) throws GLib.Error;
		public async Zeitgeist.ResultSet find_events (Zeitgeist.TimeRange time_range, owned GLib.PtrArray event_templates, Zeitgeist.StorageState storage_state, uint32 num_events, Zeitgeist.ResultType result_type, GLib.Cancellable? cancellable) throws GLib.Error;
		[CCode (array_length = false, array_null_terminated = true)]
		public async string[] find_related_uris (Zeitgeist.TimeRange time_range, owned GLib.PtrArray event_templates, owned GLib.PtrArray result_event_templates, Zeitgeist.StorageState storage_state, uint32 num_events, Zeitgeist.ResultType result_type, GLib.Cancellable? cancellable) throws GLib.Error;
		public async Zeitgeist.ResultSet get_events (owned GLib.Array event_ids, GLib.Cancellable? cancellable) throws GLib.Error;
		public async GLib.Array insert_events (GLib.Cancellable? cancellable, ...) throws GLib.Error;
		[CCode (finish_name = "zeitgeist_log_insert_events_finish")]
		public async GLib.Array insert_events_from_ptrarray (owned GLib.PtrArray events, GLib.Cancellable? cancellable) throws GLib.Error;
		public void insert_events_no_reply (...);
		public async bool install_monitor (Zeitgeist.Monitor monitor, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool is_connected ();
		public async bool quit (GLib.Cancellable? cancellable) throws GLib.Error;
		public async bool remove_monitor (Zeitgeist.Monitor monitor, GLib.Cancellable? cancellable) throws GLib.Error;
		[NoAccessorMethod]
		public bool connected { get; }
	}
	[CCode (cheader_filename = "zeitgeist.h")]
	public class Monitor : GLib.Object, Zeitgeist.EggZeitgeistMonitor {
		[CCode (has_construct_function = false)]
		public Monitor (Zeitgeist.TimeRange time_range, owned GLib.PtrArray event_templates);
		public unowned string get_path ();
		public unowned GLib.PtrArray get_templates ();
		public unowned Zeitgeist.TimeRange get_time_range ();
		[NoAccessorMethod]
		public GLib.PtrArray event_templates { owned get; construct; }
		public Zeitgeist.TimeRange time_range { get; construct; }
		public virtual signal void events_deleted (Zeitgeist.TimeRange time_range, GLib.Array event_ids);
		public virtual signal void events_inserted (Zeitgeist.TimeRange time_range, Zeitgeist.ResultSet events);
	}
	[CCode (cheader_filename = "zeitgeist.h")]
	public class Subject : GLib.InitiallyUnowned {
		[CCode (has_construct_function = false)]
		public Subject ();
		[CCode (has_construct_function = false)]
		public Subject.full (string uri, string interpretation, string manifestation, string mimetype, string origin, string text, string storage);
		public unowned string get_interpretation ();
		public unowned string get_manifestation ();
		public unowned string get_mimetype ();
		public unowned string get_origin ();
		public unowned string get_storage ();
		public unowned string get_text ();
		public unowned string get_uri ();
		public void set_interpretation (string interpretation);
		public void set_manifestation (string manifestation);
		public void set_mimetype (string mimetype);
		public void set_origin (string origin);
		public void set_storage (string storage);
		public void set_text (string text);
		public void set_uri (string uri);
	}
	[CCode (cheader_filename = "zeitgeist.h")]
	public class TimeRange : GLib.InitiallyUnowned {
		[CCode (has_construct_function = false)]
		public TimeRange (int64 start_msec, int64 end_msec);
		[CCode (has_construct_function = false)]
		public TimeRange.anytime ();
		[CCode (has_construct_function = false)]
		public TimeRange.from_now ();
		public int64 get_end ();
		public unowned string get_end_iso8601 ();
		public int64 get_start ();
		public unowned string get_start_iso8601 ();
		[CCode (has_construct_function = false)]
		public TimeRange.to_now ();
	}
	[CCode (cheader_filename = "zeitgeist.h")]
	public interface EggZeitgeistMonitor : GLib.Object {
	}
	[CCode (cheader_filename = "zeitgeist.h")]
	public interface ResultSet : GLib.Object {
		public abstract uint estimated_matches ();
		public abstract bool has_next ();
		[CCode (cname = "_vala_zeitgeist_result_set_iterator")]
		public Zeitgeist.ResultSet iterator ();
		public abstract unowned Zeitgeist.Event next ();
		[CCode (cname = "_vala_zeitgeist_result_set_next_value")]
		public unowned Zeitgeist.Event? next_value ();
		public abstract unowned Zeitgeist.Event peek ();
		public abstract void seek (uint pos);
		public abstract uint size ();
		public abstract uint tell ();
	}
	[CCode (cprefix = "ZEITGEIST_RESULT_TYPE_", cheader_filename = "zeitgeist.h")]
	public enum ResultType {
		MOST_RECENT_EVENTS,
		LEAST_RECENT_EVENTS,
		MOST_RECENT_SUBJECTS,
		LEAST_RECENT_SUBJECTS,
		MOST_POPULAR_SUBJECTS,
		LEAST_POPULAR_SUBJECTS,
		MOST_POPULAR_ACTOR,
		LEAST_POPULAR_ACTOR,
		MOST_RECENT_ACTOR,
		LEAST_RECENT_ACTOR,
		MOST_RECENT_ORIGIN,
		LEAST_RECENT_ORIGIN,
		MOST_POPULAR_ORIGIN,
		LEAST_POPULAR_ORIGIN,
		RELEVANCY
	}
	[CCode (cprefix = "ZEITGEIST_STORAGE_STATE_", cheader_filename = "zeitgeist.h")]
	public enum StorageState {
		NOT_AVAILABLE,
		AVAILABLE,
		ANY
	}
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NCAL_ALARM;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NCAL_ATTACHMENT;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NCAL_CALENDAR;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NCAL_CALENDAR_DATA_OBJECT;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NCAL_EVENT;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NCAL_FREEBUSY;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NCAL_JOURNAL;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NCAL_TIMEZONE;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NCAL_TODO;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NFO_APPLICATION;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NFO_ARCHIVE;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NFO_ARCHIVE_ITEM;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NFO_ATTACHMENT;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NFO_AUDIO;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NFO_BOOKMARK;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NFO_BOOKMARK_FOLDER;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NFO_CURSOR;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NFO_DATA_CONTAINER;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NFO_DELETED_RESOURCE;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NFO_DOCUMENT;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NFO_EMBEDDED_FILE_DATA_OBJECT;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NFO_EXECUTABLE;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NFO_FILESYSTEM;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NFO_FILESYSTEM_IMAGE;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NFO_FILE_DATA_OBJECT;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NFO_FOLDER;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NFO_FONT;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NFO_HARD_DISK_PARTITION;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NFO_HTML_DOCUMENT;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NFO_ICON;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NFO_IMAGE;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NFO_MEDIA;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NFO_MEDIA_LIST;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NFO_MEDIA_STREAM;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NFO_MIND_MAP;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NFO_OPERATING_SYSTEM;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NFO_PAGINATED_TEXT_DOCUMENT;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NFO_PLAIN_TEXT_DOCUMENT;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NFO_PRESENTATION;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NFO_RASTER_IMAGE;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NFO_REMOTE_DATA_OBJECT;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NFO_REMOTE_PORT_ADDRESS;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NFO_SOFTWARE;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NFO_SOFTWARE_ITEM;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NFO_SOFTWARE_SERVICE;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NFO_SOURCE_CODE;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NFO_SPREADSHEET;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NFO_TEXT_DOCUMENT;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NFO_TRASH;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NFO_VECTOR_IMAGE;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NFO_VIDEO;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NFO_VISUAL;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NFO_WEBSITE;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NMM_MOVIE;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NMM_MUSIC_ALBUM;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NMM_MUSIC_PIECE;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NMM_TVSERIES;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NMM_TVSHOW;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NMO_EMAIL;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NMO_IMMESSAGE;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NMO_MAILBOX;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NMO_MAILBOX_DATA_OBJECT;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NMO_MESSAGE;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string NMO_MIME_ENTITY;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string ZG_ACCESS_EVENT;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string ZG_CREATE_EVENT;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string ZG_DELETE_EVENT;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string ZG_EVENT_INTERPRETATION;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string ZG_EVENT_MANIFESTATION;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string ZG_HEURISTIC_ACTIVITY;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string ZG_LEAVE_EVENT;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string ZG_MODIFY_EVENT;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string ZG_RECEIVE_EVENT;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string ZG_SCHEDULED_ACTIVITY;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string ZG_SEND_EVENT;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string ZG_SYSTEM_NOTIFICATION;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string ZG_USER_ACTIVITY;
	[CCode (cheader_filename = "zeitgeist.h")]
	public const string ZG_WORLD_ACTIVITY;
	[CCode (cheader_filename = "zeitgeist.h")]
	public static unowned string interpretation_for_mimetype (string mimetype);
	[CCode (cheader_filename = "zeitgeist.h")]
	public static unowned string manifestation_for_uri (string uri);
	[CCode (cheader_filename = "zeitgeist.h")]
	public static void register_mimetype (string mimetype, string interpretation_uri);
	[CCode (cheader_filename = "zeitgeist.h")]
	public static void register_mimetype_regex (string mimetype_regex, string interpretation_uri);
	[CCode (cheader_filename = "zeitgeist.h")]
	public static void register_uri_scheme (string uri_scheme, string manifestation_type);
}
