#!/usr/bin/python -u
#
# Those are the autogenerated Python bindings for libvirt.
# Check python/generator.py in the source distribution of libvir
# to find out more about the generation process
#

# On cygwin, the DLL is called cygvirtmod.dll
try:
    import libvirtmod
except ImportError, lib_e:
    try:
        import cygvirtmod as libvirtmod
    except ImportError, cyg_e:
        if str(cyg_e).count("No module named"):
            raise lib_e

import types

# The root of all libvirt errors.
class libvirtError(Exception):
    def __init__(self, defmsg, conn=None, dom=None, net=None, pool=None, vol=None):

        if dom is not None:
            conn = dom._conn
        elif net is not None:
            conn = net._conn
        elif pool is not None:
            conn = pool._conn
        elif vol is not None:
            conn = vol._conn

        # Never call virConnGetLastError().
        # virGetLastError() is now thread local
        err = virGetLastError()
        if err is None:
            msg = defmsg
        else:
            msg = err[2]

        Exception.__init__(self, msg)

        self.err = err

    def get_error_code(self):
        if self.err is None:
            return None
        return self.err[0]

    def get_error_domain(self):
        if self.err is None:
            return None
        return self.err[1]

    def get_error_message(self):
        if self.err is None:
            return None
        return self.err[2]

    def get_error_level(self):
        if self.err is None:
            return None
        return self.err[3]

    def get_str1(self):
        if self.err is None:
            return None
        return self.err[4]

    def get_str2(self):
        if self.err is None:
            return None
        return self.err[5]

    def get_str3(self):
        if self.err is None:
            return None
        return self.err[6]

    def get_int1(self):
        if self.err is None:
            return None
        return self.err[7]

    def get_int2(self):
        if self.err is None:
            return None
        return self.err[8]

#
# register the libvirt global error handler
#
def registerErrorHandler(f, ctx):
    """Register a Python written function to for error reporting.
       The function is called back as f(ctx, error), with error
       being a list of information about the error being raised.
       Returns 1 in case of success."""
    return libvirtmod.virRegisterErrorHandler(f,ctx)

def openAuth(uri, auth, flags):
    ret = libvirtmod.virConnectOpenAuth(uri, auth, flags)
    if ret is None:raise libvirtError('virConnectOpenAuth() failed')
    return virConnect(_obj=ret)


#
# Return library version.
#
def getVersion (name = None):
    """If no name parameter is passed (or name is None) then the
    version of the libvirt library is returned as an integer.

    If a name is passed and it refers to a driver linked to the
    libvirt library, then this returns a tuple of (library version,
    driver version).

    If the name passed refers to a non-existent driver, then you
    will get the exception 'no support for hypervisor'.

    Versions numbers are integers: 1000000*major + 1000*minor + release."""
    if name is None:
        ret = libvirtmod.virGetVersion ();
    else:
        ret = libvirtmod.virGetVersion (name);
    if ret is None: raise libvirtError ("virGetVersion() failed")
    return ret


#
# Invoke an EventHandle callback
#
def eventInvokeHandleCallback (watch, fd, event, callback, opaque):
    """
    Invoke the Event Impl Handle Callback in C
    """
    libvirtmod.virEventInvokeHandleCallback(watch, fd, event, callback, opaque);

#
# Invoke an EventTimeout callback
#
def eventInvokeTimeoutCallback (timer, callback, opaque):
    """
    Invoke the Event Impl Timeout Callback in C
    """
    libvirtmod.virEventInvokeTimeoutCallback(timer, callback, opaque);



# WARNING WARNING WARNING WARNING WARNING WARNING WARNING WARNING WARNING
#
# Everything before this line comes from libvir.py
# Everything after this line is automatically generated
#
# WARNING WARNING WARNING WARNING WARNING WARNING WARNING WARNING WARNING
#
# Functions from module libvirt
#

def open(name):
    """This function should be called first to get a connection to
       the Hypervisor and xen store """
    ret = libvirtmod.virConnectOpen(name)
    if ret is None:raise libvirtError('virConnectOpen() failed')
    return virConnect(_obj=ret)

def openReadOnly(name):
    """This function should be called first to get a restricted
      connection to the library functionalities. The set of APIs
      usable are then restricted on the available methods to
      control the domains.  See virConnectOpen for notes about
      environment variables which can have an effect on opening
       drivers """
    ret = libvirtmod.virConnectOpenReadOnly(name)
    if ret is None:raise libvirtError('virConnectOpenReadOnly() failed')
    return virConnect(_obj=ret)

def virEventRegisterImpl(addHandle, updateHandle, removeHandle, addTimeout, updateTimeout, removeTimeout):
    libvirtmod.virEventRegisterImpl(addHandle, updateHandle, removeHandle, addTimeout, updateTimeout, removeTimeout)

def virInitialize():
    """Initialize the library. It's better to call this routine at
      startup in multithreaded applications to avoid potential
       race when initializing the library. """
    ret = libvirtmod.virInitialize()
    if ret == -1: raise libvirtError ('virInitialize() failed')
    return ret

#
# Functions from module virterror
#

def virGetLastError():
    """Provide a pointer to the last error caught at the library
      level  The error object is kept in thread local storage, so
       separate threads can safely access this concurrently. """
    ret = libvirtmod.virGetLastError()
    return ret

def virResetLastError():
    """Reset the last error caught at the library level.  The
      error object is kept in thread local storage, so separate
      threads can safely access this concurrently, only resetting
       their own error object. """
    libvirtmod.virResetLastError()

class virDomain:
    def __init__(self, conn, _obj=None):
        self._conn = conn
        if _obj != None:self._o = _obj;return
        self._o = None

    def __del__(self):
        if self._o != None:
            libvirtmod.virDomainFree(self._o)
        self._o = None

    #
    # virDomain functions from module libvirt
    #

    def ID(self):
        """Get the hypervisor ID number for the domain """
        ret = libvirtmod.virDomainGetID(self._o)
        return ret

    def OSType(self):
        """Get the type of domain operation system. """
        ret = libvirtmod.virDomainGetOSType(self._o)
        if ret is None: raise libvirtError ('virDomainGetOSType() failed', dom=self)
        return ret

    def XMLDesc(self, flags):
        """Provide an XML description of the domain. The description
          may be reused later to relaunch the domain with
           virDomainCreateXML(). """
        ret = libvirtmod.virDomainGetXMLDesc(self._o, flags)
        if ret is None: raise libvirtError ('virDomainGetXMLDesc() failed', dom=self)
        return ret

    def attachDevice(self, xml):
        """Create a virtual device attachment to backend. """
        ret = libvirtmod.virDomainAttachDevice(self._o, xml)
        if ret == -1: raise libvirtError ('virDomainAttachDevice() failed', dom=self)
        return ret

    def blockPeek(self, path, offset, size, buffer, flags):
        """This function allows you to read the contents of a domain's
          disk device.  Typical uses for this are to determine if the
          domain has written a Master Boot Record (indicating that
          the domain has completed installation), or to try to work
          out the state of the domain's filesystems.  (Note that in
          the local case you might try to open the block device or
          file directly, but that won't work in the remote case, nor
          if you don't have sufficient permission. Hence the need for
          this call).  'path' must be a device or file corresponding
          to the domain. In other words it must be the precise string
          returned in a <disk><source dev='...'/></disk> from
          virDomainGetXMLDesc.  'offset' and 'size' represent an area
          which must lie entirely within the device or file.  'size'
          may be 0 to test if the call would succeed.  'buffer' is
          the return buffer and must be at least 'size' bytes.  NB.
          The remote driver imposes a 64K byte limit on 'size'. For
          your program to be able to work reliably over a remote
          connection you should split large requests to <= 65536
           bytes. """
        ret = libvirtmod.virDomainBlockPeek(self._o, path, offset, size, buffer, flags)
        if ret == -1: raise libvirtError ('virDomainBlockPeek() failed', dom=self)
        return ret

    def connect(self):
        """Provides the connection pointer associated with a domain. 
          The reference counter on the connection is not increased by
          this call.  WARNING: When writing libvirt bindings in other
          languages, do not use this function.  Instead, store the
           connection and the domain object together. """
        ret = libvirtmod.virDomainGetConnect(self._o)
        if ret is None:raise libvirtError('virDomainGetConnect() failed', dom=self)
        __tmp = virConnect(_obj=ret)
        return __tmp

    def coreDump(self, to, flags):
        """This method will dump the core of a domain on a given file
          for analysis. Note that for remote Xen Daemon the file path
           will be interpreted in the remote host. """
        ret = libvirtmod.virDomainCoreDump(self._o, to, flags)
        if ret == -1: raise libvirtError ('virDomainCoreDump() failed', dom=self)
        return ret

    def create(self):
        """launch a defined domain. If the call succeed the domain
           moves from the defined to the running domains pools. """
        ret = libvirtmod.virDomainCreate(self._o)
        if ret == -1: raise libvirtError ('virDomainCreate() failed', dom=self)
        return ret

    def destroy(self):
        """Destroy the domain object. The running instance is shutdown
          if not down already and all resources used by it are given
          back to the hypervisor. This does not free the associated
          virDomainPtr object. This function may require privileged
           access """
        ret = libvirtmod.virDomainDestroy(self._o)
        if ret == -1: raise libvirtError ('virDomainDestroy() failed', dom=self)
        return ret

    def detachDevice(self, xml):
        """Destroy a virtual device attachment to backend. """
        ret = libvirtmod.virDomainDetachDevice(self._o, xml)
        if ret == -1: raise libvirtError ('virDomainDetachDevice() failed', dom=self)
        return ret

    def maxMemory(self):
        """Retrieve the maximum amount of physical memory allocated to
          a domain. If domain is None, then this get the amount of
          memory reserved to Domain0 i.e. the domain where the
           application runs. """
        ret = libvirtmod.virDomainGetMaxMemory(self._o)
        if ret == 0: raise libvirtError ('virDomainGetMaxMemory() failed', dom=self)
        return ret

    def maxVcpus(self):
        """Provides the maximum number of virtual CPUs supported for
          the guest VM. If the guest is inactive, this is basically
          the same as virConnectGetMaxVcpus. If the guest is running
          this will reflect the maximum number of virtual CPUs the
           guest was booted with. """
        ret = libvirtmod.virDomainGetMaxVcpus(self._o)
        if ret == -1: raise libvirtError ('virDomainGetMaxVcpus() failed', dom=self)
        return ret

    def memoryPeek(self, start, size, buffer, flags):
        """This function allows you to read the contents of a domain's
          memory.  The memory which is read is controlled by the
          'start', 'size' and 'flags' parameters.  If 'flags' is
          VIR_MEMORY_VIRTUAL then the 'start' and 'size' parameters
          are interpreted as virtual memory addresses for whichever
          task happens to be running on the domain at the moment. 
          Although this sounds haphazard it is in fact what you want
          in order to read Linux kernel state, because it ensures
          that pointers in the kernel image can be interpreted
          coherently.  'buffer' is the return buffer and must be at
          least 'size' bytes. 'size' may be 0 to test if the call
          would succeed.  NB. The remote driver imposes a 64K byte
          limit on 'size'. For your program to be able to work
          reliably over a remote connection you should split large
           requests to <= 65536 bytes. """
        ret = libvirtmod.virDomainMemoryPeek(self._o, start, size, buffer, flags)
        if ret == -1: raise libvirtError ('virDomainMemoryPeek() failed', dom=self)
        return ret

    def migrate(self, dconn, flags, dname, uri, bandwidth):
        """Migrate the domain object from its current host to the
          destination host given by dconn (a connection to the
          destination host).  Flags may be one of more of the
          following: VIR_MIGRATE_LIVE   Attempt a live migration.  If
          a hypervisor supports renaming domains during migration,
          then you may set the dname parameter to the new name
          (otherwise it keeps the same name).  If this is not
          supported by the hypervisor, dname must be None or else you
          will get an error.  Since typically the two hypervisors
          connect directly to each other in order to perform the
          migration, you may need to specify a path from the source
          to the destination.  This is the purpose of the uri
          parameter.  If uri is None, then libvirt will try to find
          the best method.  Uri may specify the hostname or IP
          address of the destination host as seen from the source. 
          Or uri may be a URI giving transport, hostname, user, port,
          etc. in the usual form.  Refer to driver documentation for
          the particular URIs supported.  The maximum bandwidth (in
          Mbps) that will be used to do migration can be specified
          with the bandwidth parameter.  If set to 0, libvirt will
          choose a suitable default.  Some hypervisors do not support
          this feature and will return an error if bandwidth is not
          0.  To see which features are supported by the current
          hypervisor, see virConnectGetCapabilities,
          /capabilities/host/migration_features.  There are many
          limitations on migration imposed by the underlying
          technology - for example it may not be possible to migrate
          between different processors even with the same
           architecture, or between different types of hypervisor. """
        if dconn is None: dconn__o = None
        else: dconn__o = dconn._o
        ret = libvirtmod.virDomainMigrate(self._o, dconn__o, flags, dname, uri, bandwidth)
        if ret is None:raise libvirtError('virDomainMigrate() failed', dom=self)
        __tmp = virDomain(self,_obj=ret)
        return __tmp

    def name(self):
        """Get the public name for that domain """
        ret = libvirtmod.virDomainGetName(self._o)
        return ret

    def reboot(self, flags):
        """Reboot a domain, the domain object is still usable there
          after but the domain OS is being stopped for a restart.
           Note that the guest OS may ignore the request. """
        ret = libvirtmod.virDomainReboot(self._o, flags)
        if ret == -1: raise libvirtError ('virDomainReboot() failed', dom=self)
        return ret

    def ref(self):
        """Increment the reference count on the domain. For each
          additional call to this method, there shall be a
          corresponding call to virDomainFree to release the
          reference count, once the caller no longer needs the
          reference to this object.  This method is typically useful
          for applications where multiple threads are using a
          connection, and it is required that the connection remain
          open until all threads have finished using it. ie, each new
           thread using a domain would increment the reference count. """
        ret = libvirtmod.virDomainRef(self._o)
        if ret == -1: raise libvirtError ('virDomainRef() failed', dom=self)
        return ret

    def resume(self):
        """Resume an suspended domain, the process is restarted from
          the state where it was frozen by calling
          virSuspendDomain(). This function may requires privileged
           access """
        ret = libvirtmod.virDomainResume(self._o)
        if ret == -1: raise libvirtError ('virDomainResume() failed', dom=self)
        return ret

    def save(self, to):
        """This method will suspend a domain and save its memory
          contents to a file on disk. After the call, if successful,
          the domain is not listed as running anymore (this may be a
          problem). Use virDomainRestore() to restore a domain after
           saving. """
        ret = libvirtmod.virDomainSave(self._o, to)
        if ret == -1: raise libvirtError ('virDomainSave() failed', dom=self)
        return ret

    def setAutostart(self, autostart):
        """Configure the domain to be automatically started when the
           host machine boots. """
        ret = libvirtmod.virDomainSetAutostart(self._o, autostart)
        if ret == -1: raise libvirtError ('virDomainSetAutostart() failed', dom=self)
        return ret

    def setMaxMemory(self, memory):
        """Dynamically change the maximum amount of physical memory
          allocated to a domain. If domain is None, then this change
          the amount of memory reserved to Domain0 i.e. the domain
          where the application runs. This function requires
           privileged access to the hypervisor. """
        ret = libvirtmod.virDomainSetMaxMemory(self._o, memory)
        if ret == -1: raise libvirtError ('virDomainSetMaxMemory() failed', dom=self)
        return ret

    def setMemory(self, memory):
        """Dynamically change the target amount of physical memory
          allocated to a domain. If domain is None, then this change
          the amount of memory reserved to Domain0 i.e. the domain
          where the application runs. This function may requires
           privileged access to the hypervisor. """
        ret = libvirtmod.virDomainSetMemory(self._o, memory)
        if ret == -1: raise libvirtError ('virDomainSetMemory() failed', dom=self)
        return ret

    def setVcpus(self, nvcpus):
        """Dynamically change the number of virtual CPUs used by the
          domain. Note that this call may fail if the underlying
          virtualization hypervisor does not support it or if growing
          the number is arbitrary limited. This function requires
           privileged access to the hypervisor. """
        ret = libvirtmod.virDomainSetVcpus(self._o, nvcpus)
        if ret == -1: raise libvirtError ('virDomainSetVcpus() failed', dom=self)
        return ret

    def shutdown(self):
        """Shutdown a domain, the domain object is still usable there
          after but the domain OS is being stopped. Note that the
          guest OS may ignore the request.  TODO: should we add an
          option for reboot, knowing it may not be doable in the
           general case ? """
        ret = libvirtmod.virDomainShutdown(self._o)
        if ret == -1: raise libvirtError ('virDomainShutdown() failed', dom=self)
        return ret

    def suspend(self):
        """Suspends an active domain, the process is frozen without
          further access to CPU resources and I/O but the memory used
          by the domain at the hypervisor level will stay allocated.
          Use virDomainResume() to reactivate the domain. This
           function may requires privileged access. """
        ret = libvirtmod.virDomainSuspend(self._o)
        if ret == -1: raise libvirtError ('virDomainSuspend() failed', dom=self)
        return ret

    def undefine(self):
        """Undefine a domain but does not stop it if it is running """
        ret = libvirtmod.virDomainUndefine(self._o)
        if ret == -1: raise libvirtError ('virDomainUndefine() failed', dom=self)
        return ret

    #
    # virDomain functions from module python
    #

    def UUID(self):
        """Extract the UUID unique Identifier of a domain. """
        ret = libvirtmod.virDomainGetUUID(self._o)
        if ret is None: raise libvirtError ('virDomainGetUUID() failed', dom=self)
        return ret

    def UUIDString(self):
        """Fetch globally unique ID of the domain as a string. """
        ret = libvirtmod.virDomainGetUUIDString(self._o)
        if ret is None: raise libvirtError ('virDomainGetUUIDString() failed', dom=self)
        return ret

    def autostart(self):
        """Extract the autostart flag for a domain """
        ret = libvirtmod.virDomainGetAutostart(self._o)
        if ret == -1: raise libvirtError ('virDomainGetAutostart() failed', dom=self)
        return ret

    def blockStats(self, path):
        """Extracts block device statistics for a domain """
        ret = libvirtmod.virDomainBlockStats(self._o, path)
        if ret is None: raise libvirtError ('virDomainBlockStats() failed', dom=self)
        return ret

    def info(self):
        """Extract information about a domain. Note that if the
          connection used to get the domain is limited only a partial
           set of the information can be extracted. """
        ret = libvirtmod.virDomainGetInfo(self._o)
        if ret is None: raise libvirtError ('virDomainGetInfo() failed', dom=self)
        return ret

    def interfaceStats(self, path):
        """Extracts interface device statistics for a domain """
        ret = libvirtmod.virDomainInterfaceStats(self._o, path)
        if ret is None: raise libvirtError ('virDomainInterfaceStats() failed', dom=self)
        return ret

    def pinVcpu(self, vcpu, cpumap):
        """Dynamically change the real CPUs which can be allocated to
          a virtual CPU. This function requires privileged access to
           the hypervisor. """
        ret = libvirtmod.virDomainPinVcpu(self._o, vcpu, cpumap)
        if ret == -1: raise libvirtError ('virDomainPinVcpu() failed', dom=self)
        return ret

    def schedulerParameters(self):
        """Get the scheduler parameters, the @params array will be
           filled with the values. """
        ret = libvirtmod.virDomainGetSchedulerParameters(self._o)
        if ret == -1: raise libvirtError ('virDomainGetSchedulerParameters() failed', dom=self)
        return ret

    def schedulerType(self):
        """Get the scheduler type. """
        ret = libvirtmod.virDomainGetSchedulerType(self._o)
        if ret is None: raise libvirtError ('virDomainGetSchedulerType() failed', dom=self)
        return ret

    def setSchedulerParameters(self, params):
        """Change the scheduler parameters """
        ret = libvirtmod.virDomainSetSchedulerParameters(self._o, params)
        if ret == -1: raise libvirtError ('virDomainSetSchedulerParameters() failed', dom=self)
        return ret

    def vcpus(self):
        """Extract information about virtual CPUs of domain, store it
          in info array and also in cpumaps if this pointer is'nt
           None. """
        ret = libvirtmod.virDomainGetVcpus(self._o)
        if ret == -1: raise libvirtError ('virDomainGetVcpus() failed', dom=self)
        return ret

class virNetwork:
    def __init__(self, conn, _obj=None):
        self._conn = conn
        if _obj != None:self._o = _obj;return
        self._o = None

    def __del__(self):
        if self._o != None:
            libvirtmod.virNetworkFree(self._o)
        self._o = None

    #
    # virNetwork functions from module libvirt
    #

    def XMLDesc(self, flags):
        """Provide an XML description of the network. The description
          may be reused later to relaunch the network with
           virNetworkCreateXML(). """
        ret = libvirtmod.virNetworkGetXMLDesc(self._o, flags)
        if ret is None: raise libvirtError ('virNetworkGetXMLDesc() failed', net=self)
        return ret

    def bridgeName(self):
        """Provides a bridge interface name to which a domain may
           connect a network interface in order to join the network. """
        ret = libvirtmod.virNetworkGetBridgeName(self._o)
        if ret is None: raise libvirtError ('virNetworkGetBridgeName() failed', net=self)
        return ret

    def connect(self):
        """Provides the connection pointer associated with a network. 
          The reference counter on the connection is not increased by
          this call.  WARNING: When writing libvirt bindings in other
          languages, do not use this function.  Instead, store the
           connection and the network object together. """
        ret = libvirtmod.virNetworkGetConnect(self._o)
        if ret is None:raise libvirtError('virNetworkGetConnect() failed', net=self)
        __tmp = virConnect(_obj=ret)
        return __tmp

    def create(self):
        """Create and start a defined network. If the call succeed the
          network moves from the defined to the running networks
           pools. """
        ret = libvirtmod.virNetworkCreate(self._o)
        if ret == -1: raise libvirtError ('virNetworkCreate() failed', net=self)
        return ret

    def destroy(self):
        """Destroy the network object. The running instance is
          shutdown if not down already and all resources used by it
          are given back to the hypervisor. This does not free the
          associated virNetworkPtr object. This function may require
           privileged access """
        ret = libvirtmod.virNetworkDestroy(self._o)
        if ret == -1: raise libvirtError ('virNetworkDestroy() failed', net=self)
        return ret

    def name(self):
        """Get the public name for that network """
        ret = libvirtmod.virNetworkGetName(self._o)
        return ret

    def ref(self):
        """Increment the reference count on the network. For each
          additional call to this method, there shall be a
          corresponding call to virNetworkFree to release the
          reference count, once the caller no longer needs the
          reference to this object.  This method is typically useful
          for applications where multiple threads are using a
          connection, and it is required that the connection remain
          open until all threads have finished using it. ie, each new
           thread using a network would increment the reference count. """
        ret = libvirtmod.virNetworkRef(self._o)
        if ret == -1: raise libvirtError ('virNetworkRef() failed', net=self)
        return ret

    def setAutostart(self, autostart):
        """Configure the network to be automatically started when the
           host machine boots. """
        ret = libvirtmod.virNetworkSetAutostart(self._o, autostart)
        if ret == -1: raise libvirtError ('virNetworkSetAutostart() failed', net=self)
        return ret

    def undefine(self):
        """Undefine a network but does not stop it if it is running """
        ret = libvirtmod.virNetworkUndefine(self._o)
        if ret == -1: raise libvirtError ('virNetworkUndefine() failed', net=self)
        return ret

    #
    # virNetwork functions from module python
    #

    def UUID(self):
        """Extract the UUID unique Identifier of a network. """
        ret = libvirtmod.virNetworkGetUUID(self._o)
        if ret is None: raise libvirtError ('virNetworkGetUUID() failed', net=self)
        return ret

    def UUIDString(self):
        """Fetch globally unique ID of the network as a string. """
        ret = libvirtmod.virNetworkGetUUIDString(self._o)
        if ret is None: raise libvirtError ('virNetworkGetUUIDString() failed', net=self)
        return ret

    def autostart(self):
        """Extract the autostart flag for a network. """
        ret = libvirtmod.virNetworkGetAutostart(self._o)
        if ret == -1: raise libvirtError ('virNetworkGetAutostart() failed', net=self)
        return ret

    def networkLookupByUUID(self, uuid):
        """Try to lookup a network on the given hypervisor based on
           its UUID. """
        ret = libvirtmod.virNetworkLookupByUUID(self._o, uuid)
        if ret is None:raise libvirtError('virNetworkLookupByUUID() failed', net=self)
        __tmp = virNetwork(self, _obj=ret)
        return __tmp

class virInterface:
    def __init__(self, conn, _obj=None):
        self._conn = conn
        if _obj != None:self._o = _obj;return
        self._o = None

    def __del__(self):
        if self._o != None:
            libvirtmod.virInterfaceFree(self._o)
        self._o = None

    #
    # virInterface functions from module libvirt
    #

    def ceCreate(self, flags):
        """Activate an interface (ie call "ifup") """
        ret = libvirtmod.virInterfaceCreate(self._o, flags)
        if ret == -1: raise libvirtError ('virInterfaceCreate() failed', net=self)
        return ret

    def ceDestroy(self, flags):
        """deactivate an interface (ie call "ifdown") This does not
          remove the interface from the config, and does not free the
           associated virInterfacePtr object. """
        ret = libvirtmod.virInterfaceDestroy(self._o, flags)
        if ret == -1: raise libvirtError ('virInterfaceDestroy() failed', net=self)
        return ret

    def ceRef(self):
        """Increment the reference count on the interface. For each
          additional call to this method, there shall be a
          corresponding call to virInterfaceFree to release the
          reference count, once the caller no longer needs the
          reference to this object.  This method is typically useful
          for applications where multiple threads are using a
          connection, and it is required that the connection remain
          open until all threads have finished using it. ie, each new
          thread using a interface would increment the reference
           count. """
        ret = libvirtmod.virInterfaceRef(self._o)
        if ret == -1: raise libvirtError ('virInterfaceRef() failed', net=self)
        return ret

    def ceUndefine(self):
        """Undefine an interface, ie remove it from the config. This
           does not free the associated virInterfacePtr object. """
        ret = libvirtmod.virInterfaceUndefine(self._o)
        if ret == -1: raise libvirtError ('virInterfaceUndefine() failed', net=self)
        return ret

    def etConnect(self):
        """Provides the connection pointer associated with an
          interface.  The reference counter on the connection is not
          increased by this call.  WARNING: When writing libvirt
          bindings in other languages, do not use this function. 
          Instead, store the connection and the interface object
           together. """
        ret = libvirtmod.virInterfaceGetConnect(self._o)
        if ret is None:raise libvirtError('virInterfaceGetConnect() failed', net=self)
        __tmp = virConnect(_obj=ret)
        return __tmp

    def etMACString(self):
        """Get the MAC for a interface as string. For more information
           about MAC see RFC4122. """
        ret = libvirtmod.virInterfaceGetMACString(self._o)
        if ret is None: raise libvirtError ('virInterfaceGetMACString() failed', net=self)
        return ret

    def etName(self):
        """Get the public name for that interface """
        ret = libvirtmod.virInterfaceGetName(self._o)
        return ret

    def etXMLDesc(self, flags):
        """Provide an XML description of the interface. The
          description may be reused later to recreate the interface
           with virInterfaceCreateXML(). """
        ret = libvirtmod.virInterfaceGetXMLDesc(self._o, flags)
        if ret is None: raise libvirtError ('virInterfaceGetXMLDesc() failed', net=self)
        return ret

class virStoragePool:
    def __init__(self, conn, _obj=None):
        self._conn = conn
        if not isinstance(conn, virConnect):
            self._conn = conn._conn
        if _obj != None:self._o = _obj;return
        self._o = None

    def __del__(self):
        if self._o != None:
            libvirtmod.virStoragePoolFree(self._o)
        self._o = None

    #
    # virStoragePool functions from module libvirt
    #

    def XMLDesc(self, flags):
        """Fetch an XML document describing all aspects of the storage
          pool. This is suitable for later feeding back into the
           virStoragePoolCreateXML method. """
        ret = libvirtmod.virStoragePoolGetXMLDesc(self._o, flags)
        if ret is None: raise libvirtError ('virStoragePoolGetXMLDesc() failed', pool=self)
        return ret

    def build(self, flags):
        """Build the underlying storage pool """
        ret = libvirtmod.virStoragePoolBuild(self._o, flags)
        if ret == -1: raise libvirtError ('virStoragePoolBuild() failed', pool=self)
        return ret

    def connect(self):
        """Provides the connection pointer associated with a storage
          pool.  The reference counter on the connection is not
          increased by this call.  WARNING: When writing libvirt
          bindings in other languages, do not use this function. 
           Instead, store the connection and the pool object together. """
        ret = libvirtmod.virStoragePoolGetConnect(self._o)
        if ret is None:raise libvirtError('virStoragePoolGetConnect() failed', pool=self)
        __tmp = virConnect(_obj=ret)
        return __tmp

    def create(self, flags):
        """Starts an inactive storage pool """
        ret = libvirtmod.virStoragePoolCreate(self._o, flags)
        if ret == -1: raise libvirtError ('virStoragePoolCreate() failed', pool=self)
        return ret

    def createXML(self, xmldesc, flags):
        """Create a storage volume within a pool based on an XML
           description. Not all pools support creation of volumes """
        ret = libvirtmod.virStorageVolCreateXML(self._o, xmldesc, flags)
        if ret is None:raise libvirtError('virStorageVolCreateXML() failed', pool=self)
        __tmp = virStorageVol(self, _obj=ret)
        return __tmp

    def createXMLFrom(self, xmldesc, clonevol, flags):
        """Create a storage volume in the parent pool, using the
          'clonevol' volume as input. Information for the new volume
          (name, perms)  are passed via a typical volume XML
           description. """
        if clonevol is None: clonevol__o = None
        else: clonevol__o = clonevol._o
        ret = libvirtmod.virStorageVolCreateXMLFrom(self._o, xmldesc, clonevol__o, flags)
        if ret is None:raise libvirtError('virStorageVolCreateXMLFrom() failed', pool=self)
        __tmp = virStorageVol(self, _obj=ret)
        return __tmp

    def delete(self, flags):
        """Delete the underlying pool resources. This is a
          non-recoverable operation. The virStoragePoolPtr object
           itself is not free'd. """
        ret = libvirtmod.virStoragePoolDelete(self._o, flags)
        if ret == -1: raise libvirtError ('virStoragePoolDelete() failed', pool=self)
        return ret

    def destroy(self):
        """Destroy an active storage pool. This will deactivate the
          pool on the host, but keep any persistent config associated
          with it. If it has a persistent config it can later be
          restarted with virStoragePoolCreate(). This does not free
           the associated virStoragePoolPtr object. """
        ret = libvirtmod.virStoragePoolDestroy(self._o)
        if ret == -1: raise libvirtError ('virStoragePoolDestroy() failed', pool=self)
        return ret

    def name(self):
        """Fetch the locally unique name of the storage pool """
        ret = libvirtmod.virStoragePoolGetName(self._o)
        return ret

    def numOfVolumes(self):
        """Fetch the number of storage volumes within a pool """
        ret = libvirtmod.virStoragePoolNumOfVolumes(self._o)
        if ret == -1: raise libvirtError ('virStoragePoolNumOfVolumes() failed', pool=self)
        return ret

    def ref(self):
        """Increment the reference count on the pool. For each
          additional call to this method, there shall be a
          corresponding call to virStoragePoolFree to release the
          reference count, once the caller no longer needs the
          reference to this object.  This method is typically useful
          for applications where multiple threads are using a
          connection, and it is required that the connection remain
          open until all threads have finished using it. ie, each new
           thread using a pool would increment the reference count. """
        ret = libvirtmod.virStoragePoolRef(self._o)
        if ret == -1: raise libvirtError ('virStoragePoolRef() failed', pool=self)
        return ret

    def refresh(self, flags):
        """Request that the pool refresh its list of volumes. This may
          involve communicating with a remote server, and/or
           initializing new devices at the OS layer """
        ret = libvirtmod.virStoragePoolRefresh(self._o, flags)
        if ret == -1: raise libvirtError ('virStoragePoolRefresh() failed', pool=self)
        return ret

    def setAutostart(self, autostart):
        """Sets the autostart flag """
        ret = libvirtmod.virStoragePoolSetAutostart(self._o, autostart)
        if ret == -1: raise libvirtError ('virStoragePoolSetAutostart() failed', pool=self)
        return ret

    def storageVolLookupByName(self, name):
        """Fetch a pointer to a storage volume based on its name
           within a pool """
        ret = libvirtmod.virStorageVolLookupByName(self._o, name)
        if ret is None:raise libvirtError('virStorageVolLookupByName() failed', pool=self)
        __tmp = virStorageVol(self, _obj=ret)
        return __tmp

    def undefine(self):
        """Undefine an inactive storage pool """
        ret = libvirtmod.virStoragePoolUndefine(self._o)
        if ret == -1: raise libvirtError ('virStoragePoolUndefine() failed', pool=self)
        return ret

    #
    # virStoragePool functions from module python
    #

    def UUID(self):
        """Extract the UUID unique Identifier of a storage pool. """
        ret = libvirtmod.virStoragePoolGetUUID(self._o)
        if ret is None: raise libvirtError ('virStoragePoolGetUUID() failed', pool=self)
        return ret

    def UUIDString(self):
        """Fetch globally unique ID of the storage pool as a string. """
        ret = libvirtmod.virStoragePoolGetUUIDString(self._o)
        if ret is None: raise libvirtError ('virStoragePoolGetUUIDString() failed', pool=self)
        return ret

    def autostart(self):
        """Extract the autostart flag for a storage pool """
        ret = libvirtmod.virStoragePoolGetAutostart(self._o)
        if ret == -1: raise libvirtError ('virStoragePoolGetAutostart() failed', pool=self)
        return ret

    def info(self):
        """Extract information about a storage pool. Note that if the
          connection used to get the domain is limited only a partial
           set of the information can be extracted. """
        ret = libvirtmod.virStoragePoolGetInfo(self._o)
        if ret is None: raise libvirtError ('virStoragePoolGetInfo() failed', pool=self)
        return ret

    def listVolumes(self):
        """list the storage volumes, stores the pointers to the names
           in @names """
        ret = libvirtmod.virStoragePoolListVolumes(self._o)
        if ret is None: raise libvirtError ('virStoragePoolListVolumes() failed', pool=self)
        return ret

class virStorageVol:
    def __init__(self, conn, _obj=None):
        self._conn = conn
        if not isinstance(conn, virConnect):
            self._conn = conn._conn
        if _obj != None:self._o = _obj;return
        self._o = None

    def __del__(self):
        if self._o != None:
            libvirtmod.virStorageVolFree(self._o)
        self._o = None

    #
    # virStorageVol functions from module libvirt
    #

    def XMLDesc(self, flags):
        """Fetch an XML document describing all aspects of the storage
           volume """
        ret = libvirtmod.virStorageVolGetXMLDesc(self._o, flags)
        if ret is None: raise libvirtError ('virStorageVolGetXMLDesc() failed', vol=self)
        return ret

    def connect(self):
        """Provides the connection pointer associated with a storage
          volume.  The reference counter on the connection is not
          increased by this call.  WARNING: When writing libvirt
          bindings in other languages, do not use this function. 
          Instead, store the connection and the volume object
           together. """
        ret = libvirtmod.virStorageVolGetConnect(self._o)
        if ret is None:raise libvirtError('virStorageVolGetConnect() failed', vol=self)
        __tmp = virConnect(_obj=ret)
        return __tmp

    def delete(self, flags):
        """Delete the storage volume from the pool """
        ret = libvirtmod.virStorageVolDelete(self._o, flags)
        if ret == -1: raise libvirtError ('virStorageVolDelete() failed', vol=self)
        return ret

    def key(self):
        """Fetch the storage volume key. This is globally unique, so
          the same volume will have the same key no matter what host
           it is accessed from """
        ret = libvirtmod.virStorageVolGetKey(self._o)
        if ret is None: raise libvirtError ('virStorageVolGetKey() failed', vol=self)
        return ret

    def name(self):
        """Fetch the storage volume name. This is unique within the
           scope of a pool """
        ret = libvirtmod.virStorageVolGetName(self._o)
        return ret

    def path(self):
        """Fetch the storage volume path. Depending on the pool
          configuration this is either persistent across hosts, or
          dynamically assigned at pool startup. Consult pool
          documentation for information on getting the persistent
           naming """
        ret = libvirtmod.virStorageVolGetPath(self._o)
        if ret is None: raise libvirtError ('virStorageVolGetPath() failed', vol=self)
        return ret

    def ref(self):
        """Increment the reference count on the vol. For each
          additional call to this method, there shall be a
          corresponding call to virStorageVolFree to release the
          reference count, once the caller no longer needs the
          reference to this object.  This method is typically useful
          for applications where multiple threads are using a
          connection, and it is required that the connection remain
          open until all threads have finished using it. ie, each new
           thread using a vol would increment the reference count. """
        ret = libvirtmod.virStorageVolRef(self._o)
        if ret == -1: raise libvirtError ('virStorageVolRef() failed', vol=self)
        return ret

    def storagePoolLookupByVolume(self):
        """Fetch a storage pool which contains a particular volume """
        ret = libvirtmod.virStoragePoolLookupByVolume(self._o)
        if ret is None:raise libvirtError('virStoragePoolLookupByVolume() failed', vol=self)
        __tmp = virStoragePool(self, _obj=ret)
        return __tmp

    #
    # virStorageVol functions from module python
    #

    def info(self):
        """Extract information about a storage pool. Note that if the
          connection used to get the domain is limited only a partial
           set of the information can be extracted. """
        ret = libvirtmod.virStorageVolGetInfo(self._o)
        if ret is None: raise libvirtError ('virStorageVolGetInfo() failed', vol=self)
        return ret

class virConnect:
    def __init__(self, _obj=None):
        if _obj != None:self._o = _obj;return
        self._o = None

    #
    # virConnect functions from module libvirt
    #

    def close(self):
        """This function closes the connection to the Hypervisor. This
          should not be called if further interaction with the
          Hypervisor are needed especially if there is running domain
           which need further monitoring by the application. """
        ret = libvirtmod.virConnectClose(self._o)
        self._o = None
        if ret == -1: raise libvirtError ('virConnectClose() failed', conn=self)
        return ret

    def createLinux(self, xmlDesc, flags):
        """Deprecated after 0.4.6. Renamed to virDomainCreateXML()
          providing identical functionality. This existing name will
           left indefinitely for API compatability. """
        ret = libvirtmod.virDomainCreateLinux(self._o, xmlDesc, flags)
        if ret is None:raise libvirtError('virDomainCreateLinux() failed', conn=self)
        __tmp = virDomain(self,_obj=ret)
        return __tmp

    def createXML(self, xmlDesc, flags):
        """Create a new device on the VM host machine, for example,
           virtual HBAs created using vport_create. """
        ret = libvirtmod.virNodeDeviceCreateXML(self._o, xmlDesc, flags)
        if ret is None:raise libvirtError('virNodeDeviceCreateXML() failed', conn=self)
        __tmp = virNodeDevice(self, _obj=ret)
        return __tmp

    def createXML(self, xmlDesc, flags):
        """Launch a new guest domain, based on an XML description
          similar to the one returned by virDomainGetXMLDesc() This
          function may requires privileged access to the hypervisor.
          The domain is not persistent, so its definition will
          disappear when it is destroyed, or if the host is restarted
           (see virDomainDefineXML() to define persistent domains). """
        ret = libvirtmod.virDomainCreateXML(self._o, xmlDesc, flags)
        if ret is None:raise libvirtError('virDomainCreateXML() failed', conn=self)
        __tmp = virDomain(self,_obj=ret)
        return __tmp

    def defineXML(self, xml):
        """Define a domain, but does not start it. This definition is
          persistent, until explicitly undefined with
          virDomainUndefine(). A previous definition for this domain
           would be overriden if it already exists. """
        ret = libvirtmod.virDomainDefineXML(self._o, xml)
        if ret is None:raise libvirtError('virDomainDefineXML() failed', conn=self)
        __tmp = virDomain(self,_obj=ret)
        return __tmp

    def domainXMLFromNative(self, nativeFormat, nativeConfig, flags):
        """Reads native configuration data  describing a domain, and
          generates libvirt domain XML. The format of the native data
           is hypervisor dependant. """
        ret = libvirtmod.virConnectDomainXMLFromNative(self._o, nativeFormat, nativeConfig, flags)
        if ret is None: raise libvirtError ('virConnectDomainXMLFromNative() failed', conn=self)
        return ret

    def domainXMLToNative(self, nativeFormat, domainXml, flags):
        """Reads a domain XML configuration document, and generates
          generates a native configuration file describing the
          domain. The format of the native data is hypervisor
           dependant. """
        ret = libvirtmod.virConnectDomainXMLToNative(self._o, nativeFormat, domainXml, flags)
        if ret is None: raise libvirtError ('virConnectDomainXMLToNative() failed', conn=self)
        return ret

    def findStoragePoolSources(self, type, srcSpec, flags):
        """Talks to a storage backend and attempts to auto-discover
          the set of available storage pool sources. e.g. For iSCSI
          this would be a set of iSCSI targets. For NFS this would be
          a list of exported paths.  The srcSpec (optional for some
          storage pool types, e.g. local ones) is an instance of the
          storage pool's source element specifying where to look for
          the pools.  srcSpec is not required for some types (e.g.,
           those querying local storage resources only) """
        ret = libvirtmod.virConnectFindStoragePoolSources(self._o, type, srcSpec, flags)
        if ret is None: raise libvirtError ('virConnectFindStoragePoolSources() failed', conn=self)
        return ret

    def getCapabilities(self):
        """Provides capabilities of the hypervisor / driver. """
        ret = libvirtmod.virConnectGetCapabilities(self._o)
        if ret is None: raise libvirtError ('virConnectGetCapabilities() failed', conn=self)
        return ret

    def getFreeMemory(self):
        """provides the free memory available on the Node Note: most
          libvirt APIs provide memory sizes in kilobytes, but in this
          function the returned value is in bytes. Divide by 1024 as
           necessary. """
        ret = libvirtmod.virNodeGetFreeMemory(self._o)
        return ret

    def getHostname(self):
        """This returns the system hostname on which the hypervisor is
          running (the result of the gethostname(2) system call).  If
          we are connected to a remote system, then this returns the
           hostname of the remote system. """
        ret = libvirtmod.virConnectGetHostname(self._o)
        if ret is None: raise libvirtError ('virConnectGetHostname() failed', conn=self)
        return ret

    def getMaxVcpus(self, type):
        """Provides the maximum number of virtual CPUs supported for a
          guest VM of a specific type. The 'type' parameter here
          corresponds to the 'type' attribute in the <domain> element
           of the XML. """
        ret = libvirtmod.virConnectGetMaxVcpus(self._o, type)
        if ret == -1: raise libvirtError ('virConnectGetMaxVcpus() failed', conn=self)
        return ret

    def getType(self):
        """Get the name of the Hypervisor software used. """
        ret = libvirtmod.virConnectGetType(self._o)
        if ret is None: raise libvirtError ('virConnectGetType() failed', conn=self)
        return ret

    def getURI(self):
        """This returns the URI (name) of the hypervisor connection.
          Normally this is the same as or similar to the string
          passed to the virConnectOpen/virConnectOpenReadOnly call,
          but the driver may make the URI canonical.  If name == None
          was passed to virConnectOpen, then the driver will return a
          non-None URI which can be used to connect to the same
           hypervisor later. """
        ret = libvirtmod.virConnectGetURI(self._o)
        if ret is None: raise libvirtError ('virConnectGetURI() failed', conn=self)
        return ret

    def interfaceDefineXML(self, xml, flags):
        """Define an interface (or modify existing interface
           configuration) """
        ret = libvirtmod.virInterfaceDefineXML(self._o, xml, flags)
        if ret is None:raise libvirtError('virInterfaceDefineXML() failed', conn=self)
        __tmp = virInterface(self, _obj=ret)
        return __tmp

    def interfaceLookupByMACString(self, macstr):
        """Try to lookup an interface on the given hypervisor based on
           its MAC. """
        ret = libvirtmod.virInterfaceLookupByMACString(self._o, macstr)
        if ret is None:raise libvirtError('virInterfaceLookupByMACString() failed', conn=self)
        __tmp = virInterface(self, _obj=ret)
        return __tmp

    def interfaceLookupByName(self, name):
        """Try to lookup an interface on the given hypervisor based on
           its name. """
        ret = libvirtmod.virInterfaceLookupByName(self._o, name)
        if ret is None:raise libvirtError('virInterfaceLookupByName() failed', conn=self)
        __tmp = virInterface(self, _obj=ret)
        return __tmp

    def listDefinedInterfaces(self, names, maxnames):
        """Collect the list of defined (inactive) physical host
           interfaces, and store their names in @names. """
        ret = libvirtmod.virConnectListDefinedInterfaces(self._o, names, maxnames)
        if ret == -1: raise libvirtError ('virConnectListDefinedInterfaces() failed', conn=self)
        return ret

    def listInterfaces(self, names, maxnames):
        """Collect the list of active physical host interfaces, and
           store their names in @names """
        ret = libvirtmod.virConnectListInterfaces(self._o, names, maxnames)
        if ret == -1: raise libvirtError ('virConnectListInterfaces() failed', conn=self)
        return ret

    def lookupByID(self, id):
        """Try to find a domain based on the hypervisor ID number Note
          that this won't work for inactive domains which have an ID
          of -1, in that case a lookup based on the Name or UUId need
           to be done instead. """
        ret = libvirtmod.virDomainLookupByID(self._o, id)
        if ret is None:raise libvirtError('virDomainLookupByID() failed', conn=self)
        __tmp = virDomain(self,_obj=ret)
        return __tmp

    def lookupByName(self, name):
        """Try to lookup a domain on the given hypervisor based on its
           name. """
        ret = libvirtmod.virDomainLookupByName(self._o, name)
        if ret is None:raise libvirtError('virDomainLookupByName() failed', conn=self)
        __tmp = virDomain(self,_obj=ret)
        return __tmp

    def lookupByUUIDString(self, uuidstr):
        """Try to lookup a domain on the given hypervisor based on its
           UUID. """
        ret = libvirtmod.virDomainLookupByUUIDString(self._o, uuidstr)
        if ret is None:raise libvirtError('virDomainLookupByUUIDString() failed', conn=self)
        __tmp = virDomain(self,_obj=ret)
        return __tmp

    def migrate(self, domain, flags, dname, uri, bandwidth):
        """Migrate the domain object from its current host to the
          destination host given by dconn (a connection to the
          destination host).  Flags may be one of more of the
          following: VIR_MIGRATE_LIVE   Attempt a live migration.  If
          a hypervisor supports renaming domains during migration,
          then you may set the dname parameter to the new name
          (otherwise it keeps the same name).  If this is not
          supported by the hypervisor, dname must be None or else you
          will get an error.  Since typically the two hypervisors
          connect directly to each other in order to perform the
          migration, you may need to specify a path from the source
          to the destination.  This is the purpose of the uri
          parameter.  If uri is None, then libvirt will try to find
          the best method.  Uri may specify the hostname or IP
          address of the destination host as seen from the source. 
          Or uri may be a URI giving transport, hostname, user, port,
          etc. in the usual form.  Refer to driver documentation for
          the particular URIs supported.  The maximum bandwidth (in
          Mbps) that will be used to do migration can be specified
          with the bandwidth parameter.  If set to 0, libvirt will
          choose a suitable default.  Some hypervisors do not support
          this feature and will return an error if bandwidth is not
          0.  To see which features are supported by the current
          hypervisor, see virConnectGetCapabilities,
          /capabilities/host/migration_features.  There are many
          limitations on migration imposed by the underlying
          technology - for example it may not be possible to migrate
          between different processors even with the same
           architecture, or between different types of hypervisor. """
        if domain is None: domain__o = None
        else: domain__o = domain._o
        ret = libvirtmod.virDomainMigrate(domain__o, self._o, flags, dname, uri, bandwidth)
        if ret is None:raise libvirtError('virDomainMigrate() failed', conn=self)
        __tmp = virDomain(self,_obj=ret)
        return __tmp

    def networkCreateXML(self, xmlDesc):
        """Create and start a new virtual network, based on an XML
          description similar to the one returned by
           virNetworkGetXMLDesc() """
        ret = libvirtmod.virNetworkCreateXML(self._o, xmlDesc)
        if ret is None:raise libvirtError('virNetworkCreateXML() failed', conn=self)
        __tmp = virNetwork(self, _obj=ret)
        return __tmp

    def networkDefineXML(self, xml):
        """Define a network, but does not create it """
        ret = libvirtmod.virNetworkDefineXML(self._o, xml)
        if ret is None:raise libvirtError('virNetworkDefineXML() failed', conn=self)
        __tmp = virNetwork(self, _obj=ret)
        return __tmp

    def networkLookupByName(self, name):
        """Try to lookup a network on the given hypervisor based on
           its name. """
        ret = libvirtmod.virNetworkLookupByName(self._o, name)
        if ret is None:raise libvirtError('virNetworkLookupByName() failed', conn=self)
        __tmp = virNetwork(self, _obj=ret)
        return __tmp

    def networkLookupByUUIDString(self, uuidstr):
        """Try to lookup a network on the given hypervisor based on
           its UUID. """
        ret = libvirtmod.virNetworkLookupByUUIDString(self._o, uuidstr)
        if ret is None:raise libvirtError('virNetworkLookupByUUIDString() failed', conn=self)
        __tmp = virNetwork(self, _obj=ret)
        return __tmp

    def nodeDeviceLookupByName(self, name):
        """Lookup a node device by its name. """
        ret = libvirtmod.virNodeDeviceLookupByName(self._o, name)
        if ret is None:raise libvirtError('virNodeDeviceLookupByName() failed', conn=self)
        __tmp = virNodeDevice(self, _obj=ret)
        return __tmp

    def numOfDefinedDomains(self):
        """Provides the number of defined but inactive domains. """
        ret = libvirtmod.virConnectNumOfDefinedDomains(self._o)
        if ret == -1: raise libvirtError ('virConnectNumOfDefinedDomains() failed', conn=self)
        return ret

    def numOfDefinedInterfaces(self):
        """Provides the number of defined (inactive) interfaces on the
           physical host. """
        ret = libvirtmod.virConnectNumOfDefinedInterfaces(self._o)
        if ret == -1: raise libvirtError ('virConnectNumOfDefinedInterfaces() failed', conn=self)
        return ret

    def numOfDefinedNetworks(self):
        """Provides the number of inactive networks. """
        ret = libvirtmod.virConnectNumOfDefinedNetworks(self._o)
        if ret == -1: raise libvirtError ('virConnectNumOfDefinedNetworks() failed', conn=self)
        return ret

    def numOfDefinedStoragePools(self):
        """Provides the number of inactive storage pools """
        ret = libvirtmod.virConnectNumOfDefinedStoragePools(self._o)
        if ret == -1: raise libvirtError ('virConnectNumOfDefinedStoragePools() failed', conn=self)
        return ret

    def numOfDevices(self, cap, flags):
        """Provides the number of node devices.  If the optional 'cap'
          argument is non-None, then the count will be restricted to
           devices with the specified capability """
        ret = libvirtmod.virNodeNumOfDevices(self._o, cap, flags)
        if ret == -1: raise libvirtError ('virNodeNumOfDevices() failed', conn=self)
        return ret

    def numOfDomains(self):
        """Provides the number of active domains. """
        ret = libvirtmod.virConnectNumOfDomains(self._o)
        if ret == -1: raise libvirtError ('virConnectNumOfDomains() failed', conn=self)
        return ret

    def numOfInterfaces(self):
        """Provides the number of active interfaces on the physical
           host. """
        ret = libvirtmod.virConnectNumOfInterfaces(self._o)
        if ret == -1: raise libvirtError ('virConnectNumOfInterfaces() failed', conn=self)
        return ret

    def numOfNetworks(self):
        """Provides the number of active networks. """
        ret = libvirtmod.virConnectNumOfNetworks(self._o)
        if ret == -1: raise libvirtError ('virConnectNumOfNetworks() failed', conn=self)
        return ret

    def numOfStoragePools(self):
        """Provides the number of active storage pools """
        ret = libvirtmod.virConnectNumOfStoragePools(self._o)
        if ret == -1: raise libvirtError ('virConnectNumOfStoragePools() failed', conn=self)
        return ret

    def ref(self):
        """Increment the reference count on the connection. For each
          additional call to this method, there shall be a
          corresponding call to virConnectClose to release the
          reference count, once the caller no longer needs the
          reference to this object.  This method is typically useful
          for applications where multiple threads are using a
          connection, and it is required that the connection remain
          open until all threads have finished using it. ie, each new
          thread using a connection would increment the reference
           count. """
        ret = libvirtmod.virConnectRef(self._o)
        if ret == -1: raise libvirtError ('virConnectRef() failed', conn=self)
        return ret

    def restore(self, frm):
        """This method will restore a domain saved to disk by
           virDomainSave(). """
        ret = libvirtmod.virDomainRestore(self._o, frm)
        if ret == -1: raise libvirtError ('virDomainRestore() failed', conn=self)
        return ret

    def storagePoolCreateXML(self, xmlDesc, flags):
        """Create a new storage based on its XML description. The pool
          is not persistent, so its definition will disappear when it
           is destroyed, or if the host is restarted """
        ret = libvirtmod.virStoragePoolCreateXML(self._o, xmlDesc, flags)
        if ret is None:raise libvirtError('virStoragePoolCreateXML() failed', conn=self)
        __tmp = virStoragePool(self, _obj=ret)
        return __tmp

    def storagePoolDefineXML(self, xml, flags):
        """Define a new inactive storage pool based on its XML
          description. The pool is persistent, until explicitly
           undefined. """
        ret = libvirtmod.virStoragePoolDefineXML(self._o, xml, flags)
        if ret is None:raise libvirtError('virStoragePoolDefineXML() failed', conn=self)
        __tmp = virStoragePool(self, _obj=ret)
        return __tmp

    def storagePoolLookupByName(self, name):
        """Fetch a storage pool based on its unique name """
        ret = libvirtmod.virStoragePoolLookupByName(self._o, name)
        if ret is None:raise libvirtError('virStoragePoolLookupByName() failed', conn=self)
        __tmp = virStoragePool(self, _obj=ret)
        return __tmp

    def storagePoolLookupByUUID(self, uuid):
        """Fetch a storage pool based on its globally unique id """
        ret = libvirtmod.virStoragePoolLookupByUUID(self._o, uuid)
        if ret is None:raise libvirtError('virStoragePoolLookupByUUID() failed', conn=self)
        __tmp = virStoragePool(self, _obj=ret)
        return __tmp

    def storagePoolLookupByUUIDString(self, uuidstr):
        """Fetch a storage pool based on its globally unique id """
        ret = libvirtmod.virStoragePoolLookupByUUIDString(self._o, uuidstr)
        if ret is None:raise libvirtError('virStoragePoolLookupByUUIDString() failed', conn=self)
        __tmp = virStoragePool(self, _obj=ret)
        return __tmp

    def storageVolLookupByKey(self, key):
        """Fetch a pointer to a storage volume based on its globally
           unique key """
        ret = libvirtmod.virStorageVolLookupByKey(self._o, key)
        if ret is None:raise libvirtError('virStorageVolLookupByKey() failed', conn=self)
        __tmp = virStorageVol(self, _obj=ret)
        return __tmp

    def storageVolLookupByPath(self, path):
        """Fetch a pointer to a storage volume based on its locally
           (host) unique path """
        ret = libvirtmod.virStorageVolLookupByPath(self._o, path)
        if ret is None:raise libvirtError('virStorageVolLookupByPath() failed', conn=self)
        __tmp = virStorageVol(self, _obj=ret)
        return __tmp

    #
    # virConnect functions from module python
    #

    def getCellsFreeMemory(self, startCell, maxCells):
        """Returns the available memory for a list of cells """
        ret = libvirtmod.virNodeGetCellsFreeMemory(self._o, startCell, maxCells)
        if ret is None: raise libvirtError ('virNodeGetCellsFreeMemory() failed', conn=self)
        return ret

    def getInfo(self):
        """Extract hardware information about the Node. """
        ret = libvirtmod.virNodeGetInfo(self._o)
        if ret is None: raise libvirtError ('virNodeGetInfo() failed', conn=self)
        return ret

    def listDefinedDomains(self):
        """list the defined domains, stores the pointers to the names
           in @names """
        ret = libvirtmod.virConnectListDefinedDomains(self._o)
        if ret is None: raise libvirtError ('virConnectListDefinedDomains() failed', conn=self)
        return ret

    def listDefinedNetworks(self):
        """list the defined networks, stores the pointers to the names
           in @names """
        ret = libvirtmod.virConnectListDefinedNetworks(self._o)
        if ret is None: raise libvirtError ('virConnectListDefinedNetworks() failed', conn=self)
        return ret

    def listDefinedStoragePools(self):
        """list the defined storage pool, stores the pointers to the
           names in @names """
        ret = libvirtmod.virConnectListDefinedStoragePools(self._o)
        if ret is None: raise libvirtError ('virConnectListDefinedStoragePools() failed', conn=self)
        return ret

    def listDevices(self, cap, flags):
        """list the node devices """
        ret = libvirtmod.virNodeListDevices(self._o, cap, flags)
        if ret is None: raise libvirtError ('virNodeListDevices() failed', conn=self)
        return ret

    def listDomainsID(self):
        """Returns the list of the ID of the domains on the hypervisor """
        ret = libvirtmod.virConnectListDomainsID(self._o)
        if ret is None: raise libvirtError ('virConnectListDomainsID() failed', conn=self)
        return ret

    def listNetworks(self):
        """list the networks, stores the pointers to the names in
           @names """
        ret = libvirtmod.virConnectListNetworks(self._o)
        if ret is None: raise libvirtError ('virConnectListNetworks() failed', conn=self)
        return ret

    def listStoragePools(self):
        """list the storage pools, stores the pointers to the names in
           @names """
        ret = libvirtmod.virConnectListStoragePools(self._o)
        if ret is None: raise libvirtError ('virConnectListStoragePools() failed', conn=self)
        return ret

    def lookupByUUID(self, uuid):
        """Try to lookup a domain on the given hypervisor based on its
           UUID. """
        ret = libvirtmod.virDomainLookupByUUID(self._o, uuid)
        if ret is None:raise libvirtError('virDomainLookupByUUID() failed', conn=self)
        __tmp = virDomain(self,_obj=ret)
        return __tmp

    #
    # virConnect functions from module virterror
    #

    def virConnGetLastError(self):
        """Provide a pointer to the last error caught on that
          connection  This method is not protected against access
          from multiple threads. In a multi-threaded application,
          always use the global virGetLastError() API which is backed
          by thread local storage.  If the connection object was
          discovered to be invalid by an API call, then the error
          will be reported against the global error object.  Since
          0.6.0, all errors reported in the per-connection object are
          also duplicated in the global error object. As such an
          application can always use virGetLastError(). This method
           remains for backwards compatability. """
        ret = libvirtmod.virConnGetLastError(self._o)
        return ret

    def virConnResetLastError(self):
        """The error object is kept in thread local storage, so
          separate threads can safely access this concurrently. 
           Reset the last error caught on that connection """
        libvirtmod.virConnResetLastError(self._o)

    #
    # virConnect methods from virConnect.py (hand coded)
    #
    def __del__(self):
        try:
           for cb,opaque in self.domainEventCallbacks.items():
               del self.domainEventCallbacks[cb]
           self.domainEventCallbacks = None
           libvirtmod.virConnectDomainEventDeregister(self._o, self)
        except AttributeError:
           pass

        if self._o != None:
            libvirtmod.virConnectClose(self._o)
        self._o = None

    def domainEventDeregister(self, cb):
        """Removes a Domain Event Callback. De-registering for a
           domain callback will disable delivery of this event type """
        try:
            del self.domainEventCallbacks[cb]
            if len(self.domainEventCallbacks) == 0:
                ret = libvirtmod.virConnectDomainEventDeregister(self._o, self)
                if ret == -1: raise libvirtError ('virConnectDomainEventDeregister() failed', conn=self)
        except AttributeError:
            pass

    def domainEventRegister(self, cb, opaque):
        """Adds a Domain Event Callback. Registering for a domain
           callback will enable delivery of the events """
        try:
            self.domainEventCallbacks[cb] = opaque
        except AttributeError:
            self.domainEventCallbacks = {cb:opaque}
            ret = libvirtmod.virConnectDomainEventRegister(self._o, self)
            if ret == -1: raise libvirtError ('virConnectDomainEventRegister() failed', conn=self)

    def dispatchDomainEventCallbacks(self, dom, event, detail):
        """Dispatches events to python user domain event callbacks
        """
        try:
            for cb,opaque in self.domainEventCallbacks.items():
                cb(self,dom,event,detail,opaque)
            return 0
        except AttributeError:
            pass
class virNodeDevice:
    def __init__(self, conn, _obj=None):
        self._conn = conn
        if _obj != None:self._o = _obj;return
        self._o = None

    def __del__(self):
        if self._o != None:
            libvirtmod.virNodeDeviceFree(self._o)
        self._o = None

    #
    # virNodeDevice functions from module libvirt
    #

    def XMLDesc(self, flags):
        """Fetch an XML document describing all aspects of the device. """
        ret = libvirtmod.virNodeDeviceGetXMLDesc(self._o, flags)
        if ret is None: raise libvirtError ('virNodeDeviceGetXMLDesc() failed')
        return ret

    def destroy(self):
        """Destroy the device object. The virtual device is removed
          from the host operating system. This function may require
           privileged access """
        ret = libvirtmod.virNodeDeviceDestroy(self._o)
        if ret == -1: raise libvirtError ('virNodeDeviceDestroy() failed')
        return ret

    def dettach(self):
        """Dettach the node device from the node itself so that it may
          be assigned to a guest domain.  Depending on the
          hypervisor, this may involve operations such as unbinding
          any device drivers from the device, binding the device to a
          dummy device driver and resetting the device.  If the
          device is currently in use by the node, this method may
          fail.  Once the device is not assigned to any guest, it may
          be re-attached to the node using the
           virNodeDeviceReattach() method. """
        ret = libvirtmod.virNodeDeviceDettach(self._o)
        if ret == -1: raise libvirtError ('virNodeDeviceDettach() failed')
        return ret

    def name(self):
        """Just return the device name """
        ret = libvirtmod.virNodeDeviceGetName(self._o)
        return ret

    def numOfCaps(self):
        """Accessor for the number of capabilities supported by the
           device. """
        ret = libvirtmod.virNodeDeviceNumOfCaps(self._o)
        if ret == -1: raise libvirtError ('virNodeDeviceNumOfCaps() failed')
        return ret

    def parent(self):
        """Accessor for the parent of the device """
        ret = libvirtmod.virNodeDeviceGetParent(self._o)
        return ret

    def reAttach(self):
        """Re-attach a previously dettached node device to the node so
          that it may be used by the node again.  Depending on the
          hypervisor, this may involve operations such as resetting
          the device, unbinding it from a dummy device driver and
          binding it to its appropriate driver.  If the device is
           currently in use by a guest, this method may fail. """
        ret = libvirtmod.virNodeDeviceReAttach(self._o)
        if ret == -1: raise libvirtError ('virNodeDeviceReAttach() failed')
        return ret

    def ref(self):
        """Increment the reference count on the dev. For each
          additional call to this method, there shall be a
          corresponding call to virNodeDeviceFree to release the
          reference count, once the caller no longer needs the
          reference to this object.  This method is typically useful
          for applications where multiple threads are using a
          connection, and it is required that the connection remain
          open until all threads have finished using it. ie, each new
           thread using a dev would increment the reference count. """
        ret = libvirtmod.virNodeDeviceRef(self._o)
        if ret == -1: raise libvirtError ('virNodeDeviceRef() failed')
        return ret

    def reset(self):
        """Reset a previously dettached node device to the node before
          or after assigning it to a guest.  The exact reset
          semantics depends on the hypervisor and device type but,
          for example, KVM will attempt to reset PCI devices with a
          Function Level Reset, Secondary Bus Reset or a Power
          Management D-State reset.  If the reset will affect other
           devices which are currently in use, this function may fail. """
        ret = libvirtmod.virNodeDeviceReset(self._o)
        if ret == -1: raise libvirtError ('virNodeDeviceReset() failed')
        return ret

    #
    # virNodeDevice functions from module python
    #

    def listCaps(self):
        """list the node device's capabilities """
        ret = libvirtmod.virNodeDeviceListCaps(self._o)
        if ret is None: raise libvirtError ('virNodeDeviceListCaps() failed')
        return ret

# virDomainMigrateFlags
VIR_MIGRATE_LIVE = 1

# virErrorLevel
VIR_ERR_NONE = 0
VIR_ERR_WARNING = 1
VIR_ERR_ERROR = 2

# virDomainEventResumedDetailType
VIR_DOMAIN_EVENT_RESUMED_UNPAUSED = 0
VIR_DOMAIN_EVENT_RESUMED_MIGRATED = 1

# virErrorDomain
VIR_FROM_NONE = 0
VIR_FROM_XEN = 1
VIR_FROM_XEND = 2
VIR_FROM_XENSTORE = 3
VIR_FROM_SEXPR = 4
VIR_FROM_XML = 5
VIR_FROM_DOM = 6
VIR_FROM_RPC = 7
VIR_FROM_PROXY = 8
VIR_FROM_CONF = 9
VIR_FROM_QEMU = 10
VIR_FROM_NET = 11
VIR_FROM_TEST = 12
VIR_FROM_REMOTE = 13
VIR_FROM_OPENVZ = 14
VIR_FROM_XENXM = 15
VIR_FROM_STATS_LINUX = 16
VIR_FROM_LXC = 17
VIR_FROM_STORAGE = 18
VIR_FROM_NETWORK = 19
VIR_FROM_DOMAIN = 20
VIR_FROM_UML = 21
VIR_FROM_NODEDEV = 22
VIR_FROM_XEN_INOTIFY = 23
VIR_FROM_SECURITY = 24
VIR_FROM_VBOX = 25
VIR_FROM_INTERFACE = 26
VIR_FROM_ONE = 27
VIR_FROM_ESX = 28
VIR_FROM_PHYP = 29

# virDomainEventStartedDetailType
VIR_DOMAIN_EVENT_STARTED_BOOTED = 0
VIR_DOMAIN_EVENT_STARTED_MIGRATED = 1
VIR_DOMAIN_EVENT_STARTED_RESTORED = 2

# virEventHandleType
VIR_EVENT_HANDLE_READABLE = 1
VIR_EVENT_HANDLE_WRITABLE = 2
VIR_EVENT_HANDLE_ERROR = 4
VIR_EVENT_HANDLE_HANGUP = 8

# virDomainEventType
VIR_DOMAIN_EVENT_DEFINED = 0
VIR_DOMAIN_EVENT_UNDEFINED = 1
VIR_DOMAIN_EVENT_STARTED = 2
VIR_DOMAIN_EVENT_SUSPENDED = 3
VIR_DOMAIN_EVENT_RESUMED = 4
VIR_DOMAIN_EVENT_STOPPED = 5

# virDomainState
VIR_DOMAIN_NOSTATE = 0
VIR_DOMAIN_RUNNING = 1
VIR_DOMAIN_BLOCKED = 2
VIR_DOMAIN_PAUSED = 3
VIR_DOMAIN_SHUTDOWN = 4
VIR_DOMAIN_SHUTOFF = 5
VIR_DOMAIN_CRASHED = 6

# virStoragePoolDeleteFlags
VIR_STORAGE_POOL_DELETE_NORMAL = 0
VIR_STORAGE_POOL_DELETE_ZEROED = 1

# virStoragePoolState
VIR_STORAGE_POOL_INACTIVE = 0
VIR_STORAGE_POOL_BUILDING = 1
VIR_STORAGE_POOL_RUNNING = 2
VIR_STORAGE_POOL_DEGRADED = 3

# virSchedParameterType
VIR_DOMAIN_SCHED_FIELD_INT = 1
VIR_DOMAIN_SCHED_FIELD_UINT = 2
VIR_DOMAIN_SCHED_FIELD_LLONG = 3
VIR_DOMAIN_SCHED_FIELD_ULLONG = 4
VIR_DOMAIN_SCHED_FIELD_DOUBLE = 5
VIR_DOMAIN_SCHED_FIELD_BOOLEAN = 6

# virConnectFlags
VIR_CONNECT_RO = 1

# virDomainEventDefinedDetailType
VIR_DOMAIN_EVENT_DEFINED_ADDED = 0
VIR_DOMAIN_EVENT_DEFINED_UPDATED = 1

# virErrorNumber
VIR_ERR_OK = 0
VIR_ERR_INTERNAL_ERROR = 1
VIR_ERR_NO_MEMORY = 2
VIR_ERR_NO_SUPPORT = 3
VIR_ERR_UNKNOWN_HOST = 4
VIR_ERR_NO_CONNECT = 5
VIR_ERR_INVALID_CONN = 6
VIR_ERR_INVALID_DOMAIN = 7
VIR_ERR_INVALID_ARG = 8
VIR_ERR_OPERATION_FAILED = 9
VIR_ERR_GET_FAILED = 10
VIR_ERR_POST_FAILED = 11
VIR_ERR_HTTP_ERROR = 12
VIR_ERR_SEXPR_SERIAL = 13
VIR_ERR_NO_XEN = 14
VIR_ERR_XEN_CALL = 15
VIR_ERR_OS_TYPE = 16
VIR_ERR_NO_KERNEL = 17
VIR_ERR_NO_ROOT = 18
VIR_ERR_NO_SOURCE = 19
VIR_ERR_NO_TARGET = 20
VIR_ERR_NO_NAME = 21
VIR_ERR_NO_OS = 22
VIR_ERR_NO_DEVICE = 23
VIR_ERR_NO_XENSTORE = 24
VIR_ERR_DRIVER_FULL = 25
VIR_ERR_CALL_FAILED = 26
VIR_ERR_XML_ERROR = 27
VIR_ERR_DOM_EXIST = 28
VIR_ERR_OPERATION_DENIED = 29
VIR_ERR_OPEN_FAILED = 30
VIR_ERR_READ_FAILED = 31
VIR_ERR_PARSE_FAILED = 32
VIR_ERR_CONF_SYNTAX = 33
VIR_ERR_WRITE_FAILED = 34
VIR_ERR_XML_DETAIL = 35
VIR_ERR_INVALID_NETWORK = 36
VIR_ERR_NETWORK_EXIST = 37
VIR_ERR_SYSTEM_ERROR = 38
VIR_ERR_RPC = 39
VIR_ERR_GNUTLS_ERROR = 40
VIR_WAR_NO_NETWORK = 41
VIR_ERR_NO_DOMAIN = 42
VIR_ERR_NO_NETWORK = 43
VIR_ERR_INVALID_MAC = 44
VIR_ERR_AUTH_FAILED = 45
VIR_ERR_INVALID_STORAGE_POOL = 46
VIR_ERR_INVALID_STORAGE_VOL = 47
VIR_WAR_NO_STORAGE = 48
VIR_ERR_NO_STORAGE_POOL = 49
VIR_ERR_NO_STORAGE_VOL = 50
VIR_WAR_NO_NODE = 51
VIR_ERR_INVALID_NODE_DEVICE = 52
VIR_ERR_NO_NODE_DEVICE = 53
VIR_ERR_NO_SECURITY_MODEL = 54
VIR_ERR_OPERATION_INVALID = 55
VIR_WAR_NO_INTERFACE = 56
VIR_ERR_NO_INTERFACE = 57
VIR_ERR_INVALID_INTERFACE = 58
VIR_ERR_MULTIPLE_INTERFACES = 59

# virDomainMemoryFlags
VIR_MEMORY_VIRTUAL = 1
VIR_MEMORY_PHYSICAL = 2

# virDomainEventStoppedDetailType
VIR_DOMAIN_EVENT_STOPPED_SHUTDOWN = 0
VIR_DOMAIN_EVENT_STOPPED_DESTROYED = 1
VIR_DOMAIN_EVENT_STOPPED_CRASHED = 2
VIR_DOMAIN_EVENT_STOPPED_MIGRATED = 3
VIR_DOMAIN_EVENT_STOPPED_SAVED = 4
VIR_DOMAIN_EVENT_STOPPED_FAILED = 5

# virVcpuState
VIR_VCPU_OFFLINE = 0
VIR_VCPU_RUNNING = 1
VIR_VCPU_BLOCKED = 2

# virStorageVolDeleteFlags
VIR_STORAGE_VOL_DELETE_NORMAL = 0
VIR_STORAGE_VOL_DELETE_ZEROED = 1

# virDomainEventSuspendedDetailType
VIR_DOMAIN_EVENT_SUSPENDED_PAUSED = 0
VIR_DOMAIN_EVENT_SUSPENDED_MIGRATED = 1

# virStoragePoolBuildFlags
VIR_STORAGE_POOL_BUILD_NEW = 0
VIR_STORAGE_POOL_BUILD_REPAIR = 1
VIR_STORAGE_POOL_BUILD_RESIZE = 2

# virDomainXMLFlags
VIR_DOMAIN_XML_SECURE = 1
VIR_DOMAIN_XML_INACTIVE = 2

# virStorageVolType
VIR_STORAGE_VOL_FILE = 0
VIR_STORAGE_VOL_BLOCK = 1

# virDomainEventUndefinedDetailType
VIR_DOMAIN_EVENT_UNDEFINED_REMOVED = 0

# virConnectCredentialType
VIR_CRED_USERNAME = 1
VIR_CRED_AUTHNAME = 2
VIR_CRED_LANGUAGE = 3
VIR_CRED_CNONCE = 4
VIR_CRED_PASSPHRASE = 5
VIR_CRED_ECHOPROMPT = 6
VIR_CRED_NOECHOPROMPT = 7
VIR_CRED_REALM = 8
VIR_CRED_EXTERNAL = 9

# virDomainCreateFlags
VIR_DOMAIN_NONE = 0

