/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.tests.utils.impl;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Set;
import org.powermock.core.IndicateReloadClass;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.core.classloader.annotations.PrepareOnlyThisForTest;
import org.powermock.tests.utils.impl.AbstractTestClassExtractor;

public class PrepareForTestExtractorImpl
extends AbstractTestClassExtractor {
    @Override
    protected String[] getClassesToModify(AnnotatedElement annotatedElement) {
        Class<?>[] classArray;
        boolean bl;
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        this.addTestCase(linkedHashSet, annotatedElement);
        PrepareForTest prepareForTest = annotatedElement.getAnnotation(PrepareForTest.class);
        PrepareOnlyThisForTest prepareOnlyThisForTest = annotatedElement.getAnnotation(PrepareOnlyThisForTest.class);
        boolean bl2 = prepareForTest != null;
        boolean bl3 = bl = prepareOnlyThisForTest != null;
        if (!bl2 && !bl) {
            return null;
        }
        if (bl2) {
            for (Class<?> clazz : classArray = prepareForTest.value()) {
                if (clazz.equals(IndicateReloadClass.class)) continue;
                this.addClassHierarchy(linkedHashSet, clazz);
            }
            this.addFullyQualifiedNames(linkedHashSet, prepareForTest);
        }
        if (bl) {
            for (Class<?> clazz : classArray = prepareOnlyThisForTest.value()) {
                if (clazz.equals(IndicateReloadClass.class)) continue;
                linkedHashSet.add(clazz.getName());
            }
            this.addFullyQualifiedNames(linkedHashSet, prepareOnlyThisForTest);
        }
        return linkedHashSet.toArray(new String[0]);
    }

    private void addTestCase(Set<String> set, AnnotatedElement annotatedElement) {
        Class<?> clazz = null;
        if (annotatedElement instanceof Class) {
            clazz = (Class<?>)annotatedElement;
        } else if (annotatedElement instanceof Method) {
            clazz = ((Method)annotatedElement).getDeclaringClass();
        }
        this.addClassHierarchy(set, clazz);
    }

    private void addFullyQualifiedNames(Set<String> set, PrepareForTest prepareForTest) {
        String[] stringArray = prepareForTest.fullyQualifiedNames();
        this.addFullyQualifiedNames(set, stringArray);
    }

    private void addFullyQualifiedNames(Set<String> set, PrepareOnlyThisForTest prepareOnlyThisForTest) {
        String[] stringArray = prepareOnlyThisForTest.fullyQualifiedNames();
        this.addFullyQualifiedNames(set, stringArray);
    }

    private void addFullyQualifiedNames(Set<String> set, String[] stringArray) {
        for (String string : stringArray) {
            if ("".equals(string)) continue;
            set.add(string);
        }
    }

    private void addClassHierarchy(Set<String> set, Class<?> clazz) {
        while (clazz != null && !clazz.equals(Object.class)) {
            this.addInnerClassesAndInterfaces(set, clazz);
            set.add(clazz.getName());
            clazz = clazz.getSuperclass();
        }
    }

    private void addInnerClassesAndInterfaces(Set<String> set, Class<?> clazz) {
        Class<?>[] classArray;
        for (Class<?> clazz2 : classArray = clazz.getDeclaredClasses()) {
            set.add(clazz2.getName());
        }
    }
}

