/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.core.classloader;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.powermock.core.WildcardMatcher;
import org.powermock.reflect.Whitebox;

public abstract class DeferSupportingClassLoader
extends ClassLoader {
    private Map<String, Class<?>> classes;
    String[] deferPackages;
    ClassLoader deferTo;

    public void addIgnorePackage(String ... stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            int n = this.deferPackages.length;
            String[] stringArray2 = new String[n + stringArray.length];
            System.arraycopy(this.deferPackages, 0, stringArray2, 0, n);
            System.arraycopy(stringArray, 0, stringArray2, n, stringArray.length);
            this.deferPackages = stringArray2;
        }
    }

    public DeferSupportingClassLoader(ClassLoader classLoader, String[] stringArray) {
        this.deferTo = classLoader == null ? ClassLoader.getSystemClassLoader() : classLoader;
        this.classes = new HashMap();
        this.deferPackages = stringArray;
    }

    @Override
    protected Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz = null;
        clazz = this.classes.get(string);
        if (clazz == null) {
            boolean bl2 = this.shouldDefer(this.deferPackages, string);
            clazz = bl2 ? this.deferTo.loadClass(string) : this.loadModifiedClass(string);
            if (bl) {
                this.resolveClass(clazz);
            }
        }
        this.classes.put(string, clazz);
        return clazz;
    }

    protected boolean shouldDefer(String[] stringArray, String string) {
        for (String string2 : stringArray) {
            if (!this.deferConditionMatches(string, string2)) continue;
            return true;
        }
        return false;
    }

    private boolean deferConditionMatches(String string, String string2) {
        boolean bl = WildcardMatcher.matches(string, string2);
        return bl && !this.shouldLoadUnmodifiedClass(string) && (!bl || !this.shouldModifyClass(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean shouldIgnore(Iterable<String> iterable, String string) {
        Iterable<String> iterable2 = iterable;
        synchronized (iterable2) {
            for (String string2 : iterable) {
                if (!WildcardMatcher.matches(string2, string)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean shouldIgnore(String[] stringArray, String string) {
        String[] stringArray2 = stringArray;
        synchronized (stringArray) {
            for (String string2 : stringArray) {
                if (!WildcardMatcher.matches(string, string2)) continue;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return false;
        }
    }

    @Override
    protected URL findResource(String string) {
        try {
            return (URL)Whitebox.invokeMethod((Object)this.deferTo, "findResource", string);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    protected Enumeration<URL> findResources(String string) throws IOException {
        try {
            return (Enumeration)Whitebox.invokeMethod((Object)this.deferTo, "findResources", string);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    protected boolean shouldModify(Iterable<String> iterable, String string) {
        return !this.shouldIgnore(iterable, string);
    }

    protected abstract Class<?> loadModifiedClass(String var1) throws ClassFormatError, ClassNotFoundException;

    protected abstract boolean shouldModifyClass(String var1);

    protected abstract boolean shouldLoadUnmodifiedClass(String var1);
}

