/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.classloading;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import org.powermock.api.support.ClassLoaderUtil;
import org.powermock.api.support.SafeExceptionRethrower;
import org.powermock.classloading.spi.DeepClonerSPI;
import org.powermock.classloading.spi.DoNotClone;
import org.powermock.reflect.Whitebox;

public class ClassloaderExecutor {
    @DoNotClone
    private final ClassLoader classloader;

    public ClassloaderExecutor(ClassLoader classLoader) {
        this.classloader = classLoader;
    }

    public <T> T execute(Callable<T> callable) {
        this.assertArgumentNotNull(callable, "callable");
        return (T)this.execute(callable, Whitebox.getMethod(callable.getClass(), "call", new Class[0]), new Object[0]);
    }

    public void execute(Runnable runnable) {
        this.assertArgumentNotNull(runnable, "runnable");
        this.execute(runnable, Whitebox.getMethod(runnable.getClass(), "run", new Class[0]), new Object[0]);
    }

    private void assertArgumentNotNull(Object object, String string) {
        if (object == null) {
            throw new IllegalArgumentException(string + " cannot be null.");
        }
    }

    private Object execute(Object object, Method method, Object ... objectArray) {
        DeepClonerSPI deepClonerSPI = this.createDeepCloner(this.classloader);
        Object object2 = deepClonerSPI.clone(object);
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            Object object3 = objectArray[i];
            objectArray2[i] = deepClonerSPI.clone(object3);
        }
        Object t = null;
        try {
            t = Whitebox.invokeMethod(object2, method.getName(), objectArray2);
        }
        catch (Exception exception) {
            SafeExceptionRethrower.safeRethrow(exception);
        }
        return t == null ? null : this.createDeepCloner(this.getClass().getClassLoader()).clone(t);
    }

    private DeepClonerSPI createDeepCloner(ClassLoader classLoader) {
        Class clazz = ClassLoaderUtil.loadClass("org.powermock.classloading.DeepCloner");
        Constructor constructor = Whitebox.getConstructor(clazz, ClassLoader.class);
        try {
            return (DeepClonerSPI)constructor.newInstance(classLoader);
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to instantiate DeepCloner. The DeepCloner implementation must have a one-arg constructor taking a Classloader as parameter.", exception);
        }
    }
}

