/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.support;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.powermock.core.MockRepository;
import org.powermock.reflect.Whitebox;
import org.powermock.reflect.exceptions.MethodNotFoundException;
import org.powermock.reflect.exceptions.TooManyMethodsFoundException;

public class MethodProxy {
    public static void proxy(Method method, InvocationHandler invocationHandler) {
        MethodProxy.assertInvocationHandlerNotNull(invocationHandler);
        MockRepository.putMethodProxy(method, invocationHandler);
    }

    public static void proxy(Class<?> clazz, String string, InvocationHandler invocationHandler) {
        MethodProxy.assertInvocationHandlerNotNull(invocationHandler);
        if (clazz == null) {
            throw new IllegalArgumentException("declaringClass cannot be null");
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("methodName cannot be empty");
        }
        Method[] methodArray = Whitebox.getMethods(clazz, string);
        if (methodArray.length == 0) {
            throw new MethodNotFoundException(String.format("Couldn't find a method with name %s in the class hierarchy of %s", string, clazz.getName()));
        }
        if (methodArray.length > 1) {
            throw new TooManyMethodsFoundException(String.format("Found %d methods with name %s in the class hierarchy of %s.", methodArray.length, string, clazz.getName()));
        }
        MockRepository.putMethodProxy(methodArray[0], invocationHandler);
    }

    private static void assertInvocationHandlerNotNull(InvocationHandler invocationHandler) {
        if (invocationHandler == null) {
            throw new IllegalArgumentException("invocationHandler cannot be null");
        }
    }
}

