/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.internal.verification;

import org.mockito.exceptions.base.MockitoAssertionError;
import org.powermock.api.mockito.internal.invocationcontrol.InvocationControlAssertionError;
import org.powermock.api.mockito.internal.invocationcontrol.MockitoNewInvocationControl;
import org.powermock.api.mockito.verification.ConstructorArgumentsVerification;
import org.powermock.core.spi.NewInvocationControl;

public class DefaultConstructorArgumentsVerfication<T>
implements ConstructorArgumentsVerification {
    private final MockitoNewInvocationControl<T> invocationControl;
    private final Class<?> type;

    public DefaultConstructorArgumentsVerfication(NewInvocationControl<T> newInvocationControl, Class<?> clazz) {
        this.type = clazz;
        this.invocationControl = (MockitoNewInvocationControl)newInvocationControl;
    }

    @Override
    public void withArguments(Object object, Object ... objectArray) throws Exception {
        Object[] objectArray2;
        if (object == null && objectArray.length == 0) {
            objectArray2 = null;
        } else {
            objectArray2 = new Object[objectArray.length + 1];
            objectArray2[0] = object;
            System.arraycopy(objectArray, 0, objectArray2, 1, objectArray.length);
        }
        this.invokeSubstitute(objectArray2);
    }

    private void invokeSubstitute(Object ... objectArray) throws Exception {
        try {
            this.invocationControl.getSubstitute().performSubstitutionLogic(objectArray);
        }
        catch (MockitoAssertionError mockitoAssertionError) {
            InvocationControlAssertionError.throwAssertionErrorForNewSubstitutionFailure((AssertionError)((Object)mockitoAssertionError), this.type);
        }
    }

    @Override
    public void withNoArguments() throws Exception {
        this.invokeSubstitute(new Object[0]);
    }
}

