/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.configuration;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;
import org.mockito.configuration.AnnotationEngine;
import org.mockito.exceptions.Reporter;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.util.MockUtil;
import org.mockito.internal.util.reflection.FieldInitializationReport;
import org.mockito.internal.util.reflection.FieldInitializer;

public class SpyAnnotationEngine
implements AnnotationEngine {
    @Override
    public Object createMockFor(Annotation annotation, Field field) {
        return null;
    }

    @Override
    public void process(Class<?> clazz, Object object) {
        Field[] fieldArray;
        for (Field field : fieldArray = clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Spy.class) || field.isAnnotationPresent(InjectMocks.class)) continue;
            this.assertNoIncompatibleAnnotations(Spy.class, field, Mock.class, MockitoAnnotations.Mock.class, Captor.class);
            Object object2 = null;
            try {
                FieldInitializationReport fieldInitializationReport = new FieldInitializer(object, field).initialize();
                object2 = fieldInitializationReport.fieldInstance();
            }
            catch (MockitoException mockitoException) {
                new Reporter().cannotInitializeForSpyAnnotation(field.getName(), mockitoException);
            }
            try {
                if (new MockUtil().isMock(object2)) {
                    Mockito.reset(object2);
                    continue;
                }
                field.setAccessible(true);
                field.set(object, Mockito.mock(object2.getClass(), Mockito.withSettings().spiedInstance(object2).defaultAnswer(Mockito.CALLS_REAL_METHODS).name(field.getName())));
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new MockitoException("Problems initiating spied field " + field.getName(), illegalAccessException);
            }
        }
    }

    void assertNoIncompatibleAnnotations(Class clazz, Field field, Class ... classArray) {
        for (Class clazz2 : classArray) {
            if (!field.isAnnotationPresent(clazz2)) continue;
            new Reporter().unsupportedCombinationOfAnnotations(clazz.getSimpleName(), clazz.getClass().getSimpleName());
        }
    }
}

