<?xml version="1.0"?>
<api version="1.0">
	<namespace name="Launcher">
		<function name="icon_utils_icon_name_for_volume_uri" symbol="launcher_icon_utils_icon_name_for_volume_uri">
			<return-type type="gchar*"/>
			<parameters>
				<parameter name="uri" type="gchar*"/>
			</parameters>
		</function>
		<struct name="LauncherCategory">
			<method name="add_application" symbol="launcher_category_add_application">
				<return-type type="void"/>
				<parameters>
					<parameter name="category" type="LauncherCategory*"/>
					<parameter name="application" type="LauncherApplication*"/>
				</parameters>
			</method>
			<method name="empty_applications" symbol="launcher_category_empty_applications">
				<return-type type="void"/>
				<parameters>
					<parameter name="category" type="LauncherCategory*"/>
				</parameters>
			</method>
			<method name="get_applications" symbol="launcher_category_get_applications">
				<return-type type="GSList*"/>
				<parameters>
					<parameter name="category" type="LauncherCategory*"/>
				</parameters>
			</method>
			<method name="get_comment" symbol="launcher_category_get_comment">
				<return-type type="gchar*"/>
				<parameters>
					<parameter name="category" type="LauncherCategory*"/>
				</parameters>
			</method>
			<method name="get_icon_name" symbol="launcher_category_get_icon_name">
				<return-type type="gchar*"/>
				<parameters>
					<parameter name="category" type="LauncherCategory*"/>
				</parameters>
			</method>
			<method name="get_name" symbol="launcher_category_get_name">
				<return-type type="gchar*"/>
				<parameters>
					<parameter name="category" type="LauncherCategory*"/>
				</parameters>
			</method>
			<method name="new" symbol="launcher_category_new">
				<return-type type="LauncherCategory*"/>
				<parameters>
					<parameter name="name" type="gchar*"/>
					<parameter name="comment" type="gchar*"/>
					<parameter name="icon_name" type="gchar*"/>
				</parameters>
			</method>
			<method name="remove_application" symbol="launcher_category_remove_application">
				<return-type type="void"/>
				<parameters>
					<parameter name="category" type="LauncherCategory*"/>
					<parameter name="application" type="LauncherApplication*"/>
				</parameters>
			</method>
			<method name="sort_applications" symbol="launcher_category_sort_applications">
				<return-type type="void"/>
				<parameters>
					<parameter name="category" type="LauncherCategory*"/>
					<parameter name="sort_func" type="GCompareFunc"/>
				</parameters>
			</method>
			<field name="parent_instance" type="GObject"/>
		</struct>
		<struct name="LauncherCategoryClass">
			<field name="parent_class" type="GObjectClass"/>
			<field name="removed" type="GCallback"/>
			<field name="application_added" type="GCallback"/>
			<field name="application_removed" type="GCallback"/>
		</struct>
		<struct name="LauncherSessionClass">
		</struct>
		<boxed name="LauncherFolder" type-name="LauncherFolder" get-type="launcher_folder_get_type">
			<method name="activate" symbol="launcher_folder_activate">
				<return-type type="void"/>
				<parameters>
					<parameter name="folder" type="LauncherFolder*"/>
					<parameter name="error" type="GError**"/>
				</parameters>
			</method>
			<method name="free" symbol="launcher_folder_free">
				<return-type type="void"/>
				<parameters>
					<parameter name="folder" type="LauncherFolder*"/>
				</parameters>
			</method>
			<method name="get_icon_name" symbol="launcher_folder_get_icon_name">
				<return-type type="gchar*"/>
				<parameters>
					<parameter name="folder" type="LauncherFolder*"/>
				</parameters>
			</method>
			<method name="get_name" symbol="launcher_folder_get_name">
				<return-type type="gchar*"/>
				<parameters>
					<parameter name="folder" type="LauncherFolder*"/>
				</parameters>
			</method>
			<method name="get_uri" symbol="launcher_folder_get_uri">
				<return-type type="gchar*"/>
				<parameters>
					<parameter name="folder" type="LauncherFolder*"/>
				</parameters>
			</method>
			<constructor name="new" symbol="launcher_folder_new">
				<return-type type="LauncherFolder*"/>
				<parameters>
					<parameter name="name" type="gchar*"/>
					<parameter name="uri" type="gchar*"/>
				</parameters>
			</constructor>
		</boxed>
		<enum name="LauncherFavoritesListValue">
			<member name="LAUNCHER_FAVORITES_STRING" value="0"/>
			<member name="LAUNCHER_FAVORITES_INT" value="1"/>
			<member name="LAUNCHER_FAVORITES_FLOAT" value="2"/>
			<member name="LAUNCHER_FAVORITES_BOOL" value="3"/>
		</enum>
		<object name="LauncherApplication" parent="GObject" type-name="LauncherApplication" get-type="launcher_application_get_type">
			<method name="add_wnckapp" symbol="launcher_application_add_wnckapp">
				<return-type type="void"/>
				<parameters>
					<parameter name="application" type="LauncherApplication*"/>
					<parameter name="wnck_app" type="WnckApplication*"/>
				</parameters>
			</method>
			<method name="get_categories" symbol="launcher_application_get_categories">
				<return-type type="GSList*"/>
				<parameters>
					<parameter name="application" type="LauncherApplication*"/>
				</parameters>
			</method>
			<method name="get_comment" symbol="launcher_application_get_comment">
				<return-type type="gchar*"/>
				<parameters>
					<parameter name="application" type="LauncherApplication*"/>
				</parameters>
			</method>
			<method name="get_desktop_file" symbol="launcher_application_get_desktop_file">
				<return-type type="gchar*"/>
				<parameters>
					<parameter name="application" type="LauncherApplication*"/>
				</parameters>
			</method>
			<method name="get_exec_string" symbol="launcher_application_get_exec_string">
				<return-type type="gchar*"/>
				<parameters>
					<parameter name="application" type="LauncherApplication*"/>
				</parameters>
			</method>
			<method name="get_favorite" symbol="launcher_application_get_favorite">
				<return-type type="gboolean"/>
				<parameters>
					<parameter name="application" type="LauncherApplication*"/>
				</parameters>
			</method>
			<method name="get_focused" symbol="launcher_application_get_focused">
				<return-type type="gboolean"/>
				<parameters>
					<parameter name="application" type="LauncherApplication*"/>
				</parameters>
			</method>
			<method name="get_icon_name" symbol="launcher_application_get_icon_name">
				<return-type type="gchar*"/>
				<parameters>
					<parameter name="application" type="LauncherApplication*"/>
				</parameters>
			</method>
			<method name="get_name" symbol="launcher_application_get_name">
				<return-type type="gchar*"/>
				<parameters>
					<parameter name="application" type="LauncherApplication*"/>
				</parameters>
			</method>
			<method name="get_running" symbol="launcher_application_get_running">
				<return-type type="gboolean"/>
				<parameters>
					<parameter name="application" type="LauncherApplication*"/>
				</parameters>
			</method>
			<method name="get_unique_string" symbol="launcher_application_get_unique_string">
				<return-type type="gchar*"/>
				<parameters>
					<parameter name="application" type="LauncherApplication*"/>
				</parameters>
			</method>
			<method name="get_wnckapps" symbol="launcher_application_get_wnckapps">
				<return-type type="GSList*"/>
				<parameters>
					<parameter name="application" type="LauncherApplication*"/>
				</parameters>
			</method>
			<method name="launch" symbol="launcher_application_launch">
				<return-type type="gboolean"/>
				<parameters>
					<parameter name="application" type="LauncherApplication*"/>
					<parameter name="error" type="GError**"/>
				</parameters>
			</method>
			<constructor name="new" symbol="launcher_application_new">
				<return-type type="LauncherApplication*"/>
			</constructor>
			<constructor name="new_from_desktop_file" symbol="launcher_application_new_from_desktop_file">
				<return-type type="LauncherApplication*"/>
				<parameters>
					<parameter name="desktop_file" type="gchar*"/>
				</parameters>
			</constructor>
			<constructor name="new_from_wnck_app" symbol="launcher_application_new_from_wnck_app">
				<return-type type="LauncherApplication*"/>
				<parameters>
					<parameter name="app" type="WnckApplication*"/>
				</parameters>
			</constructor>
			<method name="set_desktop_file" symbol="launcher_application_set_desktop_file">
				<return-type type="void"/>
				<parameters>
					<parameter name="application" type="LauncherApplication*"/>
					<parameter name="desktop_file" type="gchar*"/>
				</parameters>
			</method>
			<method name="show" symbol="launcher_application_show">
				<return-type type="void"/>
				<parameters>
					<parameter name="application" type="LauncherApplication*"/>
				</parameters>
			</method>
			<property name="categories" type="GSList*" readable="1" writable="0" construct="0" construct-only="0"/>
			<property name="comment" type="char*" readable="1" writable="0" construct="0" construct-only="0"/>
			<property name="desktop-file-path" type="char*" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="exec" type="char*" readable="1" writable="0" construct="0" construct-only="0"/>
			<property name="favorite" type="gboolean" readable="1" writable="0" construct="0" construct-only="0"/>
			<property name="focused" type="gboolean" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="icon-name" type="char*" readable="1" writable="0" construct="0" construct-only="0"/>
			<property name="name" type="char*" readable="1" writable="0" construct="0" construct-only="0"/>
			<property name="running" type="gboolean" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="unique-string" type="char*" readable="1" writable="0" construct="0" construct-only="0"/>
			<property name="wnckapps" type="GSList*" readable="1" writable="0" construct="0" construct-only="0"/>
			<signal name="closed" when="LAST">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="LauncherApplication*"/>
					<parameter name="wnckapp" type="WnckApplication*"/>
				</parameters>
			</signal>
			<signal name="opened" when="LAST">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="LauncherApplication*"/>
					<parameter name="wnckapp" type="WnckApplication*"/>
				</parameters>
			</signal>
		</object>
		<object name="LauncherAppman" parent="GObject" type-name="LauncherAppman" get-type="launcher_appman_get_type">
			<method name="get_application_for_desktop_file" symbol="launcher_appman_get_application_for_desktop_file">
				<return-type type="LauncherApplication*"/>
				<parameters>
					<parameter name="appman" type="LauncherAppman*"/>
					<parameter name="desktop" type="gchar*"/>
				</parameters>
			</method>
			<method name="get_application_for_wnck_app" symbol="launcher_appman_get_application_for_wnck_app">
				<return-type type="LauncherApplication*"/>
				<parameters>
					<parameter name="appman" type="LauncherAppman*"/>
					<parameter name="wnck_app" type="WnckApplication*"/>
				</parameters>
			</method>
			<method name="get_applications" symbol="launcher_appman_get_applications">
				<return-type type="GSequence*"/>
				<parameters>
					<parameter name="appman" type="LauncherAppman*"/>
				</parameters>
			</method>
			<method name="get_default" symbol="launcher_appman_get_default">
				<return-type type="LauncherAppman*"/>
			</method>
		</object>
		<object name="LauncherFavorites" parent="GObject" type-name="LauncherFavorites" get-type="launcher_favorites_get_type">
			<method name="add_favorite" symbol="launcher_favorites_add_favorite">
				<return-type type="gboolean"/>
				<parameters>
					<parameter name="self" type="LauncherFavorites*"/>
					<parameter name="uid" type="gchar*"/>
				</parameters>
			</method>
			<method name="get_bool" symbol="launcher_favorites_get_bool">
				<return-type type="gboolean"/>
				<parameters>
					<parameter name="self" type="LauncherFavorites*"/>
					<parameter name="uid" type="gchar*"/>
					<parameter name="key" type="gchar*"/>
				</parameters>
			</method>
			<method name="get_default" symbol="launcher_favorites_get_default">
				<return-type type="LauncherFavorites*"/>
			</method>
			<method name="get_favorites" symbol="launcher_favorites_get_favorites">
				<return-type type="GSList*"/>
				<parameters>
					<parameter name="self" type="LauncherFavorites*"/>
				</parameters>
			</method>
			<method name="get_float" symbol="launcher_favorites_get_float">
				<return-type type="gfloat"/>
				<parameters>
					<parameter name="self" type="LauncherFavorites*"/>
					<parameter name="uid" type="gchar*"/>
					<parameter name="key" type="gchar*"/>
				</parameters>
			</method>
			<method name="get_int" symbol="launcher_favorites_get_int">
				<return-type type="gint"/>
				<parameters>
					<parameter name="self" type="LauncherFavorites*"/>
					<parameter name="uid" type="gchar*"/>
					<parameter name="key" type="gchar*"/>
				</parameters>
			</method>
			<method name="get_list" symbol="launcher_favorites_get_list">
				<return-type type="GSList*"/>
				<parameters>
					<parameter name="self" type="LauncherFavorites*"/>
					<parameter name="uid" type="gchar*"/>
					<parameter name="key" type="gchar*"/>
					<parameter name="value_type" type="LauncherFavoritesListValue"/>
				</parameters>
			</method>
			<method name="get_string" symbol="launcher_favorites_get_string">
				<return-type type="gchar*"/>
				<parameters>
					<parameter name="self" type="LauncherFavorites*"/>
					<parameter name="uid" type="gchar*"/>
					<parameter name="key" type="gchar*"/>
				</parameters>
			</method>
			<method name="remove_favorite" symbol="launcher_favorites_remove_favorite">
				<return-type type="gboolean"/>
				<parameters>
					<parameter name="self" type="LauncherFavorites*"/>
					<parameter name="uid" type="gchar*"/>
				</parameters>
			</method>
			<method name="set_bool" symbol="launcher_favorites_set_bool">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="LauncherFavorites*"/>
					<parameter name="uid" type="gchar*"/>
					<parameter name="key" type="gchar*"/>
					<parameter name="value" type="gboolean"/>
				</parameters>
			</method>
			<method name="set_favorites" symbol="launcher_favorites_set_favorites">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="LauncherFavorites*"/>
					<parameter name="list" type="GSList*"/>
				</parameters>
			</method>
			<method name="set_float" symbol="launcher_favorites_set_float">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="LauncherFavorites*"/>
					<parameter name="uid" type="gchar*"/>
					<parameter name="key" type="gchar*"/>
					<parameter name="value" type="gfloat"/>
				</parameters>
			</method>
			<method name="set_int" symbol="launcher_favorites_set_int">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="LauncherFavorites*"/>
					<parameter name="uid" type="gchar*"/>
					<parameter name="key" type="gchar*"/>
					<parameter name="value" type="gint"/>
				</parameters>
			</method>
			<method name="set_list" symbol="launcher_favorites_set_list">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="LauncherFavorites*"/>
					<parameter name="uid" type="gchar*"/>
					<parameter name="key" type="gchar*"/>
					<parameter name="value_type" type="LauncherFavoritesListValue"/>
					<parameter name="value" type="GSList*"/>
				</parameters>
			</method>
			<method name="set_string" symbol="launcher_favorites_set_string">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="LauncherFavorites*"/>
					<parameter name="uid" type="gchar*"/>
					<parameter name="key" type="gchar*"/>
					<parameter name="value" type="gchar*"/>
				</parameters>
			</method>
		</object>
		<object name="LauncherFolderBookmarks" parent="GObject" type-name="LauncherFolderBookmarks" get-type="launcher_folder_bookmarks_get_type">
			<method name="get_bookmarks" symbol="launcher_folder_bookmarks_get_bookmarks">
				<return-type type="GSList*"/>
				<parameters>
					<parameter name="bookmarks" type="LauncherFolderBookmarks*"/>
				</parameters>
			</method>
			<method name="get_default" symbol="launcher_folder_bookmarks_get_default">
				<return-type type="LauncherFolderBookmarks*"/>
			</method>
			<signal name="bookmarks-changed" when="LAST">
				<return-type type="void"/>
				<parameters>
					<parameter name="folder_bookmarks" type="LauncherFolderBookmarks*"/>
				</parameters>
			</signal>
		</object>
		<object name="LauncherMenu" parent="GObject" type-name="LauncherMenu" get-type="launcher_menu_get_type">
			<method name="get_applications" symbol="launcher_menu_get_applications">
				<return-type type="GSList*"/>
				<parameters>
					<parameter name="menu" type="LauncherMenu*"/>
				</parameters>
			</method>
			<method name="get_categories" symbol="launcher_menu_get_categories">
				<return-type type="GSList*"/>
				<parameters>
					<parameter name="menu" type="LauncherMenu*"/>
				</parameters>
			</method>
			<method name="get_default" symbol="launcher_menu_get_default">
				<return-type type="LauncherMenu*"/>
			</method>
			<signal name="menu-changed" when="LAST">
				<return-type type="void"/>
				<parameters>
					<parameter name="menu" type="LauncherMenu*"/>
				</parameters>
			</signal>
		</object>
		<object name="LauncherSession" parent="GObject" type-name="LauncherSession" get-type="launcher_session_get_type">
			<method name="get_default" symbol="launcher_session_get_default">
				<return-type type="LauncherSession*"/>
			</method>
			<method name="get_running_applications" symbol="launcher_session_get_running_applications">
				<return-type type="GSList*"/>
				<parameters>
					<parameter name="session" type="LauncherSession*"/>
				</parameters>
			</method>
			<signal name="application-launching" when="LAST">
				<return-type type="void"/>
				<parameters>
					<parameter name="object" type="LauncherSession*"/>
					<parameter name="p0" type="LauncherApplication*"/>
				</parameters>
			</signal>
			<signal name="application-opened" when="LAST">
				<return-type type="void"/>
				<parameters>
					<parameter name="object" type="LauncherSession*"/>
					<parameter name="p0" type="LauncherApplication*"/>
				</parameters>
			</signal>
		</object>
	</namespace>
</api>
