/*
 * Qt wrapper for libindicate
 *
 * Copyright 2009 Canonical Ltd.
 *
 * Authors:
 * - Aurélien Gâteau <aurelien.gateau@canonical.com>
 *
 * License: LGPL v2.1 or LGPL v3
 */
#ifndef QINDICATEDECODE_H
#define QINDICATEDECODE_H

// Qt
#include <QDateTime>
#include <QImage>

// Local
#include <qindicate_export.h>

namespace QIndicate
{

/**
 * This namespace provides functions to decode the value of serialized properties
 */
namespace Decode
{

INDICATEQT_EXPORT QString stringFromValue(const QByteArray&);
INDICATEQT_EXPORT int intFromValue(const QByteArray&, int defaultValue=0);
INDICATEQT_EXPORT bool boolFromValue(const QByteArray&, bool defaultValue=false);
INDICATEQT_EXPORT QImage imageFromValue(const QByteArray&);
INDICATEQT_EXPORT QDateTime dateTimeFromValue(const QByteArray&);

} // namespace

} // namespace

#endif /* QINDICATEDECODE_H */
