/*
 * Copyright(C) 2010 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Ken VaDine <ken.vandine@canonical.com>
 */

namespace Gwibber
{
    public class Utils : GLib.Object
    {
	private DBus.Connection conn;
	private dynamic DBus.Object bus;
	private string interface_name;

        /** 
            Utils::available:
	    @arg0: bool
            Emitted when the DBus service becomes available
        */

	internal signal void available(bool up);

	internal Utils ()
	{
	}

        construct
        {
        }

	private void on_name_owner_changed (DBus.Object sender, string name, string old_owner, string new_owner)
	{
		if (name == this.interface_name)
		{
			if (new_owner != "" && old_owner == "")
			{
				message ("%s is available", name);
				this.available (true);
			}
			if (old_owner != "" && new_owner == "")
			{
				this.available (false);
				message ("%s is no longer available", name);
			}
		}
	}

	private void list_names_reply_cb (string[] names, GLib.Error e)
	{
		foreach (string name in names) {
			if (name == this.interface_name) {
				message ("%s is available", name);
				this.available (true);
				break;
                	}
        	}
	}

	private bool on_ready ()
	{
		try {
			bus.list_names (list_names_reply_cb);
		} catch (GLib.Error e) {
			warning ("Can't list: %s", e.message);
		}
		return false;
    	}

	internal void setup (string name) throws DBus.Error, GLib.Error
	{
		try {
			this.interface_name = name;
			/* we should use name the name argument to make this more dynamic */
        		conn = DBus.Bus.get (DBus.BusType. SESSION);
			bus = conn.get_object ("org.freedesktop.DBus",
					"/org/freedesktop/DBus",
					"org.freedesktop.DBus");
			bus.NameOwnerChanged.connect(on_name_owner_changed);
			GLib.Idle.add (on_ready);
		} catch (DBus.Error e) {
			warning (e.message);
		}
	}
    }
}
