/*
 * Copyright 2009 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of either or both of the following licenses:
 *
 * 1) the GNU Lesser General Public License version 3, as published by the
 * Free Software Foundation; and/or
 * 2) the GNU Lesser General Public License version 2.1, as published by
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the applicable version of the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of both the GNU Lesser General Public
 * License version 3 and version 2.1 along with this program.  If not, see
 * <http://www.gnu.org/licenses/>
 *
 * Authored by: Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#if HAVE_CONFIG_H
#include <config.h>
#endif

#include "gadget-cairo.h"

G_DEFINE_ABSTRACT_TYPE (GadgetCairo, gadget_cairo, GADGET_TYPE_PROXY);

#define GADGET_CAIRO_GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE ((obj),\
  GADGET_TYPE_CAIRO, \
  GadgetCairoPrivate))

struct _GadgetCairoPrivate
{
  cairo_surface_t *surface;
};

enum
{
  PROP_0,
};

/* Globals */

/* Forwards */


/* GObject stuff */
static void
gadget_cairo_finalize (GObject *object)
{
  GadgetCairoPrivate *priv = GADGET_CAIRO_GET_PRIVATE (object);

  if (priv->surface)
    {
      cairo_surface_destroy (priv->surface);
      priv->surface = NULL;
    }

  G_OBJECT_CLASS (gadget_cairo_parent_class)->finalize (object);
}

static void
gadget_cairo_set_property (GObject      *object,
                           guint         prop_id,
                           const GValue *value,
                           GParamSpec   *pspec)
{
  //GadgetCairo *self = GADGET_CAIRO (object);

  switch (prop_id)
    {
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
      break;
    }
}

static void
gadget_cairo_get_property (GObject    *object,
                           guint       prop_id,
                           GValue     *value,
                           GParamSpec *pspec)
{
  //GadgetCairo *self = GADGET_CAIRO (object);

  switch (prop_id)
    {
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
      break;
    }
}

static void
gadget_cairo_class_init (GadgetCairoClass *klass)
{
  GObjectClass *obj_class = G_OBJECT_CLASS (klass);
  //GParamSpec   *pspec;

  /* Overrides */
  obj_class->finalize        = gadget_cairo_finalize;
  obj_class->set_property    = gadget_cairo_set_property;
  obj_class->get_property    = gadget_cairo_get_property;

  /* Install Properties */

  /* Add signals */

  /* Add Private struct */
  g_type_class_add_private (obj_class, sizeof (GadgetCairoPrivate));
}

static void
gadget_cairo_init (GadgetCairo *self)
{
  GadgetCairoPrivate *priv;

  priv = self->priv = GADGET_CAIRO_GET_PRIVATE (self);
}

/*
 * Private methods
 */

/*
 * Public methods
 */
void
gadget_cairo_draw (GadgetCairo *self,
                   cairo_t     *cr)
{
  GadgetCairoClass *klass;

  g_return_if_fail (GADGET_IS_CAIRO (self));
  g_return_if_fail (cr);
  klass = GADGET_CAIRO_GET_CLASS (self);

  if (klass->draw)
    klass->draw (self, cr);
}
