# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###







import  gtk
import gobject

import utils
from helper import helper
from library import library_wrapper 
from song import sType

class SongTimer(gtk.VBox):
    __gsignals__ = {
        "play-end" : (gobject.SIGNAL_RUN_LAST,gobject.TYPE_NONE,())
    }
    def __init__(self,player):
        super(SongTimer,self).__init__()

        self.player = player
        self.label_time = gtk.Label("<span size=\"small\">00:00 "+_("of")+" 00:00</span>")
        self.label_time.set_alignment(1,1)
        self.label_time.set_use_markup(True)

        self.bar = gtk.HScale()
        self.bar.set_draw_value(False)
        self.bar.set_range(0,1000)
        self.bar.set_value(0)
        self.bar.connect("button_press_event", self.on_bar_press)
        self.bar.connect("button_release_event", self.on_bar_release)

        self.pack_start(self.bar,False,False)
        #self.pack_start(self.label_time,False,False)
        self.update_bar = 1
        self.duration = 0
        self.delete = False
        self.report = False


        player.connect("instant-new-song",self.set_duration)

        gobject.timeout_add(1000, self.on_timeout)
        
    def get_label(self):
        return self.label_time
    
    def stop(self):
        self.delete = True

    def set_duration(self,player,song):
        self.report = True    
        self.duration = song.get("#duration")
        self.set_current_time(0)

    def on_timeout(self):
        if self.update_bar == 1:
            pos = self.player.get_position()
            if pos>=0:
                self.set_current_time(pos)
        return not self.delete

    def set_current_time(self,value):
        #duration = self.duration
        duration = self.player.get_length()
        if self.update_bar == 1:
            if duration==0:
                self.bar.set_range(0,1000)
                self.bar.set_value(1000)
            else :
                if value>=duration:
                    duration=value+1000
                self.bar.set_range(0,duration/1000)
                self.bar.set_value(value/1000)

        text  = utils.duration_to_string(value,"00:00")+" "+_("of")+" "+utils.duration_to_string(duration,"00:00")
        self.label_time.set_label("<span size=\"small\">"+text+"</span>")

        if self.report and duration>10 and value >= min(duration/2, 240*1000):
            self.report = False
            s = library_wrapper.get_song(self.player.song.get("uri"))
            if s:
                s.update_played_information()
                helper.report_song(s)

    def on_bar_press(self,widget,event):
        self.update_bar = 0
        self.report = False

    def on_bar_release(self,widget,event):
        self.update_bar = 1
        if self.player.song!=None and self.player.song.get_type() in sType.webradio:
            return
        
        value = self.bar.get_value()

        self.player.seek(value*1000)
