# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###
#    From quodlibet 
###
LISTEN = "listen"

ALBUM_ART = 'listen_cover'
MEDIA_LIB = 'listen'
LASTFM = "source/lastfm_mini"
DYNAMIC = "dynamic"

WIKI_USERS = 'users'
WIKI_CD = 'cd'
PREF_OSD = "osd"
PREF_PODCAST = "pref_podcast"
PREF_LASTFM = "source/lastfm_mini"

SRC_BIBLIO = 'source/biblio'
SRC_DAAP = 'source/biblio'
SRC_IPOD = 'source/ipod'
SRC_PLAYLIST = 'source/playlist'
SRC_PLAYLIST_SMART = 'source/playlist_smart'
SRC_PLAYLIST_IPOD = 'source/playlist_ipod'
SRC_PODCAST_IPOD = 'source/podcast_ipod'
SRC_IRADIO='source/iradio'
SRC_WIKIPEDIA = "source/wikipedia"
SRC_LASTFM = "source/lastfm_mini"
SRC_PODCAST = "source/podcast"
SRC_LYRICS = "source/lyrics"



_ICONS = [SRC_DAAP,LISTEN,MEDIA_LIB,LASTFM,DYNAMIC,WIKI_USERS,WIKI_CD,\
        PREF_OSD,PREF_PODCAST,PREF_LASTFM,\
        SRC_BIBLIO,SRC_IPOD,SRC_PLAYLIST,SRC_PLAYLIST_IPOD,SRC_PODCAST_IPOD,\
        SRC_IRADIO,SRC_WIKIPEDIA,SRC_LASTFM,SRC_PODCAST,SRC_LYRICS,SRC_PLAYLIST_SMART]

IMPORT_FOLDER = "importfolder"
IMPORT_FILE = "importfile"
EDIT = "edit"
RENAME = "rename"
ENQUEUE = "enqueue"
PLAY = "play"
WIKI_ARTIST = "wiki-artist"
WIKI_ALBUM = "wiki-album"
LYRICS = "lyrics"
DELETE = "delete"
DELETE_DISK = "delete-disk"
MUSICBRAINZ = "musicbrainz"
NEW_PODCAST = "new-podcast"
NEW_RADIO = "new-radio"
EDIT_RADIO = "edit-radio"
ADD_FAVORITE = "add-favorite"
EXPORT = "export"
RELOAD_LIBRARY = "reload-library"
SHUFFLE = "stock_shuffle"
BURN = "burn"

import gtk,gobject
import const
factory = gtk.IconFactory()

def stock_init():
    import gtk
    for fn in _ICONS:
        pb = gtk.gdk.pixbuf_new_from_file(const.PIXMAP_DIR+fn+".png")
        factory.add(fn, gtk.IconSet(pb))
    factory.add_default()
    gtk.stock_add([
            (EDIT, _("_Edit"), 0, 0, ""),
            (RENAME, _("_Rename"), 0, 0, ""),
            (ENQUEUE, _("En_queue"), 0, 0, ""),
            (PLAY, _("_Play"), 0, 0, ""),
            (WIKI_ARTIST, _("About _artist"), 0, 0, ""),
            (WIKI_ALBUM, _("About a_lbum"), 0, 0, ""),
            (LYRICS, _("See _Lyrics"), 0, 0, ""),
            (DELETE, _('Remove'), 0, 0, ""),
            (DELETE_DISK, _('Move to trash'), 0, 0, ""),
            (SRC_PLAYLIST, _('_New Playlist'), 0, 0, ""),
            (SRC_PLAYLIST_SMART, _('New _Automatique Playlist...'), 0, 0, ""),
            (IMPORT_FOLDER,_('_Import Folder...'), 0, 0, ""),
            (IMPORT_FILE,_('_Import _File...'), 0, 0, ""),
            (MUSICBRAINZ,_('_Get file informations'), 0, 0, ""),
            (NEW_PODCAST,_('_New Podcast feed'), 0, 0, ""),
            (NEW_RADIO,_('_New Web Radio'), 0, 0, ""),
            (ADD_FAVORITE,_('_Add to favorite'), 0, 0, ""),
            (EDIT_RADIO,_("Edit Web Radio"), 0, 0, ""),
            (EXPORT,_("Export"),0,0,""),
            (RELOAD_LIBRARY,_("Reload Library"),0,0,""),
            (SHUFFLE,_("Shuffle"),0,0,""),
            (BURN,_("Burn"),0,0,"")
            
            ])

    icons = gtk.IconFactory()
    lookup = gtk.icon_factory_lookup_default
   
    icons.add(NEW_PODCAST,lookup(gtk.STOCK_NEW))
    icons.add(NEW_RADIO,lookup(gtk.STOCK_NEW))
    icons.add(EDIT_RADIO,lookup(gtk.STOCK_EDIT))    
    icons.add(EDIT, lookup(gtk.STOCK_PROPERTIES))
    icons.add(IMPORT_FOLDER, lookup(gtk.STOCK_OPEN))
    icons.add(IMPORT_FILE, lookup(gtk.STOCK_FILE))
    icons.add(RENAME, lookup(gtk.STOCK_EDIT))
    icons.add(ENQUEUE, lookup(gtk.STOCK_ADD))
    icons.add(PLAY, lookup(gtk.STOCK_MEDIA_PLAY))
    icons.add(WIKI_ARTIST, lookup(gtk.STOCK_ABOUT))
    icons.add(WIKI_ALBUM, lookup(gtk.STOCK_ABOUT))
    icons.add(LYRICS, lookup(gtk.STOCK_EDIT))
    icons.add(DELETE, lookup(gtk.STOCK_REMOVE))
    icons.add(DELETE_DISK, lookup(gtk.STOCK_DELETE))
    icons.add(MUSICBRAINZ, lookup(gtk.STOCK_NETWORK))
    icons.add(ADD_FAVORITE, lookup(gtk.STOCK_CONVERT))
    icons.add(EXPORT, lookup(gtk.STOCK_SAVE_AS))
    icons.add(RELOAD_LIBRARY, lookup(gtk.STOCK_REFRESH))
    icons.add(BURN,lookup(gtk.STOCK_CDROM))
    try:icons.add(SHUFFLE,  gtk.IconSet(gtk.icon_theme_get_default().load_icon("stock_shuffle",-1,gtk.ICON_LOOKUP_USE_BUILTIN)))
    except gobject.GError:pass 
        
    icons.add_default()
