# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###

import gobject

import stock

from  _source import Source,SourceItem
from widget.webinfo.lyrics import LyricsBox
from widget.webinfo.wikipedia import WikiBox
from widget.webinfo.lastfm import LastFmBox
from widget.context import *


class LyricsSource(Source):
    display_index = 20    
    def __init__(self,player):
        Source.__init__(self,player)
        self.items.append(SourceItem(player,stock.SRC_LYRICS,_("Lyrics"),LyricsBox(player),"lyrics"))
        self.items[0].source_id = "lyrics"

class WikiSource(Source):
    display_index = 30    
    def __init__(self,player):
        Source.__init__(self,player)
        self.items.append(SourceItem(player,stock.SRC_WIKIPEDIA,_("Wikipedia"),WikiBox(player),"wikipedia"))
        self.items[0].source_id = "wikipedia"
        
class LastFmSource(Source):
    display_index = 40    
    def __init__(self,player):
        Source.__init__(self,player)
        self.items.append(SourceItem(player,stock.SRC_LASTFM,_("LastFm"),LastFmBox(player),"lastfm"))
        
class ContextSource(Source):
    display_index = 0   
    def __init__(self,player):
        Source.__init__(self,player)
        
    def load(self,player):
        #Create widget in load because must wait local library are loaded
        self.items.append(SourceItem(player,gtk.STOCK_HOME,_("Context"),ContextBox(player),"context"))    
        #gobject.timeout_add(5000,self.items[0].widget.refresh)
        self.items[0].widget.refresh()
        
class CurrentInfoSource(Source):
    display_index = 10 
    def __init__(self,player):
        Source.__init__(self,player)
        
    def load(self,player):
        #Create widget in load because must wait local library are loaded
        self.items.append(SourceItem(player,gtk.STOCK_INFO,_("Current"),CurrentInfoBox(player),"current"))    
        #gobject.timeout_add(5000,self.items[0].widget.refresh)
        
